<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.15
Name: Prescrizione farmaceutica
Description: First Aid Report
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133">
   <title>Prescrizione farmaceutica</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]"
         id="d44e31010-false-d4377321e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('DOCCLIN')">(Prescrizione farmaceutica): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@moodCode) = ('EVN')">(Prescrizione farmaceutica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:realmCode[@code = 'IT' or @nullFlavor]) &gt;= 1">(Prescrizione farmaceutica): element hl7:realmCode[@code = 'IT' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:realmCode[@code = 'IT' or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:realmCode[@code = 'IT' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']) &gt;= 1">(Prescrizione farmaceutica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']) &lt;= 1">(Prescrizione farmaceutica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']) &gt;= 1">(Prescrizione farmaceutica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']) &lt;= 1">(Prescrizione farmaceutica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id) &gt;= 1">(Prescrizione farmaceutica): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id) &lt;= 1">(Prescrizione farmaceutica): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Prescrizione farmaceutica): element hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Prescrizione farmaceutica): element hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:title) &lt;= 1">(Prescrizione farmaceutica): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">(Prescrizione farmaceutica): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">(Prescrizione farmaceutica): element hl7:effectiveTime[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Prescrizione farmaceutica): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Prescrizione farmaceutica): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:languageCode[@code = 'it-IT']) &gt;= 1">(Prescrizione farmaceutica): element hl7:languageCode[@code = 'it-IT'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:languageCode[@code = 'it-IT']) &lt;= 1">(Prescrizione farmaceutica): element hl7:languageCode[@code = 'it-IT'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:setId) &lt;= 1">(Prescrizione farmaceutica): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:versionNumber) &lt;= 1">(Prescrizione farmaceutica): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">(Prescrizione farmaceutica): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]) &gt;= 1">(Prescrizione farmaceutica): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:realmCode[@code = 'IT' or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:realmCode[@code = 'IT' or @nullFlavor]"
         id="d44e31025-false-d4378209e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or (@code='IT')">(Prescrizione farmaceutica): The element value SHALL be one of 'code 'IT''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_HD000040']"
         id="d44e31034-false-d4378223e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@extension) = ('POCD_HD000040')">(Prescrizione farmaceutica): The value for extension SHALL be 'POCD_HD000040'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']"
         id="d44e31046-false-d4378242e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.2')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:id"
         id="d44e31074-false-d4378259e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@root">(Prescrizione farmaceutica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione farmaceutica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@assigningAuthorityName">(Prescrizione farmaceutica): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:code[(@code = '59258-4' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e31106-false-d4378281e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or (@code='59258-4' and @codeSystem='2.16.840.1.113883.6.1' and @codeSystemName='LOINC')">(Prescrizione farmaceutica): The element value SHALL be one of 'code '59258-4' codeSystem '2.16.840.1.113883.6.1' codeSystemName='LOINC''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@displayName) = ('Verbale di Pronto Soccorso')">(Prescrizione farmaceutica): The value for displayName SHALL be 'Verbale di Pronto Soccorso'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@codeSystemVersion">(Prescrizione farmaceutica): attribute @codeSystemVersion SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:title
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:effectiveTime[not(@nullFlavor)]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:effectiveTime[not(@nullFlavor)]"
         id="d44e31121-false-d4378309e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@value">(Prescrizione farmaceutica): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e31136-false-d4378323e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:languageCode[@code = 'it-IT']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:languageCode[@code = 'it-IT']"
         id="d44e31158-false-d4378341e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or (@code='it-IT')">(Prescrizione farmaceutica): The element value SHALL be one of 'code 'it-IT''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:setId
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:setId"
         id="d44e31168-false-d4378354e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@root">(Prescrizione farmaceutica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione farmaceutica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@assigningAuthorityName">(Prescrizione farmaceutica): attribute @assigningAuthorityName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@assigningAuthorityName) or (string-length(@assigningAuthorityName) &gt; 0 and not(matches(@assigningAuthorityName,'\s')))">(Prescrizione farmaceutica): Attribute @assigningAuthorityName SHALL be of data type 'cs'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:versionNumber
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:versionNumber"
         id="d44e31208-false-d4378377e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@value">(Prescrizione farmaceutica): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(Prescrizione farmaceutica): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]"
         id="d44e31217-false-d4378399e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('RCT')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextControlCode) = ('OP')">(Prescrizione farmaceutica): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:patientRole[@classCode = 'PAT']) &gt;= 1">(Prescrizione farmaceutica): element hl7:patientRole[@classCode = 'PAT'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:patientRole[@classCode = 'PAT']) &lt;= 1">(Prescrizione farmaceutica): element hl7:patientRole[@classCode = 'PAT'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']"
         id="d44e31279-false-d4378440e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('PAT')">(Prescrizione farmaceutica): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(Prescrizione farmaceutica): element hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]
Item: (Paziente ID tipo 1)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]"
         id="d4378437e82-false-d4378504e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.7')">(Paziente ID tipo 1): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.7'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 1): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 1): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@assigningAuthorityName) = ('ISTITUZIONE ESTERA') or not(@assigningAuthorityName)">(Paziente ID tipo 1): The value for assigningAuthorityName SHALL be 'ISTITUZIONE ESTERA'. Found: "<value-of select="@assigningAuthorityName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 1): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]
Item: (Paziente ID tipo 1)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]"
         id="d4378437e113-false-d4378525e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.3')">(Paziente ID tipo 1): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 1): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 1): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@assigningAuthorityName) = ('ISTITUZIONE ESTERA') or not(@assigningAuthorityName)">(Paziente ID tipo 1): The value for assigningAuthorityName SHALL be 'ISTITUZIONE ESTERA'. Found: "<value-of select="@assigningAuthorityName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 1): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[3]
Item: (Paziente ID tipo 1)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[3]"
         id="d4378437e144-false-d4378546e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.3')">(Paziente ID tipo 1): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 1): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 1): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="string(@assigningAuthorityName) = ('ISTITUZIONE ESTERA') or not(@assigningAuthorityName)">(Paziente ID tipo 1): The value for assigningAuthorityName SHALL be 'ISTITUZIONE ESTERA'. Found: "<value-of select="@assigningAuthorityName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.1-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 1): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]
Item: (Paziente ID tipo 2)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]"
         id="d4378563e33-false-d4378568e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.7')">(Paziente ID tipo 2): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.7'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 2): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 2): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]
Item: (Paziente ID tipo 2)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]"
         id="d4378563e66-false-d4378586e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.3')">(Paziente ID tipo 2): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 2): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 2): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.2-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.3
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]
Item: (Paziente ID tipo 3)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]"
         id="d4378600e27-false-d4378605e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.3-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.7')">(Paziente ID tipo 3): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.7'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.3-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 3): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.3-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 3): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.3-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 3): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.4
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]
Item: (Paziente ID tipo 4)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[1]"
         id="d4378619e36-false-d4378624e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')">(Paziente ID tipo 4): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 4): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 4): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="string(@assigningAuthorityName) = ('Ministero Economia e Finanze') or not(@assigningAuthorityName)">(Paziente ID tipo 4): The value for assigningAuthorityName SHALL be 'Ministero Economia e Finanze'. Found: "<value-of select="@assigningAuthorityName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 4): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.4
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]
Item: (Paziente ID tipo 4)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:id[2]"
         id="d4378619e62-false-d4378645e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.3')">(Paziente ID tipo 4): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="@extension">(Paziente ID tipo 4): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Paziente ID tipo 4): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.4-2018-03-19T000000.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Paziente ID tipo 4): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:telecom
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
         id="d44e31318-false-d4378681e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('PSN')">(Prescrizione farmaceutica): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@determinerCode) = ('INSTANCE')">(Prescrizione farmaceutica): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id) &lt;= 1">(Prescrizione farmaceutica): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:birthTime) &lt;= 1">(Prescrizione farmaceutica): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31346-false-d4378747e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthTime
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]"
         id="d44e31353-false-d4378772e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('BIRTHPL')">(Prescrizione farmaceutica): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &gt;= 1">(Prescrizione farmaceutica): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &lt;= 1">(Prescrizione farmaceutica): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']"
         id="d44e31357-false-d4378792e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('PLC')">(Prescrizione farmaceutica): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@determinerCode) = ('INSTANCE')">(Prescrizione farmaceutica): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:name) &lt;= 1">(Prescrizione farmaceutica): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:addr) &lt;= 1">(Prescrizione farmaceutica): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:name
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:recordTarget[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT']/hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]"
         id="d44e31372-false-d4378851e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('AUT')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextControlCode) = ('OP')">(Prescrizione farmaceutica): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &gt;= 1">(Prescrizione farmaceutica): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &lt;= 1">(Prescrizione farmaceutica): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31396-false-d4378911e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:time
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
         id="d44e31410-false-d4378952e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ASSIGNED')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1">(Prescrizione farmaceutica): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code) &lt;= 1">(Prescrizione farmaceutica): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:representedOrganization) &lt;= 1">(Prescrizione farmaceutica): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
         id="d44e31414-false-d4379001e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:code
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:telecom
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:author[not(@nullFlavor)][@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor[@classCode = 'ASSIGNED']]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.103
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]
Item: (CDA dataEnterer)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]"
         id="d4379192e109-false-d4379470e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.103-2005-09-07T000000.html"
              test="string(@typeCode) = ('ENT') or not(@typeCode)">(CDA dataEnterer): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.103-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA dataEnterer): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.103-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEnterer): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.103-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEnterer): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.103-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEnterer): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.103
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time
Item: (CDA dataEnterer)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.103
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEnterer)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.154
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant
Item: (CDA Informant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant"
         id="d4379549e148-false-d4380000e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.154-2005-09-07T000000.html"
              test="string(@typeCode) = ('INF') or not(@typeCode)">(CDA Informant): The value for typeCode SHALL be 'INF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.154-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Informant): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.154-2005-09-07T000000.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity[@classCode]) &gt;= 1">(CDA Informant): choice (hl7:assignedEntity  or  hl7:relatedEntity[@classCode]) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.154-2005-09-07T000000.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity[@classCode]) &lt;= 1">(CDA Informant): choice (hl7:assignedEntity  or  hl7:relatedEntity[@classCode]) contains too many elements [max 1x]</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.154
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity
Item: (CDA Informant)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.154
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]
Item: (CDA Informant)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]
Item: (CDA RelatedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="@classCode">(CDA RelatedEntity): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19316-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA RelatedEntity): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19316' RoleClassMutualRelationship (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA RelatedEntity): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA RelatedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="count(hl7:relatedPerson) &lt;= 1">(CDA RelatedEntity): element hl7:relatedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA RelatedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.316-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.19563-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA RelatedEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.19563 PersonalRelationshipRoleType (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:addr
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:telecom
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:effectiveTime
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.316
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson
Item: (CDA RelatedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informant/hl7:relatedEntity[@classCode]/hl7:relatedPerson/hl7:name
Item: (CDA Person)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]"
         id="d44e31455-false-d4380663e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('CST')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]"
         id="d44e31464-false-d4380683e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ASSIGNED')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1">(Prescrizione farmaceutica): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(Prescrizione farmaceutica): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d44e31468-false-d4380703e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ORG')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@determinerCode) = ('INSTANCE')">(Prescrizione farmaceutica): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Prescrizione farmaceutica): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:name) &lt;= 1">(Prescrizione farmaceutica): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:telecom) &lt;= 1">(Prescrizione farmaceutica): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:addr) &lt;= 1">(Prescrizione farmaceutica): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[not(@nullFlavor)]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[not(@nullFlavor)]"
         id="d44e31479-false-d4380743e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@root">(Prescrizione farmaceutica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione farmaceutica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:custodian[not(@nullFlavor)][@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]
Item: (CDA informationRecipient)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]"
         id="d4380779e17-false-d4380796e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="@typeCode">(CDA informationRecipient): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19366-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19366' x_InformationRecipient (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="count(hl7:intendedRecipient[@classCode]) &gt;= 1">(CDA informationRecipient): element hl7:intendedRecipient[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="count(hl7:intendedRecipient[@classCode]) &lt;= 1">(CDA informationRecipient): element hl7:intendedRecipient[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]
Item: (CDA informationRecipient)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]"
         id="d4380779e26-false-d4380847e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="@classCode">(CDA informationRecipient): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.16772-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.16772' x_InformationRecipientRole (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="count(hl7:informationRecipient) &lt;= 1">(CDA informationRecipient): element hl7:informationRecipient appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.105-2005-09-07T000000.html"
              test="count(hl7:receivedOrganization) &lt;= 1">(CDA informationRecipient): element hl7:receivedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:id
Item: (CDA informationRecipient)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:addr
Item: (CDA informationRecipient)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:telecom
Item: (CDA informationRecipient)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:informationRecipient
Item: (CDA informationRecipient)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:informationRecipient
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:informationRecipient">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:informationRecipient/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.105
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization
Item: (CDA informationRecipient)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:informationRecipient[@typeCode][hl7:intendedRecipient[@classCode]]/hl7:intendedRecipient[@classCode]/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]"
         id="d44e31506-false-d4381255e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('LA')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextControlCode) = ('OP')">(Prescrizione farmaceutica): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &gt;= 1">(Prescrizione farmaceutica): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &lt;= 1">(Prescrizione farmaceutica): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:signatureCode[@code = 'S' or @nullFlavor]) &gt;= 1">(Prescrizione farmaceutica): element hl7:signatureCode[@code = 'S' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:signatureCode[@code = 'S' or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:signatureCode[@code = 'S' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:time
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:signatureCode[@code = 'S' or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:signatureCode[@code = 'S' or @nullFlavor]"
         id="d44e31527-false-d4381316e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or (@code='S')">(Prescrizione farmaceutica): The element value SHALL be one of 'code 'S''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
         id="d44e31536-false-d4381340e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ASSIGNED')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1">(Prescrizione farmaceutica): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code) &lt;= 1">(Prescrizione farmaceutica): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:representedOrganization) &lt;= 1">(Prescrizione farmaceutica): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
         id="d44e31540-false-d4381396e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:code
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:telecom
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S' or @nullFlavor]]/hl7:assignedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.107
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]
Item: (CDA authenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]"
         id="d4381494e109-false-d4381775e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">(CDA authenticator): The value for typeCode SHALL be 'AUTHEN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA authenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA authenticator): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &gt;= 1">(CDA authenticator): element hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA authenticator): element hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA authenticator): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA authenticator): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.107
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:time
Item: (CDA authenticator)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.107
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA authenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d4381494e115-false-d4381843e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.107-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA authenticator): The element value SHALL be one of '2.16.840.1.113883.1.11.10282 ParticipationSignature (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.107
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity
Item: (CDA authenticator)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authenticator[hl7:signatureCode[@code = doc('include/voc-2.16.840.1.113883.1.11.10282-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]"
         id="d44e31574-false-d4382315e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@typeCode">(Prescrizione farmaceutica): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione farmaceutica): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextControlCode) = ('OP')">(Prescrizione farmaceutica): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &lt;= 1">(Prescrizione farmaceutica): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(Prescrizione farmaceutica): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(Prescrizione farmaceutica): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31595-false-d4382378e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d44e31603-false-d4382413e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@classCode">(Prescrizione farmaceutica): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione farmaceutica): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code) &lt;= 1">(Prescrizione farmaceutica): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:associatedPerson) &lt;= 1">(Prescrizione farmaceutica): element hl7:associatedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:scopingOrganization) &lt;= 1">(Prescrizione farmaceutica): element hl7:scopingOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d44e31610-false-d4382476e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@root">(Prescrizione farmaceutica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione farmaceutica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:participant[@contextControlCode = 'OP'][@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]
Item: (CDA inFulfillmentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]"
         id="d4382575e109-false-d4382835e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="count(hl7:order[@moodCode = 'RQO']) &gt;= 1">(CDA inFulfillmentOf): element hl7:order[@moodCode = 'RQO'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="count(hl7:order[@moodCode = 'RQO']) &lt;= 1">(CDA inFulfillmentOf): element hl7:order[@moodCode = 'RQO'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']
Item: (CDA inFulfillmentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']"
         id="d4382575e113-false-d4382855e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="string(@moodCode) = ('RQO')">(CDA inFulfillmentOf): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA inFulfillmentOf): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']/hl7:id
Item: (CDA inFulfillmentOf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']/hl7:code
Item: (CDA inFulfillmentOf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA inFulfillmentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:inFulfillmentOf[hl7:order[@moodCode = 'RQO']]/hl7:order[@moodCode = 'RQO']/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d4382575e126-false-d4382911e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.109-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA inFulfillmentOf): The element value SHALL be one of '2.16.840.1.113883.1.11.16866 ActPriority (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]"
         id="d44e31643-false-d4382946e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('DOC')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'DOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1">(Prescrizione farmaceutica): element hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1">(Prescrizione farmaceutica): element hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']"
         id="d44e31652-false-d4383002e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ACT')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@moodCode) = ('EVN')">(Prescrizione farmaceutica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code) &lt;= 1">(Prescrizione farmaceutica): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Prescrizione farmaceutica): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:effectiveTime
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]"
         id="d44e31681-false-d4383097e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@typeCode">(Prescrizione farmaceutica): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19601-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione farmaceutica): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19601' x_ServiceEventPerformer (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &lt;= 1">(Prescrizione farmaceutica): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity) &gt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31703-false-d4383164e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:time
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:documentationOf[@typeCode = 'DOC'][hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:serviceEvent[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]"
         id="d44e31715-false-d4383634e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@typeCode">(Prescrizione farmaceutica): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione farmaceutica): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']) &gt;= 1">(Prescrizione farmaceutica): element hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']) &lt;= 1">(Prescrizione farmaceutica): element hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']"
         id="d44e31734-false-d4383665e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('DOCCLIN')">(Prescrizione farmaceutica): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@moodCode) = ('EVN')">(Prescrizione farmaceutica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:id) &gt;= 1">(Prescrizione farmaceutica): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:text) &lt;= 1">(Prescrizione farmaceutica): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:setId) &lt;= 1">(Prescrizione farmaceutica): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:versionNumber) &lt;= 1">(Prescrizione farmaceutica): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or @nullFlavor]"
         id="d44e31742-false-d4383721e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(Prescrizione farmaceutica): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:text
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:setId
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:relatedDocument[@typeCode][hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']]/hl7:parentDocument[@classCode = 'DOCCLIN'][@moodCode = 'EVN']/hl7:versionNumber
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.114
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]
Item: (CDA Authorization)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]"
         id="d4383752e17-false-d4383759e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUTH') or not(@typeCode)">(CDA Authorization): The value for typeCode SHALL be 'AUTH'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="count(hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]) &gt;= 1">(CDA Authorization): element hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="count(hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]) &lt;= 1">(CDA Authorization): element hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.114
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]
Item: (CDA Authorization)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]"
         id="d4383752e21-false-d4383781e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="string(@classCode) = ('CONS') or not(@classCode)">(CDA Authorization): The value for classCode SHALL be 'CONS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA Authorization): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Authorization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(CDA Authorization): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(CDA Authorization): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.114
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]/hl7:id
Item: (CDA Authorization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.114
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]/hl7:code
Item: (CDA Authorization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.114
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (CDA Authorization)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:authorization[hl7:consent]/hl7:consent[hl7:statusCode[@code = 'completed' or @nullFlavor]]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d4383752e34-false-d4383833e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.114-2005-09-07T000000.html"
              test="@nullFlavor or (@code='completed')">(CDA Authorization): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]"
         id="d44e31758-false-d4383894e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']) &gt;= 1">(Prescrizione farmaceutica): element hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']) &lt;= 1">(Prescrizione farmaceutica): element hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']"
         id="d44e31774-false-d4384010e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ENC')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@moodCode) = ('EVN')">(Prescrizione farmaceutica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Prescrizione farmaceutica): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Prescrizione farmaceutica): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:dischargeDispositionCode) &lt;= 1">(Prescrizione farmaceutica): element hl7:dischargeDispositionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:responsibleParty[@typeCode = 'RESP']) &lt;= 1">(Prescrizione farmaceutica): element hl7:responsibleParty[@typeCode = 'RESP'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &lt;= 1">(Prescrizione farmaceutica): element hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31788-false-d4384128e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime"
         id="d44e31793-false-d4384145e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:low) &gt;= 1">(Prescrizione farmaceutica): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:low) &lt;= 1">(Prescrizione farmaceutica): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:high) &gt;= 1">(Prescrizione farmaceutica): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:high) &lt;= 1">(Prescrizione farmaceutica): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime/hl7:low
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime/hl7:low"
         id="d44e31813-false-d4384169e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@value">(Prescrizione farmaceutica): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Prescrizione farmaceutica): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime/hl7:high
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:effectiveTime/hl7:high"
         id="d44e31822-false-d4384182e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@value">(Prescrizione farmaceutica): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(Prescrizione farmaceutica): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:dischargeDispositionCode
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']">
      <extends rule="d4384231e0-false-d4384235e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('RESP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1" id="d4384231e0-false-d4384235e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:responsibleParty[@typeCode = 'RESP']/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]"
         id="d44e31852-false-d4384655e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@typeCode">(Prescrizione farmaceutica): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19600-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione farmaceutica): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19600' x_EncounterParticipant (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:time) &lt;= 1">(Prescrizione farmaceutica): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity) &gt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:assignedEntity) &lt;= 1">(Prescrizione farmaceutica): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:time
Item: (Prescrizione farmaceutica)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.153-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA AssignedEntity): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:encounterParticipant[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]"
         id="d44e31879-false-d4385175e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('LOC')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:healthCareFacility[@classCode = 'SDLOC']) &gt;= 1">(Prescrizione farmaceutica): element hl7:healthCareFacility[@classCode = 'SDLOC'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:healthCareFacility[@classCode = 'SDLOC']) &lt;= 1">(Prescrizione farmaceutica): element hl7:healthCareFacility[@classCode = 'SDLOC'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']"
         id="d44e31883-false-d4385219e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('SDLOC')">(Prescrizione farmaceutica): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:location) &lt;= 1">(Prescrizione farmaceutica): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(Prescrizione farmaceutica): element hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:id
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:id"
         id="d44e31896-false-d4385268e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@root">(Prescrizione farmaceutica): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione farmaceutica): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e31906-false-d4385289e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:location
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.317
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:location
Item: (CDA Place)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:location">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.317-2005-09-07T000000.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA Place): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.317-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Place): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.317-2005-09-07T000000.html"
              test="count(hl7:name) &lt;= 1">(CDA Place): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.317-2005-09-07T000000.html"
              test="count(hl7:addr) &lt;= 1">(CDA Place): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.317
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:location/hl7:name
Item: (CDA Place)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.317
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:location/hl7:addr
Item: (CDA Place)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d4385491e0-false-d4385495e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('ORG')">(Prescrizione farmaceutica): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@determinerCode) = ('INSTANCE')">(Prescrizione farmaceutica): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(Prescrizione farmaceutica): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.2']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.2')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (Prescrizione farmaceutica)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('PART')">(Prescrizione farmaceutica): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1']
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.1']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.1')">(Prescrizione farmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@extension">(Prescrizione farmaceutica): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="not(@extension) or (string-length(@extension) &gt; 0 and not(matches(@extension,'\s')))">(Prescrizione farmaceutica): Attribute @extension SHALL be of data type 'cs'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDA Organization)
-->
   <rule fpi="RULC-1" id="d4385491e0-false-d4385495e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:componentOf[@typeCode = 'COMP'][hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']]/hl7:encompassingEncounter[@classCode = 'ENC'][@moodCode = 'EVN']/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC']/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]"
         id="d44e32001-false-d4386215e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1">(Prescrizione farmaceutica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1">(Prescrizione farmaceutica): element hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']"
         id="d44e32020-false-d4387180e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@classCode) = ('DOCBODY')">(Prescrizione farmaceutica): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@moodCode) = ('EVN')">(Prescrizione farmaceutica): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Prescrizione farmaceutica): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]) &gt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]) &gt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]) &gt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.50']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.50']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.23']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.23']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.26']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.26']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.27']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.27']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.28']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.28']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.29']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.29']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.24']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.24']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.34']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.34']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]]) &lt;= 1">(Prescrizione farmaceutica): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.74']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Prescrizione farmaceutica)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e32026-false-d4387809e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Prescrizione farmaceutica): The element value SHALL be one of '2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]
Item: (Modalità di trasporto (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]
Item: (Modalità di trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Modalità di trasporto (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Modalità di trasporto (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']) &gt;= 1">(Modalità di trasporto (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']) &lt;= 1">(Modalità di trasporto (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Modalità di trasporto (VPS)): element hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Modalità di trasporto (VPS)): element hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Modalità di trasporto (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Modalità di trasporto (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Modalità di trasporto (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]) &gt;= 1">(Modalità di trasporto (VPS)): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]) &lt;= 1">(Modalità di trasporto (VPS)): element hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']
Item: (Modalità di trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.20')">(Modalità di trasporto (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.20'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Modalità di trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:code[(@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '11459-5' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="@nullFlavor or (@code='11459-5' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Modalità di Trasporto' and @codeSystemName='LOINC')">(Modalità di trasporto (VPS)): The element value SHALL be one of 'code '11459-5' codeSystem '2.16.840.1.113883.6.1' displayName='Modalità di Trasporto' codeSystemName='LOINC''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@code) = ('11459-5')">(Modalità di trasporto (VPS)): The value for code SHALL be '11459-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Modalità di trasporto (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Modalità di trasporto (VPS)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Modalità di trasporto (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Modalità di trasporto (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:title
Item: (Modalità di trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="text()='Modalità di trasporto'">(Modalità di trasporto (VPS)): the element content of hl7:title SHALL be ''Modalità di trasporto''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:text
Item: (Modalità di trasporto (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.20
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]
Item: (Modalità di trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Modalità di trasporto (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.20-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Modalità di trasporto (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]
Item: (Trasporto (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@classCode) = ('TRNS')">(Trasporto (VPS)): The value for classCode SHALL be 'TRNS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Trasporto (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']) &gt;= 1">(Trasporto (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']) &lt;= 1">(Trasporto (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Trasporto (VPS)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Trasporto (VPS)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Trasporto (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Trasporto (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Trasporto (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &gt;= 1">(Trasporto (VPS)): element hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]) &lt;= 1">(Trasporto (VPS)): element hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.40')">(Trasporto (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.40'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.6' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.6.1.54.6-2022-12-12T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Trasporto (VPS)): The element value SHALL be one of '2.16.840.1.113883.2.9.6.1.54.6 ModalitàTrasporto_VPS (2022-12-12T00:00:00)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@code">(Trasporto (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Trasporto (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.54.6')">(Trasporto (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.54.6'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@codeSystemName) = ('ModalitàTrasporto_VPS') or not(@codeSystemName)">(Trasporto (VPS)): The value for codeSystemName SHALL be 'ModalitàTrasporto_VPS'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Trasporto (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Trasporto (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Trasporto (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:effectiveTime
Item: (Trasporto (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@typeCode">(Trasporto (VPS)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('REFB')))])">(Trasporto (VPS)): The value for typeCode SHALL be 'code REFB'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(Trasporto (VPS)): element hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(Trasporto (VPS)): element hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Trasporto (VPS)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Trasporto (VPS)): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.40
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Trasporto (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.20']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.40']]/hl7:participant[hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:participantRole[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.6.1.54.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Trasporto (VPS)): The element value SHALL be one of '2.16.840.1.113883.2.9.6.1.54.1 ResponsabileInvio_VPS (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="@code">(Trasporto (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Trasporto (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.54.1')">(Trasporto (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.54.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="string(@codeSystemName) = ('ResponsabileInvio_VPS') or not(@codeSystemName)">(Trasporto (VPS)): The value for codeSystemName SHALL be 'ResponsabileInvio_VPS'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Trasporto (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.40-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Trasporto (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]
Item: (Motivo della Visita (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Motivo della Visita (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Motivo della Visita (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']) &gt;= 1">(Motivo della Visita (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']) &lt;= 1">(Motivo della Visita (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Motivo della Visita (VPS)): element hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Motivo della Visita (VPS)): element hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Motivo della Visita (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Motivo della Visita (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Motivo della Visita (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]) &gt;= 1">(Motivo della Visita (VPS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]) &lt;= 1">(Motivo della Visita (VPS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]) &lt;= 1">(Motivo della Visita (VPS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.42')">(Motivo della Visita (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.42'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:code[(@code = '46239-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="@nullFlavor or (@code='46239-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Motivo della visita' and @codeSystemName='LOINC')">(Motivo della Visita (VPS)): The element value SHALL be one of 'code '46239-0' codeSystem '2.16.840.1.113883.6.1' displayName='Motivo della visita' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:title
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="text()='Motivo della Visita'">(Motivo della Visita (VPS)): the element content of hl7:title SHALL be ''Motivo della Visita''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:text
Item: (Motivo della Visita (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP')">(Motivo della Visita (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Motivo della Visita (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]
Item: (Problema Principale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]
Item: (Problema Principale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Problema Principale (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Problema Principale (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']) &gt;= 1">(Problema Principale (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']) &lt;= 1">(Problema Principale (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Problema Principale (VPS)): element hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Problema Principale (VPS)): element hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Problema Principale (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Problema Principale (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Problema Principale (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Problema Principale (VPS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Problema Principale (VPS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']
Item: (Problema Principale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.37')">(Problema Principale (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.37'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Problema Principale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:code[(@code = '56817-0' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="@nullFlavor or (@code='56817-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Problema  all''accesso' and @codeSystemName='LOINC')">(Problema Principale (VPS)): The element value SHALL be one of 'code '56817-0' codeSystem '2.16.840.1.113883.6.1' displayName='Problema  all''accesso' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Problema Principale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Problema Principale (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:effectiveTime
Item: (Problema Principale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.37
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Problema Principale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.37']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.2' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.6-2018-03-19T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Problema Principale (VPS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.6 ProblemaPrincipale_VPS (2018-03-19T00:00:00)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="@code">(Problema Principale (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Problema Principale (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.54.2')">(Problema Principale (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.54.2'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="string(@codeSystemName) = ('ProblemaPrincipale_VPS') or not(@codeSystemName)">(Problema Principale (VPS)): The value for codeSystemName SHALL be 'ProblemaPrincipale_VPS'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Problema Principale (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.37-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Problema Principale (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]
Item: (Motivo della Visita (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP')">(Motivo della Visita (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.42-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Motivo della Visita (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]
Item: (Causa di Accesso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]
Item: (Causa di Accesso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS')">(Causa di Accesso (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Causa di Accesso (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']) &gt;= 1">(Causa di Accesso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']) &lt;= 1">(Causa di Accesso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Causa di Accesso (VPS)): element hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Causa di Accesso (VPS)): element hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Causa di Accesso (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Causa di Accesso (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Causa di Accesso (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:value) &gt;= 1">(Causa di Accesso (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="count(hl7:value) &lt;= 1">(Causa di Accesso (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']
Item: (Causa di Accesso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.87')">(Causa di Accesso (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.87'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Causa di Accesso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:code[(@code = '29298-7' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="@nullFlavor or (@code='29298-7' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Ragione della  visita' and @codeSystemName='LOINC')">(Causa di Accesso (VPS)): The element value SHALL be one of 'code '29298-7' codeSystem '2.16.840.1.113883.6.1' displayName='Ragione della  visita' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Causa di Accesso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.87-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Causa di Accesso (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:effectiveTime
Item: (Causa di Accesso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.87
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.42']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.87']]/hl7:value
Item: (Causa di Accesso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Triage (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Triage (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']) &gt;= 1">(Triage (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']) &lt;= 1">(Triage (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '54094-8' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Triage (VPS)): element hl7:code[(@code = '54094-8' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Triage (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Triage (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Triage (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]) &gt;= 1">(Triage (VPS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]) &lt;= 1">(Triage (VPS)): element hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.21')">(Triage (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.21'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:code[(@code = '54094-8' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:code[(@code = '54094-8' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="@nullFlavor or (@code='54094-8' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Triage note' and @codeSystemName='LOINC')">(Triage (VPS)): The element value SHALL be one of 'code '54094-8' codeSystem '2.16.840.1.113883.6.1' displayName='Triage note' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:title
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="text()='Triage'">(Triage (VPS)): the element content of hl7:title SHALL be ''Triage''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:text
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.21
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP')">(Triage (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.21-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Triage (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS')">(Triage (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Triage (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']) &gt;= 1">(Triage (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']) &lt;= 1">(Triage (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Triage (VPS)): element hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Triage (VPS)): element hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Triage (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Triage (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Triage (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Triage (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Triage (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(Triage (VPS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(Triage (VPS)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.39')">(Triage (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.39'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:code[(@code = '11283-9' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="@nullFlavor or (@code='11283-9' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Valutazione Acutezza' and @codeSystemName='LOINC')">(Triage (VPS)): The element value SHALL be one of 'code '11283-9' codeSystem '2.16.840.1.113883.6.1' displayName='Valutazione Acutezza' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:text
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:statusCode[@code = 'completed' or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Triage (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:effectiveTime
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.54.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.8-2018-03-19T000000.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Triage (VPS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.8 CodiceTriage_VPS (2018-03-19T00:00:00)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="@code">(Triage (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Triage (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.54.4')">(Triage (VPS)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.54.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Triage (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Triage (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]">
      <extends rule="d4389257e0-false-d4389275e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:assignedEntity[hl7:assignedPerson]) &gt;= 1">(Triage (VPS)): element hl7:assignedEntity[hl7:assignedPerson] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:assignedEntity[hl7:assignedPerson]) &lt;= 1">(Triage (VPS)): element hl7:assignedEntity[hl7:assignedPerson] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Triage (VPS)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Triage (VPS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:assignedPerson) &gt;= 1">(Triage (VPS)): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Triage (VPS)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]/hl7:id
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]/hl7:assignedPerson
Item: (Triage (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Triage (VPS)): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Triage (VPS)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Triage (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.39-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Triage (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity[hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (Triage (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1" id="d4389257e0-false-d4389275e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(CDA Performer (Body)): The value for typeCode SHALL be 'PRF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Performer (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Performer (Body)): element hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA Performer (Body)): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA Performer (Body)): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:time
Item: (CDA Performer (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:modeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16543-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Performer (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16543 ParticipationMode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.323
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA Performer (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Performer (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Performer (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Performer (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA Performer (Body)): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.323-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Performer (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.153
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.21']]/hl7:entry[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.39']]/hl7:performer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization
Item: (CDA AssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]
Item: (Inquadramento clinico iniziale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Inquadramento clinico iniziale (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Inquadramento clinico iniziale (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']) &gt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.56')">(Inquadramento clinico iniziale (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.56'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:code[(@code = '78337-3' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="@nullFlavor or (@code='78337-3' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Inquadramento clinico iniziale' and @codeSystemName='LOINC')">(Inquadramento clinico iniziale (VPS)): The element value SHALL be one of 'code '78337-3' codeSystem '2.16.840.1.113883.6.1' displayName='Inquadramento clinico iniziale' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:title
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="text()='Inquadramento clinico iniziale'">(Inquadramento clinico iniziale (VPS)): the element content of hl7:title SHALL be ''Inquadramento clinico iniziale''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:text
Item: (Inquadramento clinico iniziale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4390341e0-false-d4390362e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Inquadramento clinico iniziale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4390341e17-false-d4390461e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (Inquadramento clinico iniziale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(Inquadramento clinico iniziale (VPS)): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (Inquadramento clinico iniziale (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4390341e0-false-d4390362e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4390341e17-false-d4390461e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Inquadramento clinico iniziale (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Inquadramento clinico iniziale (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Anamnesi (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Anamnesi (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']) &gt;= 1">(Anamnesi (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']) &lt;= 1">(Anamnesi (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:id) &lt;= 1">(Anamnesi (VPS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Anamnesi (VPS)): element hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Anamnesi (VPS)): element hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Anamnesi (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Anamnesi (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Anamnesi (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Anamnesi (VPS)): element hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]]) &lt;= 1">(Anamnesi (VPS)): element hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.55')">(Anamnesi (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.55'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:id
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="@nullFlavor or (@code='11329-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Anamnesi Generale' and @codeSystemName='LOINC')">(Anamnesi (VPS)): The element value SHALL be one of 'code '11329-0' codeSystem '2.16.840.1.113883.6.1' displayName='Anamnesi Generale' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:title
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="text()='Anamnesi'">(Anamnesi (VPS)): the element content of hl7:title SHALL be ''Anamnesi''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:text
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4391399e0-false-d4391420e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4391399e17-false-d4391519e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Anamnesi (VPS)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Anamnesi (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Anamnesi (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4391399e0-false-d4391420e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4391399e17-false-d4391519e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="@typeCode">(Anamnesi (VPS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Anamnesi (VPS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="@typeCode">(Anamnesi (VPS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Anamnesi (VPS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Inquadramento clinico iniziale (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Inquadramento clinico iniziale (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]
Item: (Esame Obiettivo (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]
Item: (Esame Obiettivo (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Esame Obiettivo (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Esame Obiettivo (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']) &gt;= 1">(Esame Obiettivo (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']) &lt;= 1">(Esame Obiettivo (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Esame Obiettivo (VPS)): element hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Esame Obiettivo (VPS)): element hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Esame Obiettivo (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Esame Obiettivo (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Esame Obiettivo (VPS)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']
Item: (Esame Obiettivo (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.58')">(Esame Obiettivo (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.58'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Esame Obiettivo (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="@nullFlavor or (@code='29545-1' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Esame Obiettivo' and @codeSystemName='LOINC')">(Esame Obiettivo (VPS)): The element value SHALL be one of 'code '29545-1' codeSystem '2.16.840.1.113883.6.1' displayName='Esame Obiettivo' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:title
Item: (Esame Obiettivo (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.58-2018-03-19T000000.html"
              test="text()='Esame obiettivo'">(Esame Obiettivo (VPS)): the element content of hl7:title SHALL be ''Esame obiettivo''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:text
Item: (Esame Obiettivo (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]
Item: (Esame Obiettivo (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4392446e0-false-d4392467e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Esame Obiettivo (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Esame Obiettivo (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4392446e17-false-d4392566e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:assignedPerson) &lt;= 1">(assignedAuthor_BodyVps): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4392446e0-false-d4392467e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4392446e17-false-d4392566e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.58']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Inquadramento clinico iniziale (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Inquadramento clinico iniziale (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Terapia_FarmacologicaAll'ingresso (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapia_FarmacologicaAll'ingresso (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']) &gt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']) &lt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.57')">(Terapia_FarmacologicaAll'ingresso (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.57'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:code[(@code = '42346-7' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="@nullFlavor or (@code='42346-7' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Medications on  admission (narrative)' and @codeSystemName='LOINC')">(Terapia_FarmacologicaAll'ingresso (VPS)): The element value SHALL be one of 'code '42346-7' codeSystem '2.16.840.1.113883.6.1' displayName='Medications on  admission (narrative)' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:title
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="text()='Terapia farmacologica all’ingresso'">(Terapia_FarmacologicaAll'ingresso (VPS)): the element content of hl7:title SHALL be ''Terapia farmacologica all’ingresso''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:text
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4393430e0-false-d4393451e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &gt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:assignedAuthor[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.57-2018-03-19T000000.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &lt;= 1">(Terapia_FarmacologicaAll'ingresso (VPS)): element hl7:assignedAuthor[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.57
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (Terapia_FarmacologicaAll'ingresso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:assignedPerson) &lt;= 1">(assignedAuthor_BodyVps): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4393430e0-false-d4393451e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.57']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]">
      <extends rule="d4394104e0-false-d4394108e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Inquadramento clinico iniziale (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Inquadramento clinico iniziale (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1" id="d4394104e0-false-d4394108e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]) &gt;= 1">(Allergie (VPS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]) &lt;= 1">(Allergie (VPS)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Allergie (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Allergie (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']) &gt;= 1">(Allergie (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']) &lt;= 1">(Allergie (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:id) &lt;= 1">(Allergie (VPS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Allergie (VPS)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Allergie (VPS)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Allergie (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Allergie (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Allergie (VPS)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.33')">(Allergie (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.33'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:id
Item: (Allergie (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="@nullFlavor or (@code='48765-2' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Allergie e/o Reazioni Avverse' and @codeSystemName='LOINC')">(Allergie (VPS)): The element value SHALL be one of 'code '48765-2' codeSystem '2.16.840.1.113883.6.1' displayName='Allergie e/o Reazioni Avverse' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:title
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="text()='Allergie e/o Reazioni Avverse'">(Allergie (VPS)): the element content of hl7:title SHALL be ''Allergie e/o Reazioni Avverse''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:text
Item: (Allergie (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4394511e0-false-d4394532e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &gt;= 1">(Allergie (VPS)): element hl7:assignedAuthor[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="count(hl7:assignedAuthor[not(@nullFlavor)]) &lt;= 1">(Allergie (VPS)): element hl7:assignedAuthor[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Allergie (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (Allergie (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:assignedPerson) &lt;= 1">(assignedAuthor_BodyVps): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:id[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[not(@nullFlavor)]/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4394511e0-false-d4394532e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.33
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]
Item: (Allergie (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.33']]/hl7:entry[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.319']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="@typeCode">(Allergie (VPS)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.33-2018-03-19T000000.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Allergie (VPS)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.56
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]
Item: (Inquadramento clinico iniziale (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Inquadramento clinico iniziale (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.56-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Inquadramento clinico iniziale (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]
Item: (Problemi Aperti (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]
Item: (Problemi Aperti (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Problemi Aperti (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Problemi Aperti (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']) &gt;= 1">(Problemi Aperti (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']) &lt;= 1">(Problemi Aperti (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Problemi Aperti (VPS)): element hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Problemi Aperti (VPS)): element hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Problemi Aperti (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Problemi Aperti (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Problemi Aperti (VPS)): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']
Item: (Problemi Aperti (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.59')">(Problemi Aperti (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.59'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Problemi Aperti (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:code[(@code = '11450-4' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="@nullFlavor or (@code='11450-4' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Problem list Reported' and @codeSystemName='LOINC')">(Problemi Aperti (VPS)): The element value SHALL be one of 'code '11450-4' codeSystem '2.16.840.1.113883.6.1' displayName='Problem list Reported' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:title
Item: (Problemi Aperti (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.59-2018-03-19T000000.html"
              test="text()='Problemi aperti'">(Problemi Aperti (VPS)): the element content of hl7:title SHALL be ''Problemi aperti''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:text
Item: (Problemi Aperti (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]
Item: (Problemi Aperti (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4395539e0-false-d4395560e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Problemi Aperti (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Problemi Aperti (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4395539e17-false-d4395659e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:assignedPerson) &lt;= 1">(assignedAuthor_BodyVps): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (assignedAuthor_BodyVps)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &gt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.318-2023-05-04T100051.html"
              test="count(hl7:name[not(@nullFlavor)]) &lt;= 1">(assignedAuthor_BodyVps): element hl7:name[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name[not(@nullFlavor)]
Item: (assignedAuthor_BodyVps)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4395539e0-false-d4395560e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4395539e17-false-d4395659e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Organization): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(CDA Organization): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA Organization): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(CDA Organization): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:code
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15999-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(CDA Organization): The element value SHALL be one of '2.16.840.1.113883.1.11.15999 RoleStatus (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (CDA Organization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(CDA Organization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.151-2005-09-07T000000.html"
              test="count(hl7:standardIndustryClassCode) &lt;= 1">(CDA Organization): element hl7:standardIndustryClassCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:id
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.151
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.56']]/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.59']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:standardIndustryClassCode
Item: (CDA Organization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.15
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]
Item: (Prescrizione farmaceutica)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione farmaceutica): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.15-2022-06-21T090133.html"
              test="string(@contextConductionInd) = ('true')">(Prescrizione farmaceutica): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Anamnesi (VPS)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Anamnesi (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']) &gt;= 1">(Anamnesi (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']) &lt;= 1">(Anamnesi (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:id) &lt;= 1">(Anamnesi (VPS)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Anamnesi (VPS)): element hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Anamnesi (VPS)): element hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:title) &lt;= 1">(Anamnesi (VPS)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:text) &gt;= 1">(Anamnesi (VPS)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Anamnesi (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Anamnesi (VPS)): element hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]]) &lt;= 1">(Anamnesi (VPS)): element hl7:entry[hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.138']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.55')">(Anamnesi (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.55'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:id
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="@nullFlavor or (@code='11329-0' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Anamnesi Generale' and @codeSystemName='LOINC')">(Anamnesi (VPS)): The element value SHALL be one of 'code '11329-0' codeSystem '2.16.840.1.113883.6.1' displayName='Anamnesi Generale' codeSystemName='LOINC''.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:title
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:title">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="text()='Anamnesi'">(Anamnesi (VPS)): the element content of hl7:title SHALL be ''Anamnesi''. Found: "<value-of select="."/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:text
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]">
      <extends rule="d4396597e0-false-d4396618e0"/>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <extends rule="d4396597e17-false-d4396717e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Anamnesi (VPS)): element hl7:assignedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (Anamnesi (VPS))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Anamnesi (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.55-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Anamnesi (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.55
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (Anamnesi (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4396597e0-false-d4396618e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA Author (Body)): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Author (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Author (Body)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &gt;= 1">(CDA Author (Body)): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Author (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA Author (Body)): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA Author (Body)): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Author (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA Author (Body))
-->
   <rule fpi="RULC-1" id="d4396597e17-false-d4396717e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA Author (Body)): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:id) &gt;= 1">(CDA Author (Body)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Author (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:assignedPerson | hl7:assignedAuthoringDevice) &lt;= 1">(CDA Author (Body)): choice (hl7:assignedPerson  or  hl7:assignedAuthoringDevice) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.318-2005-09-07T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(CDA Author (Body)): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA Person)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA Person): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.152-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Person): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.152
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA Person)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.318
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Author (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:structuredBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.55']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appe