<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.134
Name: Dimens Tumore Rad
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114">
   <title>Dimens Tumore Rad</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]
Item: (Dimens Tumore Rad)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]
Item: (Dimens Tumore Rad)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]"
         id="d44e29103-false-d4345637e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="string(@classCode) = ('OBS')">(Dimens Tumore Rad): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="string(@moodCode) = ('EVN')">(Dimens Tumore Rad): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']) &gt;= 1">(Dimens Tumore Rad): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']) &lt;= 1">(Dimens Tumore Rad): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Dimens Tumore Rad): element hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Dimens Tumore Rad): element hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:text) &lt;= 1">(Dimens Tumore Rad): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Dimens Tumore Rad): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Dimens Tumore Rad): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:value) &gt;= 1">(Dimens Tumore Rad): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="count(hl7:value) &lt;= 1">(Dimens Tumore Rad): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']
Item: (Dimens Tumore Rad)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']"
         id="d44e29109-false-d4345701e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.134')">(Dimens Tumore Rad): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.134'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Dimens Tumore Rad)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:code[(@code = '21889-1' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]"
         id="d44e29114-false-d4345713e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="@nullFlavor or (@code='21889-1' and @codeSystem='2.16.840.1.113883.6.1')">(Dimens Tumore Rad): The element value SHALL be one of 'code '21889-1' codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dimens Tumore Rad): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dimens Tumore Rad): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:text
Item: (Dimens Tumore Rad)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Dimens Tumore Rad)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e29140-false-d4345743e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.134-2022-09-21T135114.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Dimens Tumore Rad): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:effectiveTime
Item: (Dimens Tumore Rad)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.134
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.134']]/hl7:value
Item: (Dimens Tumore Rad)
-->
</pattern>
