<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.131
Name: Quesito Diagnostico (RAP)
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356">
   <title>Quesito Diagnostico (RAP)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]"
         id="d44e28779-false-d4345243e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]"
         id="d44e28799-false-d4345258e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Quesito Diagnostico (RAP)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@moodCode) = ('EVN')">(Quesito Diagnostico (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']) &gt;= 1">(Quesito Diagnostico (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Quesito Diagnostico (RAP)): element hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:text) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:value) &gt;= 1">(Quesito Diagnostico (RAP)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="count(hl7:value) &lt;= 1">(Quesito Diagnostico (RAP)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']"
         id="d44e28811-false-d4345322e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.131')">(Quesito Diagnostico (RAP)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.131'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e28816-false-d4345334e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@code) = ('29308-4')">(Quesito Diagnostico (RAP)): The value for code SHALL be '29308-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Quesito Diagnostico (RAP)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Quesito Diagnostico (RAP)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Quesito Diagnostico (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Quesito Diagnostico (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:text
Item: (Quesito Diagnostico (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e28842-false-d4345370e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Quesito Diagnostico (RAP)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.10 X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:effectiveTime
Item: (Quesito Diagnostico (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.131
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:value
Item: (Quesito Diagnostico (RAP))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.131']]/hl7:value"
         id="d44e28849-false-d4345395e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Quesito Diagnostico (RAP)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Quesito Diagnostico (RAP)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Quesito Diagnostico (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Quesito Diagnostico (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
