<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.10
Name: Terapie Farmacologiche dimissione (VPS)
Description: Pharmacological Therapies
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000">
   <title>Terapie Farmacologiche dimissione (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]"
         id="d44e24757-false-d4340479e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@classCode) = ('SBADM')">(Terapie Farmacologiche dimissione (VPS)): The value for classCode SHALL be 'SBADM'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@moodCode) = ('INT')">(Terapie Farmacologiche dimissione (VPS)): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @nullFlavor]) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:statusCode[@code = 'active' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'active' or @nullFlavor]) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:statusCode[@code = 'active' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:approachSiteCode) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:approachSiteCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:doseQuantity) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:doseQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:rateQuantity) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:rateQuantity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:administrationUnitCode) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:administrationUnitCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']"
         id="d44e24767-false-d4340607e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.52')">(Terapie Farmacologiche dimissione (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.52'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:statusCode[@code = 'active' or @nullFlavor]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:statusCode[@code = 'active' or @nullFlavor]"
         id="d44e24772-false-d4340619e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@nullFlavor or (@code='active')">(Terapie Farmacologiche dimissione (VPS)): The element value SHALL be one of 'code 'active''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:effectiveTime
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:routeCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e24802-false-d4340659e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.14581-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Terapie Farmacologiche dimissione (VPS)): The element value SHALL be one of '2.16.840.1.113883.1.11.14581 RouteOfAdministration (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:approachSiteCode
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:doseQuantity
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:rateQuantity
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:administrationUnitCode
Item: (Terapie Farmacologiche dimissione (VPS))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]) &gt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]) &lt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="string(@classCode) = ('MANU') or not(@classCode)">(Prodotto fabbricato dimissione (VPS)): The value for classCode SHALL be 'MANU'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']) &gt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']) &lt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.53')">(Prodotto fabbricato dimissione (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.53'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:id
Item: (Prodotto fabbricato dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="string(@classCode) = ('MMAT') or not(@classCode)">(Prodotto fabbricato dimissione (VPS)): The value for classCode SHALL be 'MMAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="string(@determinerCode) = ('KIND') or not(@determinerCode)">(Prodotto fabbricato dimissione (VPS)): The value for determinerCode SHALL be 'KIND'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Prodotto fabbricato dimissione (VPS)): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial/hl7:code
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@code">(Prodotto fabbricato dimissione (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Prodotto fabbricato dimissione (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@codeSystem">(Prodotto fabbricato dimissione (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Prodotto fabbricato dimissione (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prodotto fabbricato dimissione (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prodotto fabbricato dimissione (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.9
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial/hl7:code/hl7:translation
Item: (Prodotto fabbricato dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:consumable[hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]]/hl7:manufacturedProduct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.53']]/hl7:manufacturedMaterial/hl7:code/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@code">(Prodotto fabbricato dimissione (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Prodotto fabbricato dimissione (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@codeSystem">(Prodotto fabbricato dimissione (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Prodotto fabbricato dimissione (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@codeSystemName">(Prodotto fabbricato dimissione (VPS)): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prodotto fabbricato dimissione (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="@displayName">(Prodotto fabbricato dimissione (VPS)): attribute @displayName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.9-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prodotto fabbricato dimissione (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="@typeCode">(Participant Richiedente (VPS)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('REF')))])">(Participant Richiedente (VPS)): The value for typeCode SHALL be 'code REF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:time) &lt;= 1">(Participant Richiedente (VPS)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(Participant Richiedente (VPS)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(Participant Richiedente (VPS)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:time
Item: (Participant Richiedente (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant Richiedente (VPS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:playingEntity) &lt;= 1">(Participant Richiedente (VPS)): element hl7:playingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:id
Item: (Participant Richiedente (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity
Item: (Participant Richiedente (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Participant Richiedente (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.8-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Participant Richiedente (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.8
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:participant[@typeCode = 'REF'][hl7:participantRole]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (Participant Richiedente (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]
Item: (Terapie Farmacologiche dimissione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@typeCode) = ('REFR')">(Terapie Farmacologiche dimissione (VPS)): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.89
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]
Item: (Prescrizioni (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.89
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]
Item: (Prescrizioni (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="string(@classCode) = ('ACT')">(Prescrizioni (VPS)): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="string(@moodCode) = ('RQO')">(Prescrizioni (VPS)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']) &gt;= 1">(Prescrizioni (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']) &lt;= 1">(Prescrizioni (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1">(Prescrizioni (VPS)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1">(Prescrizioni (VPS)): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.89
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']
Item: (Prescrizioni (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.89')">(Prescrizioni (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.89'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.89
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']
Item: (Prescrizioni (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:reference[hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]]/hl7:externalAct[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.89']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')">(Prescrizioni (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="@extension">(Prescrizioni (VPS)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.89-2018-03-19T000000.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Prescrizioni (VPS)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]"
         id="d44e24878-false-d4341070e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation"
         id="d44e24886-false-d4341086e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche dimissione (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche dimissione (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:code"
         id="d44e24892-false-d4341118e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@code">(Terapie Farmacologiche dimissione (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche dimissione (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@codeSystem">(Terapie Farmacologiche dimissione (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche dimissione (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche dimissione (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche dimissione (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[hl7:observation]/hl7:observation/hl7:value"
         id="d44e24908-false-d4341142e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche dimissione (VPS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]"
         id="d44e24921-false-d4341154e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche dimissione (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:observation) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:observation) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:observation appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation"
         id="d44e24931-false-d4341174e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Terapie Farmacologiche dimissione (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapie Farmacologiche dimissione (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:code) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:value) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:value) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:code"
         id="d44e24937-false-d4341206e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@code">(Terapie Farmacologiche dimissione (VPS)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Terapie Farmacologiche dimissione (VPS)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@codeSystem">(Terapie Farmacologiche dimissione (VPS)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Terapie Farmacologiche dimissione (VPS)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapie Farmacologiche dimissione (VPS)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapie Farmacologiche dimissione (VPS)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:value"
         id="d44e24953-false-d4341230e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@nullFlavor or ($xsiLocalName='REAL' and $xsiLocalNS='urn:hl7-org:v3')">(Terapie Farmacologiche dimissione (VPS)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:REAL". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]"
         id="d44e24967-false-d4341242e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@typeCode) = ('COMP')">(Terapie Farmacologiche dimissione (VPS)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:supply) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:supply is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:supply) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:supply appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply"
         id="d44e24977-false-d4341262e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@classCode) = ('SPLY') or not(@classCode)">(Terapie Farmacologiche dimissione (VPS)): The value for classCode SHALL be 'SPLY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(Terapie Farmacologiche dimissione (VPS)): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:quantity) &gt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:quantity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="count(hl7:quantity) &lt;= 1">(Terapie Farmacologiche dimissione (VPS)): element hl7:quantity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.10
Context: *[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity
Item: (Terapie Farmacologiche dimissione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]]/hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.52']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:supply]/hl7:supply/hl7:quantity"
         id="d44e24983-false-d4341286e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.html"
              test="@value">(Terapie Farmacologiche dimissione (VPS)): attribute @value SHALL be present.</assert>
   </rule>
</pattern>
