<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Name: Terapia Farmacologica Consigliata (RSA)
Description: Discharge medications Narrative (LOINC: 75311-1 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000">
   <title>Terapia Farmacologica Consigliata (RSA)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]"
         id="d44e22335-false-d4238985e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Terapia Farmacologica Consigliata (RSA)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapia Farmacologica Consigliata (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.14']) &lt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.14'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:id) &lt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Terapia Farmacologica Consigliata (RSA)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.14']
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.14']"
         id="d44e22341-false-d4239049e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.9.3.14')">(Terapia Farmacologica Consigliata (RSA)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.9.3.14'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:id
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e22348-false-d4239069e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@code) = ('93341-6')">(Terapia Farmacologica Consigliata (RSA)): The value for code SHALL be '93341-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Terapia Farmacologica Consigliata (RSA)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Terapia Farmacologica Consigliata (RSA)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapia Farmacologica Consigliata (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="not(@diplayName) or string-length(@diplayName)&gt;0">(Terapia Farmacologica Consigliata (RSA)): Attribute @diplayName SHALL be of data type 'st'  - '<value-of select="@diplayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Terapia Farmacologica Consigliata (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Terapia Farmacologica Consigliata (RSA))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.14
Context: *[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]
Item: (Terapia Farmacologica Consigliata (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:substanceAdministration[@classCode = 'SBADM'][@moodCode = 'INT']]">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Terapia Farmacologica Consigliata (RSA)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Terapia Farmacologica Consigliata (RSA)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
