<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Name: Diagnosi (RSA)
Description: Diagnosis Narrative (LOINC: 29548-5 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000">
   <title>Diagnosi (RSA)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Diagnosi (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Diagnosi (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]"
         id="d44e21993-false-d4233395e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Diagnosi (RSA)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Diagnosi (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.10']) &lt;= 1">(Diagnosi (RSA)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.10'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:id) &lt;= 1">(Diagnosi (RSA)): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Diagnosi (RSA)): element hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Diagnosi (RSA)): element hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Diagnosi (RSA)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Diagnosi (RSA)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Diagnosi (RSA)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.10']
Item: (Diagnosi (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.3.10']"
         id="d44e21999-false-d4233792e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.9.3.10')">(Diagnosi (RSA)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.9.3.10'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:id
Item: (Diagnosi (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Diagnosi (RSA))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e22006-false-d4233812e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@code) = ('29548-5')">(Diagnosi (RSA)): The value for code SHALL be '29548-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Diagnosi (RSA)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Diagnosi (RSA)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Diagnosi (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Diagnosi (RSA)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Diagnosi (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Diagnosi (RSA))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Diagnosi (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d4234325e0-false-d4234329e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19446-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Diagnosi (RSA)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.19446' x_ActRelationshipEntry (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Diagnosi (RSA)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Diagnosi (RSA)): element hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Diagnosi (RSA)): element hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Diagnosi (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN')">(Diagnosi (RSA)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Diagnosi (RSA)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Diagnosi (RSA)): element hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Diagnosi (RSA)): element hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &gt;= 1">(Diagnosi (RSA)): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.6.103']) &lt;= 1">(Diagnosi (RSA)): element hl7:value[@codeSystem = '2.16.840.1.113883.6.103'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Diagnosi (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@code) = ('29308-4')">(Diagnosi (RSA)): The value for code SHALL be '29308-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Diagnosi (RSA)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Diagnosi (RSA)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Diagnosi (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Diagnosi (RSA)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']
Item: (Diagnosi (RSA))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="@code">(Diagnosi (RSA)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Diagnosi (RSA)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.103')">(Diagnosi (RSA)): The value for codeSystem SHALL be '2.16.840.1.113883.6.103'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('ICD9-CM') or not(@codeSystemName)">(Diagnosi (RSA)): The value for codeSystemName SHALL be 'ICD9-CM'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Diagnosi (RSA)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Diagnosi (RSA)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.9.3.10
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[@codeSystem = '2.16.840.1.113883.6.103']/hl7:translation
Item: (Diagnosi (RSA))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.300
Context: *[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '29308-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (CDA Clinical Statement)
-->
   <rule fpi="RULC-1" id="d4234325e0-false-d4234329e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &gt;= 1">(CDA Clinical Statement): choice (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  or  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  or  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  or  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  or  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  or  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  or  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  or  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  or  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.300-2005-09-07T000000.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']] | hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']] | hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']] | hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']] | hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']] | hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']] | hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']] | hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']] | hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) &lt;= 1">(CDA Clinical Statement): choice (hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.12.301']]  or  hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.10.12.302']]  or  hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.10.12.303']]  or  hl7:observationMedia[hl7:templateId[@root = '2.16.840.1.113883.10.12.304']]  or  hl7:organizer[hl7:templateId[@root = '2.16.840.1.113883.10.12.305']]  or  hl7:procedure[hl7:templateId[@root = '2.16.840.1.113883.10.12.306']]  or  hl7:regionOfInterest[hl7:templateId[@root = '2.16.840.1.113883.10.12.307']]  or  hl7:substanceAdministration[hl7:templateId[@root = '2.16.840.1.113883.10.12.308']]  or  hl7:supply[hl7:templateId[@root = '2.16.840.1.113883.10.12.309']]) contains too many elements [max 1x]</assert>
   </rule>
</pattern>
