<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.8.1
Name: Referto di Anatomia Patologica (RAP)
Description: Template CDA ClinicalDocument (prototype, contains ClinicalDocument.component as StructuredBody)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337">
   <title>Referto di Anatomia Patologica (RAP)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]"
         id="d44e21105-false-d3272298e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Referto di Anatomia Patologica (RAP)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Anatomia Patologica (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:realmCode) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:title) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(sdtc:statusCode) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element sdtc:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:languageCode) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:languageCode) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:setId) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:versionNumber) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:inFulfillmentOf[hl7:order]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:inFulfillmentOf[hl7:order] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:documentationOf[hl7:serviceEvent] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Referto di Anatomia Patologica (RAP)): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:realmCode
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d44e21136-false-d3273647e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Referto di Anatomia Patologica (RAP)): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Referto di Anatomia Patologica (RAP)): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']"
         id="d44e21154-false-d3273666e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.8.1')">(Referto di Anatomia Patologica (RAP)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.8.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@extension">(Referto di Anatomia Patologica (RAP)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:id[not(@nullFlavor)]
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:id[not(@nullFlavor)]"
         id="d44e21176-false-d3273683e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@root">(Referto di Anatomia Patologica (RAP)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Anatomia Patologica (RAP)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@extension">(Referto di Anatomia Patologica (RAP)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e21199-false-d3273705e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@code) = ('11526-1')">(Referto di Anatomia Patologica (RAP)): The value for code SHALL be '11526-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Referto di Anatomia Patologica (RAP)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Referto di Anatomia Patologica (RAP)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d44e21228-false-d3273733e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@code">(Referto di Anatomia Patologica (RAP)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Referto di Anatomia Patologica (RAP)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@codeSystem">(Referto di Anatomia Patologica (RAP)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Anatomia Patologica (RAP)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Anatomia Patologica (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:title
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/sdtc:statusCode
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:effectiveTime
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
         id="d44e21310-false-d3273782e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25')">(Referto di Anatomia Patologica (RAP)): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' or code 'V' codeSystem '2.16.840.1.113883.5.25''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(Referto di Anatomia Patologica (RAP)): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:languageCode
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:setId
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:versionNumber
Item: (Referto di Anatomia Patologica (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]"
         id="d3273819e22-false-d3273927e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTarget RAP): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTarget RAP): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTarget RAP): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTarget RAP): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d3273819e37-false-d3274153e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTarget RAP): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1">(CDA recordTarget RAP): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1">(CDA recordTarget RAP): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget RAP): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d3273819e50-false-d3274297e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@root">(CDA recordTarget RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@extension">(CDA recordTarget RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTarget RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTarget RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d3274351e0-false-d3274357e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@use">(CDA recordTarget RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3274351e0-false-d3274357e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d3273819e206-false-d3274469e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@use">(CDA recordTarget RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]"
         id="d3273819e220-false-d3274557e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget RAP): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget RAP): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget RAP): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(CDA recordTarget RAP): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA recordTarget RAP): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget RAP): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget RAP): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTarget RAP): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name
Item: (CDA recordTarget RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name/hl7:suffix
Item: (CDA name )
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d3273819e250-false-d3274764e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthTime
Item: (CDA recordTarget RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian"
         id="d3273819e269-false-d3274837e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@classCode) = ('GUARD') or not(@classCode)">(CDA recordTarget RAP): The value for classCode SHALL be 'GUARD'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTarget RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTarget RAP): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget RAP): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:id
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:id"
         id="d3273819e273-false-d3274926e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@root">(CDA recordTarget RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@extension">(CDA recordTarget RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:code
Item: (CDA recordTarget RAP)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr
Item: (CDA recordTarget RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr">
      <extends rule="d3274985e0-false-d3274991e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@use">(CDA recordTarget RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3274985e0-false-d3274991e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:telecom
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:telecom"
         id="d3273819e295-false-d3275103e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@use">(CDA recordTarget RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTarget RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d3275150e0-false-d3275162e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTarget RAP): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTarget RAP): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d3275150e0-false-d3275162e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTarget RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3275480e0-false-d3275486e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3275480e0-false-d3275486e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3275644e0-false-d3275680e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3275644e0-false-d3275680e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3275850e0-false-d3275854e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3275850e0-false-d3275854e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3276020e0-false-d3276026e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3276020e0-false-d3276026e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3276184e0-false-d3276220e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3276184e0-false-d3276220e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]"
         id="d3273819e317-false-d3276404e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTarget RAP): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTarget RAP): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTarget RAP): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTarget RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d3273819e321-false-d3276440e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTarget RAP): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:addr) &gt;= 1">(CDA recordTarget RAP): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="count(hl7:addr) &lt;= 1">(CDA recordTarget RAP): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA recordTarget RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr">
      <extends rule="d3276504e0-false-d3276510e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="@use">(CDA recordTarget RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA AddressBirthPlace)
-->
   <rule fpi="RULC-1" id="d3276504e0-false-d3276510e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &gt;= 1">(CDA AddressBirthPlace): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:country
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:state
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:county
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:city
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:censusTract
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:postalCode
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.112
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTarget RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3276813e0-false-d3276819e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3276813e0-false-d3276819e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3276977e0-false-d3277013e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3276977e0-false-d3277013e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3277183e0-false-d3277187e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3277183e0-false-d3277187e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3277353e0-false-d3277359e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3277353e0-false-d3277359e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3277517e0-false-d3277553e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3277517e0-false-d3277553e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]"
         id="d3276639e400-false-d3277793e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author RAP): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author RAP): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA author RAP): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:time) &gt;= 1">(CDA author RAP): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:time) &lt;= 1">(CDA author RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA author RAP): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA author RAP): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (CDA author RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA author RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d3276639e417-false-d3277973e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA author RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:id) &gt;= 1">(CDA author RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:code) &lt;= 1">(CDA author RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author RAP): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1">(CDA author RAP): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author RAP): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA author RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d3276639e436-false-d3278085e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="@root">(CDA author RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="@extension">(CDA author RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA author RAP)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA author RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr">
      <extends rule="d3278147e0-false-d3278153e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="@use">(CDA author RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3278147e0-false-d3278153e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA author RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
         id="d3276639e468-false-d3278265e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="@use">(CDA author RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA author RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d3278313e0-false-d3278325e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author RAP): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d3278313e0-false-d3278325e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA author RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]">
      <extends rule="d3278465e0-false-d3278469e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA author RAP): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1" id="d3278465e0-false-d3278469e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:templateId) &gt;= 1">(CDA assignedAuthoringDevice ): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:code) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:softwareName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@root">(CDA assignedAuthoringDevice ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@extension">(CDA assignedAuthoringDevice ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA assignedAuthoringDevice ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@code">(CDA assignedAuthoringDevice ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA assignedAuthoringDevice ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@codeSystem">(CDA assignedAuthoringDevice ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:manufacturerModelName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:softwareName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]">
      <extends rule="d3278605e0-false-d3278609e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="string(@classCode) = ('MNT') or not(@classCode)">(CDA assignedAuthoringDevice ): The value for classCode SHALL be 'MNT'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1" id="d3278605e0-false-d3278609e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:effectiveTime) &lt;= 1">(MaintainedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(MaintainedEntity): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(MaintainedEntity): element hl7:maintainingPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272')">(MaintainedEntity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.272'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:effectiveTime
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.118
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3279017e0-false-d3279023e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3279017e0-false-d3279023e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3279181e0-false-d3279217e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3279181e0-false-d3279217e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3279387e0-false-d3279391e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3279387e0-false-d3279391e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3279557e0-false-d3279563e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3279557e0-false-d3279563e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3279721e0-false-d3279757e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3279721e0-false-d3279757e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.119
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]
Item: (CDA dataEnterer RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]"
         id="d3278843e400-false-d3279983e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="string(@typeCode) = ('ENT') or not(@typeCode)">(CDA dataEnterer RAP): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA dataEnterer RAP): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="count(hl7:time) &gt;= 1">(CDA dataEnterer RAP): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEnterer RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEnterer RAP): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEnterer RAP): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.119
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time
Item: (CDA dataEnterer RAP)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.119
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEnterer RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d3280361e0-false-d3280367e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3280361e0-false-d3280367e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3280850e0-false-d3280856e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3280850e0-false-d3280856e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3281014e0-false-d3281050e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3281014e0-false-d3281050e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3281220e0-false-d3281224e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3281220e0-false-d3281224e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3281390e0-false-d3281396e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3281390e0-false-d3281396e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3281554e0-false-d3281590e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3281554e0-false-d3281590e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.120
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]"
         id="d3280126e568-false-d3281785e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian RAP): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian RAP): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian RAP): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.120
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d3281851e0-false-d3281855e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian )
-->
   <rule fpi="RULC-1" id="d3281851e0-false-d3281855e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@root">(custodianOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@extension">(custodianOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d3282059e0-false-d3282065e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3282059e0-false-d3282065e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]
Item: (CDA informationRecipient RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]"
         id="d3281844e146-false-d3282226e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="string(@typeCode) = ('PRCP') or not(@typeCode)">(CDA informationRecipient RAP): The value for typeCode SHALL be 'PRCP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="count(hl7:intendedRecipient) &gt;= 1">(CDA informationRecipient RAP): element hl7:intendedRecipient is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="count(hl7:intendedRecipient) &lt;= 1">(CDA informationRecipient RAP): element hl7:intendedRecipient appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient
Item: (CDA informationRecipient RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient"
         id="d3281844e156-false-d3282342e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA informationRecipient RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="count(hl7:addr) &lt;= 1">(CDA informationRecipient RAP): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="count(hl7:informationRecipient) &lt;= 1">(CDA informationRecipient RAP): element hl7:informationRecipient appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="count(hl7:receivedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA informationRecipient RAP): element hl7:receivedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id
Item: (CDA informationRecipient RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id"
         id="d3281844e179-false-d3282428e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="@root">(CDA informationRecipient RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA informationRecipient RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="@extension">(CDA informationRecipient RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA informationRecipient RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA informationRecipient RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr">
      <extends rule="d3282479e0-false-d3282485e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="@use">(CDA informationRecipient RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3282479e0-false-d3282485e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom
Item: (CDA informationRecipient RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom"
         id="d3281844e196-false-d3282597e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="@use">(CDA informationRecipient RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA informationRecipient RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.121
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA informationRecipient RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3282968e0-false-d3282974e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3282968e0-false-d3282974e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3283132e0-false-d3283168e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3283132e0-false-d3283168e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3283338e0-false-d3283342e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3283338e0-false-d3283342e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3283508e0-false-d3283514e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3283508e0-false-d3283514e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3283672e0-false-d3283708e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3283672e0-false-d3283708e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.122
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticator RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d3282794e400-false-d3283935e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator RAP): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator RAP): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator RAP): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticator RAP): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticator RAP): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator RAP): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator RAP): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.122
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticator RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.122
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticator RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d3282794e431-false-d3284034e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html"
              test="string(@code) = ('S')">(CDA legalAuthenticator RAP): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.122
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticator RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d3284334e0-false-d3284340e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3284334e0-false-d3284340e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3284823e0-false-d3284829e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3284823e0-false-d3284829e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3284987e0-false-d3285023e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3284987e0-false-d3285023e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3285193e0-false-d3285197e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3285193e0-false-d3285197e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3285363e0-false-d3285369e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3285363e0-false-d3285369e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3285527e0-false-d3285563e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3285527e0-false-d3285563e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.123
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA authenticator RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
         id="d3284099e568-false-d3285790e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">(CDA authenticator RAP): The value for typeCode SHALL be 'AUTHEN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:time) &gt;= 1">(CDA authenticator RAP): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:time) &lt;= 1">(CDA authenticator RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA authenticator RAP): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA authenticator RAP): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA authenticator RAP): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA authenticator RAP): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.123
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA authenticator RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.123
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA authenticator RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d3284099e605-false-d3285885e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html"
              test="string(@code) = ('S')">(CDA authenticator RAP): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.123
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA authenticator RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d3286185e0-false-d3286191e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3286185e0-false-d3286191e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3286674e0-false-d3286680e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3286674e0-false-d3286680e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3286838e0-false-d3286874e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3286838e0-false-d3286874e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3287044e0-false-d3287048e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3287044e0-false-d3287048e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3287214e0-false-d3287220e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3287214e0-false-d3287220e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3287378e0-false-d3287414e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3287378e0-false-d3287414e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d3285950e568-false-d3287639e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@typeCode">(CDA participant RAP): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RAP): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA participant RAP): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA participant RAP): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:time) &lt;= 1">(CDA participant RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(CDA participant RAP): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(CDA participant RAP): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d3285950e602-false-d3287740e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA participant RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@code">(CDA participant RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@codeSystem">(CDA participant RAP): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDA participant RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d3285950e618-false-d3287829e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@classCode">(CDA participant RAP): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RAP): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:id) &gt;= 1">(CDA participant RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:code) &lt;= 1">(CDA participant RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:associatedPerson) &lt;= 1">(CDA participant RAP): element hl7:associatedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1">(CDA participant RAP): element hl7:scopingOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d3285950e625-false-d3287932e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@root">(CDA participant RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@extension">(CDA participant RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA participant RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA participant RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
         id="d3285950e634-false-d3287953e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA participant RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr">
      <extends rule="d3288006e0-false-d3288012e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@use">(CDA participant RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3288006e0-false-d3288012e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (CDA participant RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
         id="d3285950e655-false-d3288124e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="@use">(CDA participant RAP): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA participant RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.124
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA participant RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3288495e0-false-d3288501e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3288495e0-false-d3288501e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3288659e0-false-d3288695e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3288659e0-false-d3288695e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3288865e0-false-d3288869e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3288865e0-false-d3288869e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3289035e0-false-d3289041e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3289035e0-false-d3289041e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3289199e0-false-d3289235e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3289199e0-false-d3289235e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.125
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]
Item: (CDA inFulfillmentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]"
         id="d3288321e400-false-d3289412e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf RAP): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:order) &gt;= 1">(CDA inFulfillmentOf RAP): element hl7:order is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:order) &lt;= 1">(CDA inFulfillmentOf RAP): element hl7:order appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.125
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order
Item: (CDA inFulfillmentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
         id="d3288321e410-false-d3289432e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf RAP): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(CDA inFulfillmentOf RAP): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:id) &lt;= 1">(CDA inFulfillmentOf RAP): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="count(hl7:priorityCode) &lt;= 1">(CDA inFulfillmentOf RAP): element hl7:priorityCode appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.125
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id
Item: (CDA inFulfillmentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
         id="d3288321e416-false-d3289468e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="@root">(CDA inFulfillmentOf RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="@extension">(CDA inFulfillmentOf RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA inFulfillmentOf RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.125
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code
Item: (CDA inFulfillmentOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.125
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode
Item: (CDA inFulfillmentOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]
Item: (CDA documentationOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]"
         id="d3289496e20-false-d3289552e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="string(@typeCode) = ('DOC') or not(@typeCode)">(CDA documentationOf RAP): The value for typeCode SHALL be 'DOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:serviceEvent) &gt;= 1">(CDA documentationOf RAP): element hl7:serviceEvent is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:serviceEvent) &lt;= 1">(CDA documentationOf RAP): element hl7:serviceEvent appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent
Item: (CDA documentationOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent"
         id="d3289496e30-false-d3289670e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA documentationOf RAP): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA documentationOf RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:code) &lt;= 1">(CDA documentationOf RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA documentationOf RAP): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:id
Item: (CDA documentationOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:id"
         id="d3289496e47-false-d3289754e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="@root">(CDA documentationOf RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA documentationOf RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="@extension">(CDA documentationOf RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA documentationOf RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:code
Item: (CDA documentationOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:effectiveTime
Item: (CDA documentationOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]
Item: (CDA documentationOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]"
         id="d3289496e75-false-d3289837e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="@typeCode">(CDA documentationOf RAP): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(CDA documentationOf RAP): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA documentationOf RAP): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:time) &lt;= 1">(CDA documentationOf RAP): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA documentationOf RAP): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA documentationOf RAP): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:functionCode
Item: (CDA documentationOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:time
Item: (CDA documentationOf RAP)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.126
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA documentationOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d3290224e0-false-d3290230e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3290224e0-false-d3290230e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3290713e0-false-d3290719e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3290713e0-false-d3290719e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3290877e0-false-d3290913e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3290877e0-false-d3290913e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3291083e0-false-d3291087e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3291083e0-false-d3291087e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3291253e0-false-d3291259e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3291253e0-false-d3291259e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3291417e0-false-d3291453e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3291417e0-false-d3291453e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d3289989e568-false-d3291630e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="@typeCode">(CDA relatedDocument RAP): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument RAP): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument RAP): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument RAP): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d3289989e613-false-d3291661e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument RAP): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument RAP): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocument RAP): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument RAP): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument RAP): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument RAP): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d3289989e619-false-d3291707e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="@root">(CDA relatedDocument RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="@extension">(CDA relatedDocument RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocument RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d3289989e639-false-d3291725e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="@code">(CDA relatedDocument RAP): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="@codeSystem">(CDA relatedDocument RAP): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.128
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d3291767e20-false-d3291867e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf RAP): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:encompassingEncounter) &gt;= 1">(CDA componentOf RAP): element hl7:encompassingEncounter is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:encompassingEncounter) &lt;= 1">(CDA componentOf RAP): element hl7:encompassingEncounter appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter"
         id="d3291767e30-false-d3292073e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf RAP): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf RAP): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf RAP): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf RAP): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf RAP): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:responsibleParty[hl7:assignedEntity]) &lt;= 1">(CDA componentOf RAP): element hl7:responsibleParty[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf RAP): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id"
         id="d3291767e36-false-d3292215e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@root">(CDA componentOf RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@extension">(CDA componentOf RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d3291767e45-false-d3292239e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:effectiveTime
Item: (CDA componentOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]"
         id="d3291767e78-false-d3292325e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf RAP): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA componentOf RAP): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf RAP): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA componentOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d3292683e0-false-d3292689e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3292683e0-false-d3292689e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3293172e0-false-d3293178e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3293172e0-false-d3293178e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3293336e0-false-d3293372e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3293336e0-false-d3293372e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3293542e0-false-d3293546e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3293542e0-false-d3293546e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3293712e0-false-d3293718e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3293712e0-false-d3293718e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3293876e0-false-d3293912e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3293876e0-false-d3293912e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]"
         id="d3291767e91-false-d3294132e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf RAP): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:healthCareFacility) &gt;= 1">(CDA componentOf RAP): element hl7:healthCareFacility is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:healthCareFacility) &lt;= 1">(CDA componentOf RAP): element hl7:healthCareFacility appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility"
         id="d3291767e95-false-d3294240e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf RAP): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf RAP): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf RAP): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG']) &lt;= 1">(CDA componentOf RAP): element hl7:serviceProviderOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id"
         id="d3291767e126-false-d3294321e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@root">(CDA componentOf RAP): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RAP): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@extension">(CDA componentOf RAP): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf RAP): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf RAP)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d3291767e135-false-d3294345e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf RAP): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf RAP): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA componentOf RAP)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location">
      <extends rule="d3294404e0-false-d3294419e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf RAP): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA place )
-->
   <rule fpi="RULC-1" id="d3294404e0-false-d3294419e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:name) &lt;= 1">(CDA place ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:addr) &lt;= 1">(CDA place ): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:templateId
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:name
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA place )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr">
      <extends rule="d3294501e0-false-d3294507e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="@use">(CDA place ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3294501e0-false-d3294507e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.127
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA componentOf RAP)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d3294826e0-false-d3294832e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3294826e0-false-d3294832e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3294990e0-false-d3295026e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3294990e0-false-d3295026e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d3295196e0-false-d3295200e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d3295196e0-false-d3295200e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d3295366e0-false-d3295372e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3295366e0-false-d3295372e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d3295530e0-false-d3295566e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d3295530e0-false-d3295566e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]"
         id="d44e21407-false-d3296243e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Anatomia Patologica (RAP)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:structuredBody) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:structuredBody is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:structuredBody) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:structuredBody appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody
Item: (Referto di Anatomia Patologica (RAP))
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
         id="d44e21411-false-d3297265e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Referto di Anatomia Patologica (RAP)): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Anatomia Patologica (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.142']]]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.142']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.142']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.142']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.149']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.149']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.193']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.193']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.190']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.190']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.197']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.197']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.211']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.211']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.176']]]) &gt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.176']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.176']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.176']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.220']]]) &lt;= 1">(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.220']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.8.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]
Item: (Referto di Anatomia Patologica (RAP))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]">
      <extends rule="d3297971e0-false-d3297975e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Anatomia Patologica (RAP)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]
Item: (Notizie Cliniche (RAP))
-->
   <rule fpi="RULC-1" id="d3297971e0-false-d3297975e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]
Item: (Notizie Cliniche (RAP))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Notizie Cliniche (RAP)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Notizie Cliniche (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']) &gt;= 1">(Notizie Cliniche (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Notizie Cliniche (RAP)): element hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:title) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:text) &gt;= 1">(Notizie Cliniche (RAP)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:text) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.282']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.282']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.130']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.130']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.155']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.155']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.167']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.167']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.169']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.169']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.175']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.175']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.180']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.180']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.184']]]) &lt;= 1">(Notizie Cliniche (RAP)): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.184']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']
Item: (Notizie Cliniche (RAP))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.132')">(Notizie Cliniche (RAP)): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.132'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Notizie Cliniche (RAP))
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:code[(@code = '22636-5' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@code) = ('22636-5')">(Notizie Cliniche (RAP)): The value for code SHALL be '22636-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Notizie Cliniche (RAP)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Notizie Cliniche (RAP)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Notizie Cliniche (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.132-2022-09-21T124529.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Notizie Cliniche (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:title
Item: (Notizie Cliniche (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:text
Item: (Notizie Cliniche (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.132
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]
Item: (Notizie Cliniche (RAP))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(CDA author RAP-SEC): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author RAP-SEC): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author RAP-SEC): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA author RAP-SEC): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:time) &gt;= 1">(CDA author RAP-SEC): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:time) &lt;= 1">(CDA author RAP-SEC): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA author RAP-SEC): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA author RAP-SEC): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (CDA author RAP-SEC)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author RAP-SEC)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA author RAP-SEC): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:id) &gt;= 1">(CDA author RAP-SEC): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:code) &lt;= 1">(CDA author RAP-SEC): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author RAP-SEC): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1">(CDA author RAP-SEC): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author RAP-SEC): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="@root">(CDA author RAP-SEC): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author RAP-SEC): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="@extension">(CDA author RAP-SEC): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author RAP-SEC): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author RAP-SEC): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA author RAP-SEC)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr">
      <extends rule="d3299731e0-false-d3299737e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="@use">(CDA author RAP-SEC): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RAP-SEC): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d3299731e0-false-d3299737e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="@use">(CDA author RAP-SEC): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author RAP-SEC): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.280
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA author RAP-SEC)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d3299897e0-false-d3299909e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author RAP-SEC): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.280-2023-01-18T173853.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author RAP-SEC): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.132']]/hl7:author[hl7:author]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d3299897e0-false-d3299909e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = 