<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.6.86
Name: Data decesso (VPS)
Description: Date of death (LOINC: 31211-6)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000">
   <title>Data decesso (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]
Item: (Data decesso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]
Item: (Data decesso (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]"
         id="d44e20691-false-d3270803e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS')">(Data decesso (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Data decesso (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']) &gt;= 1">(Data decesso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']) &lt;= 1">(Data decesso (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Data decesso (VPS)): element hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Data decesso (VPS)): element hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Data decesso (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Data decesso (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Data decesso (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Data decesso (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']
Item: (Data decesso (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']"
         id="d44e20697-false-d3270859e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.86')">(Data decesso (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.86'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:id
Item: (Data decesso (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Data decesso (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:code[(@code = '31211-6' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]"
         id="d44e20704-false-d3270879e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="@nullFlavor or (@code='31211-6' and @codeSystem='2.16.840.1.113883.6.1' and @displayName='Date of death')">(Data decesso (VPS)): The element value SHALL be one of 'code '31211-6' codeSystem '2.16.840.1.113883.6.1' displayName='Date of death''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Data decesso (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e20713-false-d3270893e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Data decesso (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.86
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.86']]/hl7:effectiveTime
Item: (Data decesso (VPS))
-->
</pattern>
