<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.6.68
Name: Ragione (VPS)
Description: Reason
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000">
   <title>Ragione (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]
Item: (Ragione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]
Item: (Ragione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]"
         id="d44e20033-false-d3269023e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="string(@classCode) = ('OBS')">(Ragione (VPS)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Ragione (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']) &gt;= 1">(Ragione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']) &lt;= 1">(Ragione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1">(Ragione (VPS)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Ragione (VPS)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &gt;= 1">(Ragione (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @nullFlavor]) &lt;= 1">(Ragione (VPS)): element hl7:statusCode[@code = 'completed' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Ragione (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Ragione (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']
Item: (Ragione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']"
         id="d44e20039-false-d3269080e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.68')">(Ragione (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.68'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Ragione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d44e20044-false-d3269094e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.13-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Ragione (VPS)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.13 ProblemType_VPS (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:statusCode[@code = 'completed' or @nullFlavor]
Item: (Ragione (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:statusCode[@code = 'completed' or @nullFlavor]"
         id="d44e20052-false-d3269112e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.html"
              test="@nullFlavor or (@code='completed')">(Ragione (VPS)): The element value SHALL be one of 'code 'completed''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:effectiveTime
Item: (Ragione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.68
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.68']]/hl7:value
Item: (Ragione (VPS))
-->
</pattern>
