<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.6.51
Name: Encounter Activity (VPS)
Description: Encounter Activity
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000">
   <title>Encounter Activity (VPS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]
Item: (Encounter Activity (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]
Item: (Encounter Activity (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]"
         id="d44e18731-false-d3263844e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="string(@classCode) = ('ENC')">(Encounter Activity (VPS)): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="string(@moodCode) = ('EVN')">(Encounter Activity (VPS)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']) &gt;= 1">(Encounter Activity (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']) &lt;= 1">(Encounter Activity (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:code) &lt;= 1">(Encounter Activity (VPS)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:text) &lt;= 1">(Encounter Activity (VPS)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Encounter Activity (VPS)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Encounter Activity (VPS)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']
Item: (Encounter Activity (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']"
         id="d44e18737-false-d3264027e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.51')">(Encounter Activity (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.51'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:id
Item: (Encounter Activity (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:code
Item: (Encounter Activity (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:text
Item: (Encounter Activity (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:effectiveTime
Item: (Encounter Activity (VPS))
-->

   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:effectiveTime"
         id="d44e18775-false-d3264062e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:low) &gt;= 1">(Encounter Activity (VPS)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:low) &lt;= 1">(Encounter Activity (VPS)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:high) &gt;= 1">(Encounter Activity (VPS)): element hl7:high is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:high) &lt;= 1">(Encounter Activity (VPS)): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:effectiveTime/hl7:low
Item: (Encounter Activity (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:effectiveTime/hl7:high
Item: (Encounter Activity (VPS))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]
Item: (Encounter Activity (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]">
      <extends rule="d3264339e0-false-d3264343e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('ADM')))])">(Encounter Activity (VPS)): The value for typeCode SHALL be 'code ADM'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:time
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole">
      <extends rule="d3264339e22-false-d3264443e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant persona (VPS)): element hl7:id is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:id
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <extends rule="d3264255e0-false-d3264261e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Participant persona (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Participant persona (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1" id="d3264255e0-false-d3264261e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3264339e0-false-d3264343e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@typeCode">(CDA Participant (Body)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Participant (Body)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Participant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Participant (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Participant (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(CDA Participant (Body)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(CDA Participant (Body)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:time
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3264339e22-false-d3264443e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:playingDevice | hl7:playingEntity) &lt;= 1">(CDA Participant (Body)): choice (hl7:playingDevice  or  hl7:playingEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDA Participant (Body)): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:code
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:addr
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:telecom
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Participant (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Participant (Body)): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ADM'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]
Item: (Encounter Activity (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]">
      <extends rule="d3265039e0-false-d3265043e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('ATND')))])">(Encounter Activity (VPS)): The value for typeCode SHALL be 'code ATND'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:time
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole">
      <extends rule="d3265039e22-false-d3265143e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant persona (VPS)): element hl7:id is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:id
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <extends rule="d3264955e0-false-d3264961e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Participant persona (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Participant persona (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1" id="d3264955e0-false-d3264961e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3265039e0-false-d3265043e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@typeCode">(CDA Participant (Body)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Participant (Body)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Participant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Participant (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Participant (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(CDA Participant (Body)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(CDA Participant (Body)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:time
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3265039e22-false-d3265143e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:playingDevice | hl7:playingEntity) &lt;= 1">(CDA Participant (Body)): choice (hl7:playingDevice  or  hl7:playingEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDA Participant (Body)): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:code
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:addr
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:telecom
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Participant (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Participant (Body)): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'ATND'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]
Item: (Encounter Activity (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]">
      <extends rule="d3265739e0-false-d3265743e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('DIS')))])">(Encounter Activity (VPS)): The value for typeCode SHALL be 'code DIS'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:time
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole">
      <extends rule="d3265739e22-false-d3265843e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant persona (VPS)): element hl7:id is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:id
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (Participant persona (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <extends rule="d3265655e0-false-d3265661e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &gt;= 1">(Participant persona (VPS)): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.5-2018-03-19T000000.html"
              test="count(hl7:name) &lt;= 1">(Participant persona (VPS)): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.5
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (Participant persona (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1" id="d3265655e0-false-d3265661e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3265739e0-false-d3265743e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@typeCode">(CDA Participant (Body)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Participant (Body)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Participant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Participant (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Participant (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(CDA Participant (Body)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(CDA Participant (Body)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:time
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3265739e22-false-d3265843e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:playingDevice | hl7:playingEntity) &lt;= 1">(CDA Participant (Body)): choice (hl7:playingDevice  or  hl7:playingEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDA Participant (Body)): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:code
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:addr
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:telecom
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Participant (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Participant (Body)): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[@typeCode = 'DIS'][@typeCode]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]
Item: (Encounter Activity (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]">
      <extends rule="d3266345e0-false-d3266349e0"/>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (('LOC')))])">(Encounter Activity (VPS)): The value for typeCode SHALL be 'code LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]) &gt;= 1">(Encounter Activity (VPS)): element hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="count(hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]) &lt;= 1">(Encounter Activity (VPS)): element hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.6
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:time
Item: (Participant collocazione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.6
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]
Item: (Participant collocazione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(Participant collocazione (VPS)): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']) &gt;= 1">(Participant collocazione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']) &lt;= 1">(Participant collocazione (VPS)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="count(hl7:id) &gt;= 1">(Participant collocazione (VPS)): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.1.11.1.2.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(Participant collocazione (VPS)): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.1.11.1.2.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.6
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']
Item: (Participant collocazione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.6.64')">(Participant collocazione (VPS)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.6.64'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.6
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]/hl7:id
Item: (Participant collocazione (VPS))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.6
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.1.11.1.2.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (Participant collocazione (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.1.11.1.2.10-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.6-2018-03-19T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.1.11.1.2.10-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Participant collocazione (VPS)): The element value SHALL be one of '2.16.840.1.113883.2.9.1.11.1.2.10 TipoLuogo_VPS (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1" id="d3266345e0-false-d3266349e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@typeCode">(CDA Participant (Body)): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Participant (Body)): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Participant (Body)): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:time) &lt;= 1">(CDA Participant (Body)): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA Participant (Body)): element hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &gt;= 1">(CDA Participant (Body)): element hl7:participantRole is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:participantRole) &lt;= 1">(CDA Participant (Body)): element hl7:participantRole appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:time
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:awarenessCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10310-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.10310 TargetAwareness (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:playingDevice | hl7:playingEntity) &lt;= 1">(CDA Participant (Body)): choice (hl7:playingDevice  or  hl7:playingEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:scopingEntity) &lt;= 1">(CDA Participant (Body)): element hl7:scopingEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:code
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:addr
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:telecom
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA Device): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Device): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Device): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA Device): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA Device): element hl7:softwareName appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice/hl7:code
Item: (CDA Device)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.315-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Device): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice/hl7:manufacturerModelName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.315
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingDevice/hl7:softwareName
Item: (CDA Device)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA PlayingEntity): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA PlayingEntity): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA PlayingEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA PlayingEntity): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity/hl7:code
Item: (CDA PlayingEntity)
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.313-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA PlayingEntity): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity/hl7:quantity
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity/hl7:name
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.313
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:playingEntity/hl7:desc
Item: (CDA PlayingEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@classCode) = ('ENT') or not(@classCode)">(CDA Participant (Body)): The value for classCode SHALL be 'ENT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Participant (Body)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:code) &lt;= 1">(CDA Participant (Body)): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="count(hl7:desc) &lt;= 1">(CDA Participant (Body)): element hl7:desc appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity/hl7:id
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity/hl7:code
Item: (CDA Participant (Body))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity/hl7:code">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.10.12.321-2005-09-07T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16040-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem] | conceptList/include[@codeSystem = $theCodeSystem]])">(CDA Participant (Body)): The element value SHALL be one of '2.16.840.1.113883.1.11.16040 EntityCode (DYNAMIC)'.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.10.12.321
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:participant[hl7:participantRole[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.64']]]/hl7:participantRole/hl7:scopingEntity/hl7:desc
Item: (CDA Participant (Body))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.6.51
Context: *[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.47']]]
Item: (Encounter Activity (VPS))
-->
   <rule fpi="RULC-1"
         context="*[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.51']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.47']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="string(@typeCode) = ('SUBJ')">(Encounter Activity (VPS)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="string(@contextConductionInd) = ('true')">(Encounter Activity (VPS)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.html"
              test="not(@inversionInd) or string(@inversionInd)=('true','false')">(Encounter Activity (VPS)): Attribute @inversionInd SHALL be of data type 'bl'  - '<value-of select="@inversionInd"/>'</assert>
   </rule>
</pattern>
