<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Name: Diagnosi di dimissione (LDO)
Description: Diagnosi di dimissione
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000">
   <title>Diagnosi di dimissione (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]
Item: (Diagnosi di dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]
Item: (Diagnosi di dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]"
         id="d44e15720-false-d3084578e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="string(@classCode) = ('OBS')">(Diagnosi di dimissione (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="@moodCode">(Diagnosi di dimissione (LDO)): attribute @moodCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@moodCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="not(@moodCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.18943-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Diagnosi di dimissione (LDO)): The value for moodCode SHALL be selected from value set '2.16.840.1.113883.1.11.18943' x_ActMoodDocumentObservation (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="not(@negationInd) or string(@negationInd)=('true','false')">(Diagnosi di dimissione (LDO)): Attribute @negationInd SHALL be of data type 'bl'  - '<value-of select="@negationInd"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']) &gt;= 1">(Diagnosi di dimissione (LDO)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']) &lt;= 1">(Diagnosi di dimissione (LDO)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &gt;= 1">(Diagnosi di dimissione (LDO)): element hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]) &lt;= 1">(Diagnosi di dimissione (LDO)): element hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Diagnosi di dimissione (LDO)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]) &lt;= 1">(Diagnosi di dimissione (LDO)): element hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Diagnosi di dimissione (LDO)): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']
Item: (Diagnosi di dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']"
         id="d44e15733-false-d3084655e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.5.4.3')">(Diagnosi di dimissione (LDO)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.5.4.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:id
Item: (Diagnosi di dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]
Item: (Diagnosi di dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1') or @nullFlavor]"
         id="d44e15741-false-d3084675e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="@nullFlavor or (@code='8651-2' and @codeSystem='2.16.840.1.113883.6.1')">(Diagnosi di dimissione (LDO)): The element value SHALL be one of 'code '8651-2' codeSystem '2.16.840.1.113883.6.1''.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:text
Item: (Diagnosi di dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]
Item: (Diagnosi di dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:statusCode[@code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code or @nullFlavor]"
         id="d44e15748-false-d3084699e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.4.3-2018-04-11T000000.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Diagnosi di dimissione (LDO)): The element value SHALL be one of '2.16.840.1.113883.1.11.15933 ActStatus (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:effectiveTime
Item: (Diagnosi di dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.4.3
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.5.4.3']]/hl7:value
Item: (Diagnosi di dimissione (LDO))
-->
</pattern>
