<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Name: Allergie (LDO)
Description: Allergies (LOINC: 48765-2)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000">
   <title>Allergie (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Allergie (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Allergie (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]"
         id="d44e15454-false-d3074133e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Allergie (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Allergie (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Allergie (LDO)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Allergie (LDO)): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Allergie (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Allergie (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Allergie (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Allergie (LDO)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Allergie (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e15462-false-d3074198e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@code) = ('48765-2')">(Allergie (LDO)): The value for code SHALL be '48765-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Allergie (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Allergie (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Allergie (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="string(@displayName) = ('ALLERGIE E/O REAZIONI AVVERSE') or not(@displayName)">(Allergie (LDO)): The value for displayName SHALL be 'ALLERGIE E/O REAZIONI AVVERSE'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.9-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Allergie (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Allergie (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Allergie (LDO))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.9
Context: *[hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Allergie (LDO))
--></pattern>
