<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Name: Decorso Ospedaliero (LDO)
Description: Hospital Course  (LOINC: 8648-8 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000">
   <title>Decorso Ospedaliero (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Context: *[hl7:section]
Item: (Decorso Ospedaliero (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Context: *[hl7:section]/hl7:section
Item: (Decorso Ospedaliero (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section"
         id="d44e15297-false-d3073438e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Decorso Ospedaliero (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Decorso Ospedaliero (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="count(hl7:code[@code = '8648-8']) &lt;= 1">(Decorso Ospedaliero (LDO)): element hl7:code[@code = '8648-8'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Decorso Ospedaliero (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Decorso Ospedaliero (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Decorso Ospedaliero (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Decorso Ospedaliero (LDO)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Context: *[hl7:section]/hl7:section/hl7:code[@code = '8648-8']
Item: (Decorso Ospedaliero (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:code[@code = '8648-8']"
         id="d44e15305-false-d3073478e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@code) = ('8648-8')">(Decorso Ospedaliero (LDO)): The value for code SHALL be '8648-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">(Decorso Ospedaliero (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Decorso Ospedaliero (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Decorso Ospedaliero (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="string(@displaName) = ('Decorso Ospedaliero') or not(@displaName)">(Decorso Ospedaliero (LDO)): The value for displaName SHALL be 'Decorso Ospedaliero'. Found: "<value-of select="@displaName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.6-2018-04-11T000000.html"
              test="not(@displaName) or string-length(@displaName)&gt;0">(Decorso Ospedaliero (LDO)): Attribute @displaName SHALL be of data type 'st'  - '<value-of select="@displaName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Context: *[hl7:section]/hl7:section/hl7:title
Item: (Decorso Ospedaliero (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.6
Context: *[hl7:section]/hl7:section/hl7:text
Item: (Decorso Ospedaliero (LDO))
-->
</pattern>
