<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Name: Terapia Farmacologica all’Ingresso (LDO)
Description: Medications On Admission (LOINC: 42346-7)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000">
   <title>Terapia Farmacologica all’Ingresso (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Context: *[hl7:section]
Item: (Terapia Farmacologica all’Ingresso (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Context: *[hl7:section]/hl7:section
Item: (Terapia Farmacologica all’Ingresso (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section"
         id="d44e15247-false-d3073339e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Terapia Farmacologica all’Ingresso (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Terapia Farmacologica all’Ingresso (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="count(hl7:code[@code = '42346-7']) &lt;= 1">(Terapia Farmacologica all’Ingresso (LDO)): element hl7:code[@code = '42346-7'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Terapia Farmacologica all’Ingresso (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Terapia Farmacologica all’Ingresso (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Terapia Farmacologica all’Ingresso (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Terapia Farmacologica all’Ingresso (LDO)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Context: *[hl7:section]/hl7:section/hl7:code[@code = '42346-7']
Item: (Terapia Farmacologica all’Ingresso (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:code[@code = '42346-7']"
         id="d44e15255-false-d3073379e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@code) = ('42346-7')">(Terapia Farmacologica all’Ingresso (LDO)): The value for code SHALL be '42346-7'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">(Terapia Farmacologica all’Ingresso (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Terapia Farmacologica all’Ingresso (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Terapia Farmacologica all’Ingresso (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="string(@displayName) = ('Terapia Farmacologica all’ingresso') or not(@displayName)">(Terapia Farmacologica all’Ingresso (LDO)): The value for displayName SHALL be 'Terapia Farmacologica all’ingresso'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.5-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Terapia Farmacologica all’Ingresso (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Context: *[hl7:section]/hl7:section/hl7:title
Item: (Terapia Farmacologica all’Ingresso (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.5
Context: *[hl7:section]/hl7:section/hl7:text
Item: (Terapia Farmacologica all’Ingresso (LDO))
-->
</pattern>
