<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Name: Esame Obiettivo (LDO)
Description: Physical Examination (LOINC: 29545-1 )
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000">
   <title>Esame Obiettivo (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Context: *[hl7:section]
Item: (Esame Obiettivo (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Context: *[hl7:section]/hl7:section
Item: (Esame Obiettivo (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section"
         id="d44e15197-false-d3073240e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Esame Obiettivo (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Esame Obiettivo (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="count(hl7:code[@code = '29545-1']) &lt;= 1">(Esame Obiettivo (LDO)): element hl7:code[@code = '29545-1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Esame Obiettivo (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Esame Obiettivo (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Esame Obiettivo (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Esame Obiettivo (LDO)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Context: *[hl7:section]/hl7:section/hl7:code[@code = '29545-1']
Item: (Esame Obiettivo (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section]/hl7:section/hl7:code[@code = '29545-1']"
         id="d44e15205-false-d3073280e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@code) = ('29545-1')">(Esame Obiettivo (LDO)): The value for code SHALL be '29545-1'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">(Esame Obiettivo (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Esame Obiettivo (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Esame Obiettivo (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="string(@displayName) = ('Esame Obiettivo') or not(@displayName)">(Esame Obiettivo (LDO)): The value for displayName SHALL be 'Esame Obiettivo'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.4-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Esame Obiettivo (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Context: *[hl7:section]/hl7:section/hl7:title
Item: (Esame Obiettivo (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.4
Context: *[hl7:section]/hl7:section/hl7:text
Item: (Esame Obiettivo (LDO))
-->
</pattern>
