<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Name: Anamnesi (LDO)
Description: History General (LOINC: 11329-0)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000">
   <title>Anamnesi (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]
Item: (Anamnesi (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]
Item: (Anamnesi (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]"
         id="d44e15152-false-d3072486e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Anamnesi (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Anamnesi (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:code[@code = '11329-0']) &gt;= 1">(Anamnesi (LDO)): element hl7:code[@code = '11329-0'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:code[@code = '11329-0']) &lt;= 1">(Anamnesi (LDO)): element hl7:code[@code = '11329-0'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Anamnesi (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Anamnesi (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Anamnesi (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Anamnesi (LDO)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:code[@code = '11329-0']
Item: (Anamnesi (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:code[@code = '11329-0']"
         id="d44e15160-false-d3072540e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@code) = ('11329-0')">(Anamnesi (LDO)): The value for code SHALL be '11329-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">(Anamnesi (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Anamnesi (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Anamnesi (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="string(@displayName) = ('Anamnesi Generale') or not(@displayName)">(Anamnesi (LDO)): The value for displayName SHALL be 'Anamnesi Generale'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.3-2018-04-11T000000.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Anamnesi (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:title
Item: (Anamnesi (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:text
Item: (Anamnesi (LDO))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.3
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Anamnesi (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@moodCode) = ('EVN')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:text[hl7:reference]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:text[hl7:reference] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:statusCode[@code = 'completed']) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:statusCode[@code = 'completed'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:statusCode[@code = 'completed']) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:statusCode[@code = 'completed'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:effectiveTime[hl7:low]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:effectiveTime[hl7:low] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:value) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:value) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:value appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@code) = ('75326-9')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for code SHALL be '75326-9'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@displayName) = ('Problem') or not(@displayName)">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for displayName SHALL be 'Problem'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:reference) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:reference) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text[hl7:reference]/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="@value">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): attribute @value SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode[@code = 'completed']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@code) = ('completed')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for code SHALL be 'completed'. Found: "<value-of select="@code"/>"</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.15933' ActStatus (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:low) &gt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:low is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:low) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:low appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:high) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:high appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:low
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:effectiveTime[hl7:low]/hl7:high
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:orignalText) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:orignalText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value/hl7:orignalText
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value/hl7:orignalText">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="count(hl7:reference) &lt;= 1">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value/hl7:orignalText/hl7:reference
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d3072893e0-false-d3072897e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="@typeCode">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Cronicità della Patologia (observation) (LDO))
-->
   <rule fpi="RULC-1" id="d3072893e0-false-d3072897e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Cronicità della Patologia (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Cronicità della Patologia (observation) (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@moodCode) = ('EVN')">(Cronicità della Patologia (observation) (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:text) &lt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:statusCode) &lt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10']) &gt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10']) &lt;= 1">(Cronicità della Patologia (observation) (LDO)): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Cronicità della Patologia (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@code) = ('89261-2')">(Cronicità della Patologia (observation) (LDO)): The value for code SHALL be '89261-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Cronicità della Patologia (observation) (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Cronicità della Patologia (observation) (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cronicità della Patologia (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@displayName) = ('Decorso Clinico') or not(@displayName)">(Cronicità della Patologia (observation) (LDO)): The value for displayName SHALL be 'Decorso Clinico'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cronicità della Patologia (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Cronicità della Patologia (observation) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode
Item: (Cronicità della Patologia (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="@code">(Cronicità della Patologia (observation) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Cronicità della Patologia (observation) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.544
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10']
Item: (Cronicità della Patologia (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '89261-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.10']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="@code">(Cronicità della Patologia (observation) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.41-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Cronicità della Patologia (observation) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.41' ProblemCronicity_PSSIT (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.10')">(Cronicità della Patologia (observation) (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.10'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Cronicità della Patologia (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.544-2024-04-18T094245.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Cronicità della Patologia (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.543
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <extends rule="d3073067e0-false-d3073071e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.543-2024-04-17T185013.html"
              test="string(@typeCode) = ('SUBJ')">(Dettaglio Anamnesi Patologica Fisiologica (observation) (LDO)): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Stato Clinico del problema (observation) (LDO))
-->
   <rule fpi="RULC-1" id="d3073067e0-false-d3073071e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Stato Clinico del problema (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Stato Clinico del problema (observation) (LDO)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@moodCode) = ('EVN')">(Stato Clinico del problema (observation) (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:text) &lt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:statusCode) &lt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:value) &gt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="count(hl7:value) &lt;= 1">(Stato Clinico del problema (observation) (LDO)): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Stato Clinico del problema (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@code) = ('33999-4')">(Stato Clinico del problema (observation) (LDO)): The value for code SHALL be '33999-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Stato Clinico del problema (observation) (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Stato Clinico del problema (observation) (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stato Clinico del problema (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@displayName) = ('Stato') or not(@displayName)">(Stato Clinico del problema (observation) (LDO)): The value for displayName SHALL be 'Stato'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stato Clinico del problema (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Stato Clinico del problema (observation) (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode
Item: (Stato Clinico del problema (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:statusCode">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="@code">(Stato Clinico del problema (observation) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.10-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Stato Clinico del problema (observation) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.10' X_ActStatusActiveSuspendedAbortedCompleted (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.545
Context: *[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value
Item: (Stato Clinico del problema (observation) (LDO))
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[@code = '11329-0']]]/hl7:section[hl7:code[@code = '11329-0']]/hl7:entry[hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '75326-9' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entryRelationship[hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '33999-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="@code">(Stato Clinico del problema (observation) (LDO)): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.55-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Stato Clinico del problema (observation) (LDO)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.55' StatoClinicoProblema_PSSIT (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.7') or not(@codeSystem)">(Stato Clinico del problema (observation) (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.7'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Stato Clinico del problema (observation) (LDO)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.545-2024-04-23T134125.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Stato Clinico del problema (observation) (LDO)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
