<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Name: Condizioni del paziente e diagnosi alla dimissione (LDO)
Description: Hospital Discharge Dx (LOINC: 11535-2)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000">
   <title>Condizioni del paziente e diagnosi alla dimissione (LDO)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]"
         id="d44e14909-false-d3071599e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@classCode) = ('DOCSECT') or not(@classCode)">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for classCode SHALL be 'DOCSECT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:title) &gt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:title is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:title) &lt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:text) &gt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:text) &lt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="count(hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Condizioni del paziente e diagnosi alla dimissione (LDO)): element hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e14917-false-d3071651e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@code) = ('11535-2')">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for code SHALL be '11535-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.5.3.11-2018-04-11T000000.html"
              test="string(@displayName) = ('Diagnosi di Dimissione') or not(@displayName)">(Condizioni del paziente e diagnosi alla dimissione (LDO)): The value for displayName SHALL be 'Diagnosi di Dimissione'. Found: "<value-of select="@displayName"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.5.3.11
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Condizioni del paziente e diagnosi alla dimissione (LDO))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Condizione dimissione - (observation) LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(Condizione dimissione - (observation) LDO): element hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(Condizione dimissione - (observation) LDO): element hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (Condizione dimissione - (observation) LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Condizione dimissione - (observation) LDO): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@moodCode) = ('EVN')">(Condizione dimissione - (observation) LDO): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Condizione dimissione - (observation) LDO): element hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Condizione dimissione - (observation) LDO): element hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:text) &lt;= 1">(Condizione dimissione - (observation) LDO): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:value) &gt;= 1">(Condizione dimissione - (observation) LDO): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:value) &lt;= 1">(Condizione dimissione - (observation) LDO): element hl7:value appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Condizione dimissione - (observation) LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@code) = ('8651-2')">(Condizione dimissione - (observation) LDO): The value for code SHALL be '8651-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Condizione dimissione - (observation) LDO): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Condizione dimissione - (observation) LDO): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@displayName) = ('Diagnosi di Dimissione Ospedaliera') or not(@displayName)">(Condizione dimissione - (observation) LDO): The value for displayName SHALL be 'Diagnosi di Dimissione Ospedaliera'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (Condizione dimissione - (observation) LDO)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value
Item: (Condizione dimissione - (observation) LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Condizione dimissione - (observation) LDO): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@code) = ('2.16.840.1.113883.6.103') or not(@code)">(Condizione dimissione - (observation) LDO): The value for code SHALL be '2.16.840.1.113883.6.103'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="string(@codeSystem) = ('ICD9-CM') or not(@codeSystem)">(Condizione dimissione - (observation) LDO): The value for codeSystem SHALL be 'ICD9-CM'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@codeSystem) or string-length(@codeSystem)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @codeSystem SHALL be of data type 'st'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="count(hl7:translation) &lt;= 1">(Condizione dimissione - (observation) LDO): element hl7:translation appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.568
Context: *[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value/hl7:translation
Item: (Condizione dimissione - (observation) LDO)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '11535-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:entry[hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:observation[hl7:code[(@code = '8651-2' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:value/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Condizione dimissione - (observation) LDO): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Condizione dimissione - (observation) LDO): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.568-2024-04-25T171506.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Condizione dimissione - (observation) LDO): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
