<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.12.1
Name: CDA ClinicalDocument (with nonXMLBody)
Description: Template CDA ClinicalDocument (prototype, contains ClinicalDocument.component as nonXMLBody)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757">
   <title>CDA ClinicalDocument (with nonXMLBody)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]"
         id="d44e8872-false-d327291e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@classCode) = ('DOCCLIN')">(CDA ClinicalDocument (with nonXMLBody)): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@moodCode) = ('EVN')">(CDA ClinicalDocument (with nonXMLBody)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:id[not(@nullFlavor)]) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:id[not(@nullFlavor)]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:id[not(@nullFlavor)] appears too often [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:title) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(sdtc:statusCode[@code = 'active']) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element sdtc:statusCode[@code = 'active'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:languageCode) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:languageCode) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:setId) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:setId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:setId) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:versionNumber) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:versionNumber is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:legalAuthenticator[hl7:assignedEntity]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:legalAuthenticator[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(CDA ClinicalDocument (with nonXMLBody)): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:realmCode
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d44e8892-false-d328165e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(CDA ClinicalDocument (with nonXMLBody)): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(CDA ClinicalDocument (with nonXMLBody)): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']"
         id="d44e8918-false-d328184e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.12.1')">(CDA ClinicalDocument (with nonXMLBody)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.12.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@extension">(CDA ClinicalDocument (with nonXMLBody)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:id[not(@nullFlavor)]
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:id[not(@nullFlavor)]"
         id="d44e8948-false-d328201e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@root">(CDA ClinicalDocument (with nonXMLBody)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA ClinicalDocument (with nonXMLBody)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@extension">(CDA ClinicalDocument (with nonXMLBody)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d44e8988-false-d328225e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA ClinicalDocument (with nonXMLBody)): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.3 Codici DocGenIT (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@code">(CDA ClinicalDocument (with nonXMLBody)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA ClinicalDocument (with nonXMLBody)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(CDA ClinicalDocument (with nonXMLBody)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(CDA ClinicalDocument (with nonXMLBody)): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:translation
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.6.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.3-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]/hl7:translation"
         id="d44e9046-false-d328263e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@code">(CDA ClinicalDocument (with nonXMLBody)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA ClinicalDocument (with nonXMLBody)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@codeSystem">(CDA ClinicalDocument (with nonXMLBody)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDA ClinicalDocument (with nonXMLBody)): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:title
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/sdtc:statusCode[@code = 'active']
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/sdtc:statusCode[@code = 'active']"
         id="d44e9079-false-d328296e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@code) = ('active')">(CDA ClinicalDocument (with nonXMLBody)): The value for code SHALL be 'active'. Found: "<value-of select="@code"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:effectiveTime
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:effectiveTime"
         id="d44e9107-false-d328307e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@value">(CDA ClinicalDocument (with nonXMLBody)): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA ClinicalDocument (with nonXMLBody)): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
         id="d44e9123-false-d328321e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@nullFlavor or (@code='N') or (@code='V')">(CDA ClinicalDocument (with nonXMLBody)): The element value SHALL be one of 'code 'N' or code 'V''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@code">(CDA ClinicalDocument (with nonXMLBody)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA ClinicalDocument (with nonXMLBody)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">(CDA ClinicalDocument (with nonXMLBody)): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(CDA ClinicalDocument (with nonXMLBody)): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:languageCode
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:languageCode"
         id="d44e9180-false-d328354e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@code">(CDA ClinicalDocument (with nonXMLBody)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA ClinicalDocument (with nonXMLBody)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:setId
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:setId"
         id="d44e9196-false-d328367e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@root">(CDA ClinicalDocument (with nonXMLBody)): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA ClinicalDocument (with nonXMLBody)): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@extension">(CDA ClinicalDocument (with nonXMLBody)): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA ClinicalDocument (with nonXMLBody)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:versionNumber
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:versionNumber"
         id="d44e9259-false-d328388e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="@value">(CDA ClinicalDocument (with nonXMLBody)): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]"
         id="d328393e24-false-d328507e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTarget DocGen): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTarget DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTarget DocGen): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTarget DocGen): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d328393e56-false-d328745e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTarget DocGen): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTarget DocGen): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTarget DocGen): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTarget DocGen): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget DocGen): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d328393e66-false-d328895e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@extension">(CDA recordTarget DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTarget DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d328944e0-false-d328950e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@use">(CDA recordTarget DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d328944e0-false-d328950e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d328393e250-false-d329062e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@use">(CDA recordTarget DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTarget DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d328393e282-false-d329156e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget DocGen): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTarget DocGen): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget DocGen): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTarget DocGen): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTarget DocGen): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTarget DocGen): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTarget DocGen): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTarget DocGen): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:suffix
Item: (CDA name )
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d328393e309-false-d329369e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTarget DocGen): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@code">(CDA recordTarget DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@codeSystem">(CDA recordTarget DocGen): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d328393e380-false-d329449e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTarget DocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTarget DocGen): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTarget DocGen): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d328393e388-false-d329538e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@root">(CDA recordTarget DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTarget DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@extension">(CDA recordTarget DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTarget DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d328393e397-false-d329556e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@code">(CDA recordTarget DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="@codeSystem">(CDA recordTarget DocGen): attribute @codeSystem SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTarget DocGen)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTarget DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d329740e0-false-d329752e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTarget DocGen): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d329740e0-false-d329752e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d330070e0-false-d330076e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d330070e0-false-d330076e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d330234e0-false-d330270e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d330234e0-false-d330270e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d330440e0-false-d330444e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d330440e0-false-d330444e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d330610e0-false-d330616e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d330610e0-false-d330616e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d330774e0-false-d330810e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d330774e0-false-d330810e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d328393e441-false-d331000e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTarget DocGen): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTarget DocGen): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTarget DocGen): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTarget DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d328393e479-false-d331048e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTarget DocGen): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTarget DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTarget DocGen): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="count(hl7:addr) &lt;= 1">(CDA recordTarget DocGen): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA recordTarget DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr
Item: (CDA AddressBirthPlace)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlace): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlace): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlace): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlace): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &gt;= 1">(CDA AddressBirthPlace): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlace): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlace): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlace): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:country
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:state
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:county
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:city
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:censusTract
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.116
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr/hl7:postalCode
Item: (CDA AddressBirthPlace)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.32
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTarget DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <extends rule="d331341e0-false-d331345e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTarget DocGen): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.32-2022-07-04T102550.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTarget DocGen): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d331341e0-false-d331345e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d331511e0-false-d331517e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d331511e0-false-d331517e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d331675e0-false-d331711e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d331675e0-false-d331711e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d331881e0-false-d331885e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d331881e0-false-d331885e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d332051e0-false-d332057e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d332051e0-false-d332057e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d332215e0-false-d332251e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d332215e0-false-d332251e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]"
         id="d331331e415-false-d332491e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author DocGen): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:time) &gt;= 1">(CDA author DocGen): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:time) &lt;= 1">(CDA author DocGen): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:assignedAuthor[hl7:id]) &gt;= 1">(CDA author DocGen): element hl7:assignedAuthor[hl7:id] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:assignedAuthor[hl7:id]) &lt;= 1">(CDA author DocGen): element hl7:assignedAuthor[hl7:id] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]
Item: (CDA author DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]"
         id="d331331e441-false-d332657e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:id) &gt;= 1">(CDA author DocGen): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author DocGen): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1">(CDA author DocGen): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author DocGen): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id
Item: (CDA author DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:id"
         id="d331331e449-false-d332759e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA author DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr">
      <extends rule="d332806e0-false-d332812e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="@use">(CDA author DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d332806e0-false-d332812e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom
Item: (CDA author DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:telecom"
         id="d331331e479-false-d332924e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="@use">(CDA author DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA author DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson">
      <extends rule="d332972e0-false-d332984e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author DocGen): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d332972e0-false-d332984e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA author DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]">
      <extends rule="d333124e0-false-d333128e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@classCode) = ('DEV') or not(@classCode)">(CDA author DocGen): The value for classCode SHALL be 'DEV'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.33-2022-07-04T103342.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1" id="d333124e0-false-d333128e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:templateId) &gt;= 1">(CDA assignedAuthoringDevice ): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:code) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:manufacturerModelName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:manufacturerModelName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:softwareName) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:softwareName appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1">(CDA assignedAuthoringDevice ): element hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@root">(CDA assignedAuthoringDevice ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@extension">(CDA assignedAuthoringDevice ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA assignedAuthoringDevice ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@code">(CDA assignedAuthoringDevice ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA assignedAuthoringDevice ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="@codeSystem">(CDA assignedAuthoringDevice ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA assignedAuthoringDevice ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA assignedAuthoringDevice ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:manufacturerModelName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:softwareName
Item: (CDA assignedAuthoringDevice )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.35
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (CDA assignedAuthoringDevice )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]">
      <extends rule="d333264e0-false-d333268e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html"
              test="string(@classCode) = ('MNT') or not(@classCode)">(CDA assignedAuthoringDevice ): The value for classCode SHALL be 'MNT'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1" id="d333264e0-false-d333268e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1">(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:effectiveTime) &lt;= 1">(MaintainedEntity): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &gt;= 1">(MaintainedEntity): element hl7:maintainingPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="count(hl7:maintainingPerson) &lt;= 1">(MaintainedEntity): element hl7:maintainingPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']
Item: (MaintainedEntity)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272')">(MaintainedEntity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.272'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:effectiveTime
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.272
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (MaintainedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.33
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d333676e0-false-d333682e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d333676e0-false-d333682e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d333840e0-false-d333876e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d333840e0-false-d333876e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d334046e0-false-d334050e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d334046e0-false-d334050e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d334216e0-false-d334222e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d334216e0-false-d334222e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d334380e0-false-d334416e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d334380e0-false-d334416e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.45
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]
Item: (CDA dataEnterer DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]"
         id="d333502e402-false-d334642e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.45-2022-07-04T143745.html"
              test="string(@typeCode) = ('ENT') or not(@typeCode)">(CDA dataEnterer DocGen): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.45-2022-07-04T143745.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA dataEnterer DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.45-2022-07-04T143745.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEnterer DocGen): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.45-2022-07-04T143745.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEnterer DocGen): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.45-2022-07-04T143745.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEnterer DocGen): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.45
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time
Item: (CDA dataEnterer DocGen)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.45
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEnterer DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d335018e0-false-d335024e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d335018e0-false-d335024e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d335507e0-false-d335513e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d335507e0-false-d335513e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d335671e0-false-d335707e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d335671e0-false-d335707e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d335877e0-false-d335881e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d335877e0-false-d335881e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d336047e0-false-d336053e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d336047e0-false-d336053e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d336211e0-false-d336247e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d336211e0-false-d336247e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.47
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant
Item: (CDA Informant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant"
         id="d334783e570-false-d336498e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="string(@typeCode) = ('INF') or not(@typeCode)">(CDA Informant DocGen): The value for typeCode SHALL be 'INF'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA Informant DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity) &gt;= 1">(CDA Informant DocGen): choice (hl7:assignedEntity  or  hl7:relatedEntity) does not contain enough elements [min 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="count(hl7:assignedEntity | hl7:relatedEntity) &lt;= 1">(CDA Informant DocGen): choice (hl7:assignedEntity  or  hl7:relatedEntity) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA Informant DocGen): element hl7:assignedEntity appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.47-2022-07-04T144147.html"
              test="count(hl7:relatedEntity) &lt;= 1">(CDA Informant DocGen): element hl7:relatedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.47
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity
Item: (CDA Informant DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr">
      <extends rule="d336975e0-false-d336981e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d336975e0-false-d336981e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d337464e0-false-d337470e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d337464e0-false-d337470e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d337628e0-false-d337664e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d337628e0-false-d337664e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d337834e0-false-d337838e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d337834e0-false-d337838e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d338004e0-false-d338010e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d338004e0-false-d338010e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d338168e0-false-d338204e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d338168e0-false-d338204e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.47
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity
Item: (CDA Informant DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity
Item: (CDA RelatedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA RelatedEntity ): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="count(hl7:code) &lt;= 1">(CDA RelatedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA RelatedEntity ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="count(hl7:relatedPerson) &lt;= 1">(CDA RelatedEntity ): element hl7:relatedPerson appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:code
Item: (CDA RelatedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="@code">(CDA RelatedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA RelatedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="@codeSystem">(CDA RelatedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA RelatedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA RelatedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA RelatedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr
Item: (CDA RelatedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr">
      <extends rule="d338550e0-false-d338556e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="@use">(CDA RelatedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA RelatedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d338550e0-false-d338556e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:telecom
Item: (CDA RelatedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="@use">(CDA RelatedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.49-2022-07-04T145145.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA RelatedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:effectiveTime
Item: (CDA RelatedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.49
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson
Item: (CDA RelatedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informant/hl7:relatedEntity/hl7:relatedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.73
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]"
         id="d338410e158-false-d338859e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.73-2022-07-07T130312.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian DocGen): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.73-2022-07-07T130312.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian DocGen): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.73-2022-07-07T130312.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian DocGen): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.73
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d338925e0-false-d338929e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.73-2022-07-07T130312.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian DocGen): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian )
-->
   <rule fpi="RULC-1" id="d338925e0-false-d338929e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@root">(custodianOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@extension">(custodianOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d339133e0-false-d339139e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d339133e0-false-d339139e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]
Item: (CDA informationRecipient DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]"
         id="d338918e148-false-d339300e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="string(@typeCode) = ('PRCP') or not(@typeCode)">(CDA informationRecipient DocGen): The value for typeCode SHALL be 'PRCP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="count(hl7:intendedRecipient) &gt;= 1">(CDA informationRecipient DocGen): element hl7:intendedRecipient is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="count(hl7:intendedRecipient) &lt;= 1">(CDA informationRecipient DocGen): element hl7:intendedRecipient appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient
Item: (CDA informationRecipient DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient"
         id="d338918e186-false-d339416e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA informationRecipient DocGen): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="count(hl7:informationRecipient) &lt;= 1">(CDA informationRecipient DocGen): element hl7:informationRecipient appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="count(hl7:receivedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA informationRecipient DocGen): element hl7:receivedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id
Item: (CDA informationRecipient DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id"
         id="d338918e190-false-d339500e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="@root">(CDA informationRecipient DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA informationRecipient DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="@extension">(CDA informationRecipient DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA informationRecipient DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA informationRecipient DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr">
      <extends rule="d339551e0-false-d339557e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="@use">(CDA informationRecipient DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d339551e0-false-d339557e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom
Item: (CDA informationRecipient DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom"
         id="d338918e220-false-d339669e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="@use">(CDA informationRecipient DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.48-2022-07-04T144817.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA informationRecipient DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.48
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA informationRecipient DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d340040e0-false-d340046e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d340040e0-false-d340046e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d340204e0-false-d340240e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d340204e0-false-d340240e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d340410e0-false-d340414e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d340410e0-false-d340414e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d340580e0-false-d340586e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d340580e0-false-d340586e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d340744e0-false-d340780e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d340744e0-false-d340780e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.53
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]
Item: (CDA legalAuthenticator DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]"
         id="d339866e402-false-d341006e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator DocGen): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator DocGen): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator DocGen): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:signatureCode) &gt;= 1">(CDA legalAuthenticator DocGen): element hl7:signatureCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:signatureCode) &lt;= 1">(CDA legalAuthenticator DocGen): element hl7:signatureCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator DocGen): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.53-2022-07-04T150107.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator DocGen): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.53
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:time
Item: (CDA legalAuthenticator DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.53
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:signatureCode
Item: (CDA legalAuthenticator DocGen)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.53
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA legalAuthenticator DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d341400e0-false-d341406e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d341400e0-false-d341406e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d341889e0-false-d341895e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d341889e0-false-d341895e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d342053e0-false-d342089e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d342053e0-false-d342089e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d342259e0-false-d342263e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d342259e0-false-d342263e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d342429e0-false-d342435e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d342429e0-false-d342435e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d342593e0-false-d342629e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d342593e0-false-d342629e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:legalAuthenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.37
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]
Item: (CDA authenticator DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]"
         id="d341165e570-false-d342855e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">(CDA authenticator DocGen): The value for typeCode SHALL be 'AUTHEN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:time) &gt;= 1">(CDA authenticator DocGen): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:time) &lt;= 1">(CDA authenticator DocGen): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:signatureCode) &gt;= 1">(CDA authenticator DocGen): element hl7:signatureCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:signatureCode) &lt;= 1">(CDA authenticator DocGen): element hl7:signatureCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA authenticator DocGen): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.37-2022-07-04T105308.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA authenticator DocGen): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.37
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:time
Item: (CDA authenticator DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.37
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:signatureCode
Item: (CDA authenticator DocGen)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.37
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA authenticator DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d343245e0-false-d343251e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d343245e0-false-d343251e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d343734e0-false-d343740e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d343734e0-false-d343740e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d343898e0-false-d343934e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d343898e0-false-d343934e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d344104e0-false-d344108e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d344104e0-false-d344108e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d344274e0-false-d344280e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d344274e0-false-d344280e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d344438e0-false-d344474e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d344438e0-false-d344474e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:authenticator[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d343010e570-false-d344699e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@typeCode">(CDA participant DocGen): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant DocGen): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA participant DocGen): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA participant DocGen): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:time) &lt;= 1">(CDA participant DocGen): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(CDA participant DocGen): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(CDA participant DocGen): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d343010e637-false-d344800e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA participant DocGen): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@code">(CDA participant DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDA participant DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d343010e678-false-d344887e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@classCode">(CDA participant DocGen): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant DocGen): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:id) &gt;= 1">(CDA participant DocGen): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:code) &lt;= 1">(CDA participant DocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="count(hl7:associatedPerson) &lt;= 1">(CDA participant DocGen): element hl7:associatedPerson appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d343010e685-false-d344987e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@root">(CDA participant DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@extension">(CDA participant DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA participant DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA participant DocGen): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
         id="d343010e699-false-d345008e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@code">(CDA participant DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@codeSystem">(CDA participant DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA participant DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr">
      <extends rule="d345065e0-false-d345071e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@use">(CDA participant DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d345065e0-false-d345071e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (CDA participant DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
         id="d343010e720-false-d345183e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="@use">(CDA participant DocGen): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.57-2022-07-04T151143.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant DocGen): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA participant DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.57
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA participant DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d345554e0-false-d345560e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d345554e0-false-d345560e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d345718e0-false-d345754e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d345718e0-false-d345754e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d345924e0-false-d345928e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d345924e0-false-d345928e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d346094e0-false-d346100e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d346094e0-false-d346100e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d346258e0-false-d346294e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d346258e0-false-d346294e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]
Item: (CDA inFulfillmentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]"
         id="d345380e402-false-d346471e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf DocGen): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="count(hl7:order) &gt;= 1">(CDA inFulfillmentOf DocGen): element hl7:order is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="count(hl7:order) &lt;= 1">(CDA inFulfillmentOf DocGen): element hl7:order appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order
Item: (CDA inFulfillmentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
         id="d345380e425-false-d346491e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf DocGen): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(CDA inFulfillmentOf DocGen): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf DocGen): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf DocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA inFulfillmentOf DocGen): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id
Item: (CDA inFulfillmentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
         id="d345380e482-false-d346528e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@root">(CDA inFulfillmentOf DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@extension">(CDA inFulfillmentOf DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code
Item: (CDA inFulfillmentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code"
         id="d345380e503-false-d346549e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@code">(CDA inFulfillmentOf DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA inFulfillmentOf DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@codeSystem">(CDA inFulfillmentOf DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.51
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA inFulfillmentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d345380e516-false-d346576e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA inFulfillmentOf DocGen): The element value SHALL be one of '2.16.840.1.113883.1.11.16866 ActPriority (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@code">(CDA inFulfillmentOf DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA inFulfillmentOf DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="@codeSystem">(CDA inFulfillmentOf DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.51-2022-07-04T145624.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA inFulfillmentOf DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocument DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d346582e46-false-d346610e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@typeCode">(CDA relatedDocument DocGen): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocument DocGen): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocument DocGen): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocument DocGen): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocument DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d346582e97-false-d346641e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocument DocGen): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocument DocGen): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocument DocGen): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(CDA relatedDocument DocGen): element hl7:code[@codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocument DocGen): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocument DocGen): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocument DocGen): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocument DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d346582e103-false-d346688e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@root">(CDA relatedDocument DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@extension">(CDA relatedDocument DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocument DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA relatedDocument DocGen): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']
Item: (CDA relatedDocument DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code[@codeSystem = '2.16.840.1.113883.6.1']"
         id="d346582e123-false-d346710e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(CDA relatedDocument DocGen): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@code">(CDA relatedDocument DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocument DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="@codeSystem">(CDA relatedDocument DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocument DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocument DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.50-2022-07-04T145610.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocument DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocument DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocument DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.50
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocument DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d346757e22-false-d346857e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf DocGen): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:encompassingEncounter) &gt;= 1">(CDA componentOf DocGen): element hl7:encompassingEncounter is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:encompassingEncounter) &lt;= 1">(CDA componentOf DocGen): element hl7:encompassingEncounter appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter"
         id="d346757e32-false-d347063e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf DocGen): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf DocGen): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf DocGen): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf DocGen): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf DocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:responsibleParty) &lt;= 1">(CDA componentOf DocGen): element hl7:responsibleParty appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf DocGen): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id"
         id="d346757e38-false-d347205e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@root">(CDA componentOf DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@extension">(CDA componentOf DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf DocGen): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d346757e58-false-d347229e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf DocGen): The element value SHALL be one of '2.16.840.1.113883.3.1937.777.63.11.1 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@code">(CDA componentOf DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@codeSystem">(CDA componentOf DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:effectiveTime
Item: (CDA componentOf DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty"
         id="d346757e125-false-d347319e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf DocGen): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf DocGen): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA componentOf DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr">
      <extends rule="d347675e0-false-d347681e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d347675e0-false-d347681e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d348164e0-false-d348170e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d348164e0-false-d348170e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d348328e0-false-d348364e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d348328e0-false-d348364e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d348534e0-false-d348538e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d348534e0-false-d348538e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d348704e0-false-d348710e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d348704e0-false-d348710e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d348868e0-false-d348904e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d348868e0-false-d348904e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]"
         id="d346757e149-false-d349124e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf DocGen): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:healthCareFacility) &gt;= 1">(CDA componentOf DocGen): element hl7:healthCareFacility is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:healthCareFacility) &lt;= 1">(CDA componentOf DocGen): element hl7:healthCareFacility appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility"
         id="d346757e192-false-d349232e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf DocGen): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA componentOf DocGen): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf DocGen): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG']) &lt;= 1">(CDA componentOf DocGen): element hl7:serviceProviderOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:id"
         id="d346757e216-false-d349313e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@root">(CDA componentOf DocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf DocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@extension">(CDA componentOf DocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf DocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf DocGen): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA componentOf DocGen)
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d346757e230-false-d349337e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf DocGen): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@code">(CDA componentOf DocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf DocGen): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="@codeSystem">(CDA componentOf DocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf DocGen): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf DocGen): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf DocGen): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA componentOf DocGen)
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location">
      <extends rule="d349400e0-false-d349415e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf DocGen): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.40-2022-07-04T135450.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf DocGen): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location
Item: (CDA place )
-->
   <rule fpi="RULC-1" id="d349400e0-false-d349415e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:name) &lt;= 1">(CDA place ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:addr) &lt;= 1">(CDA place ): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:templateId
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:name
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA place )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr">
      <extends rule="d349497e0-false-d349503e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="@use">(CDA place ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d349497e0-false-d349503e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.40
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA componentOf DocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d349822e0-false-d349828e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d349822e0-false-d349828e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d349986e0-false-d350022e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d349986e0-false-d350022e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d350192e0-false-d350196e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d350192e0-false-d350196e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d350362e0-false-d350368e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d350362e0-false-d350368e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d350526e0-false-d350562e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d350526e0-false-d350562e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility/hl7:serviceProviderOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]"
         id="d44e9314-false-d350738e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@typeCode) = ('COMP')">(CDA ClinicalDocument (with nonXMLBody)): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@contextConductionInd) = ('true')">(CDA ClinicalDocument (with nonXMLBody)): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']"
         id="d44e9320-false-d350762e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@classCode) = ('DOCBODY')">(CDA ClinicalDocument (with nonXMLBody)): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@moodCode) = ('EVN')">(CDA ClinicalDocument (with nonXMLBody)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:text) &gt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="count(hl7:text) &lt;= 1">(CDA ClinicalDocument (with nonXMLBody)): element hl7:text appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.12.1
Context: /hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:text
Item: (CDA ClinicalDocument (with nonXMLBody))
-->

   <rule fpi="RULC-1"
         context="/hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.12.1']]/hl7:component[@contextConductionInd = 'true'][@typeCode = 'COMP'][hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']]/hl7:nonXMLBody[@classCode = 'DOCBODY'][@moodCode = 'EVN']/hl7:text"
         id="d44e9334-false-d350786e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@mediaType) = ('pdf')">(CDA ClinicalDocument (with nonXMLBody)): The value for mediaType SHALL be 'pdf'. Found: "<value-of select="@mediaType"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.12.1-2022-07-04T101757.html"
              test="string(@representation) = ('B64')">(CDA ClinicalDocument (with nonXMLBody)): The value for representation SHALL be 'B64'. Found: "<value-of select="@representation"/>"</assert>
   </rule>
</pattern>
