<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Name: Laboratory Report Item Section
Description: At the second level (nested in one specialty section), each leaf section represents a Report Item. It can be a battery (or test panel), an individual test, or the complete study of a specimen (particularly in the MICROBIOLOGY STUDIES specialty). A Laboratory Report Item Section under a Laboratory Specialty Section SHALL represent only one Report Item. 
                     <templateId root="1.3.6.1.4.1.19376.1.3.3.2.2"/> - The templateId element identifies this section as a Laboratory Report Item Section under a Laboratory Specialty Section. The templateId SHALL be present with root="1.3.6.1.4.1.19376.1.3.3.2.2". 
                     <code code=" " codeSystem=" " codeSystemName=" " displayName=" "/> - The Laboratory Report Item Section SHALL identify the single Report Item uniquely using the <code> element. For example, a LOINC test code. The code, codeSystem, and displayName SHALL be present. One MAY also populate codeSystemName and orginalText. 
                     <title/> - The L
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000">
   <title>Laboratory Report Item Section</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]
Item: (Laboratory Report Item Section)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]
Item: (Laboratory Report Item Section)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]"
         id="d44e3899-false-d13138e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']) &gt;= 1">(Laboratory Report Item Section): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']) &lt;= 1">(Laboratory Report Item Section): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:id) &lt;= 1">(Laboratory Report Item Section): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(Laboratory Report Item Section): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(Laboratory Report Item Section): element hl7:code[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:title) &lt;= 1">(Laboratory Report Item Section): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Laboratory Report Item Section): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Laboratory Report Item Section): element hl7:text[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &gt;= 1">(Laboratory Report Item Section): element hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="count(hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]) &lt;= 1">(Laboratory Report Item Section): element hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']
Item: (Laboratory Report Item Section)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']"
         id="d44e3901-false-d13321e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.2.2')">(Laboratory Report Item Section): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.2.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:id
Item: (Laboratory Report Item Section)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:code[not(@nullFlavor)]
Item: (Laboratory Report Item Section)
-->

   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:code[not(@nullFlavor)]"
         id="d44e3908-false-d13340e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="@code">(Laboratory Report Item Section): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="@codeSystem">(Laboratory Report Item Section): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="@displayName">(Laboratory Report Item Section): attribute @displayName SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:title
Item: (Laboratory Report Item Section)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:text[not(@nullFlavor)]
Item: (Laboratory Report Item Section)
-->


   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.2.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]
Item: (Laboratory Report Item Section)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]">
      <extends rule="d13513e0-false-d13517e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.2.2-2008-08-08T000000.html"
              test="string(@typeCode) = ('DRIV')">(Laboratory Report Item Section): The value for typeCode SHALL be 'DRIV'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1" id="d13513e0-false-d13517e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']) &gt;= 1">(Laboratory Report Data Processing Entry): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]) &gt;= 1">(Laboratory Report Data Processing Entry): element hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1')">(Laboratory Report Data Processing Entry): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@classCode) = ('ACT')">(Laboratory Report Data Processing Entry): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Laboratory Report Data Processing Entry): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="hl7:entryRelationship">(Laboratory Report Data Processing Entry): A Laboratory Result Content SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(Laboratory Report Data Processing Entry): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:code[not(@nullFlavor)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']) &gt;= 1">(Laboratory Report Data Processing Entry): element hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']] | hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]) &lt;= 1">(Laboratory Report Data Processing Entry): choice (hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']]  or  hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]) contains too many elements [max 1x]</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']]) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="count(hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]) &lt;= 1">(Laboratory Report Data Processing Entry): element hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:code[not(@nullFlavor)]
Item: (Laboratory Report Data Processing Entry)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="@nullFlavor or (@code='completed') or (@code='active') or (@code='aborted')">(Laboratory Report Data Processing Entry): The element value SHALL be one of 'code 'completed' or code 'active' or code 'aborted''.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2.1']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'SBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:subject[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('SBJ') or not(@typeCode)">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'SBJ'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:performer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:performer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('PRF') or not(@typeCode)">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'PRF'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:author
Item: (Laboratory Report Data Processing Entry)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:participant[@typeCode='AUTHEN']
Item: (Laboratory Report Data Processing Entry)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:participant[@typeCode='RESP']
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:participant[@typeCode='RESP']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('RESP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:participant[@typeCode='DEV']
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:participant[@typeCode='DEV']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('DEV')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'DEV'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.4']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.4']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.5']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.5']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.6']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.6']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.10.20.1.40'] and hl7:templateId[@root = '1.3.6.1.4.1.19376.1.5.3.1.4.2']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.1']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.1']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]
Item: (Laboratory Report Data Processing Entry)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Laboratory Report Data Processing Entry): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]
Item: (Multimedia Embedded Content)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]/hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN'][hl7:value]
Item: (Multimedia Embedded Content)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]/hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN'][hl7:value]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="string(@classCode) = ('OBS')">(Multimedia Embedded Content): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Multimedia Embedded Content): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &gt;= 1">(Multimedia Embedded Content): element hl7:value[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="count(hl7:value[not(@nullFlavor)]) &lt;= 1">(Multimedia Embedded Content): element hl7:value[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.2
Context: *[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]/hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN'][hl7:value]/hl7:value[not(@nullFlavor)]
Item: (Multimedia Embedded Content)
-->
   <rule fpi="RULC-1"
         context="*[hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]]/hl7:section[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.2.2']]/hl7:entry[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1']]/hl7:act[hl7:statusCode[@code = 'completed' or @code = 'active' or @code = 'aborted']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN']]/hl7:observationMedia[@classCode = 'OBS'][@moodCode = 'EVN'][hl7:value]/hl7:value[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="@mediaType">(Multimedia Embedded Content): attribute @mediaType SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@mediaType),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="not(@mediaType) or empty($theAttValue[not(. = (('image/gif','image/jpeg','image/png','image/bmp')))])">(Multimedia Embedded Content): The value for mediaType SHALL be 'code image/gif or code image/jpeg or code image/png or code image/bmp'. Found: "<value-of select="@mediaType"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.2-2008-08-08T000000.html"
              test="string(@representation) = ('B64')">(Multimedia Embedded Content): The value for representation SHALL be 'B64'. Found: "<value-of select="@representation"/>"</assert>
   </rule>
</pattern>
