<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Name: Laboratory Performer
Description: Laboratory Performers SHALL be recorded as performers in the CDA Header as well as in the structured body as demonstrated in the figure below. Documentation of laboratory performers MAY be done in multiple levels of the document to reflect performance scope. In the case where there is a single Laboratory Performer, this entity SHALL be documented in CDA header as
                shown. In the case where multiple Laboratory Performers participated in the lab testing process, they SHALL be documented in the structuredBody at the observation level.  These performers SHALL conform to the General Constraints found in HL7 CRS: 2.1.1 with respect to the requirements for name, address, telephone numbers and other contact information. 
                  This module is out of the XDS-Lab Specification and documented there in a <performer> element. This module does not change requirements stated in that specification but is structured as a module to ensure consistent content representation and re
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000">
   <title>Laboratory Performer</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]
Item: (Laboratory Performer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]"
         id="d44e3480-false-d9866e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']) &gt;= 1">(Laboratory Performer): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']) &lt;= 1">(Laboratory Performer): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:time) &gt;= 1">(Laboratory Performer): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:time) &lt;= 1">(Laboratory Performer): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(Laboratory Performer): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(Laboratory Performer): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']
Item: (Laboratory Performer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']"
         id="d44e3667-false-d9899e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.7')">(Laboratory Performer): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.7'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:time
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity
Item: (Laboratory Performer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity"
         id="d44e3678-false-d9918e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Laboratory Performer): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="hl7:assignedPerson/hl7:name or hl7:representedOrganization/hl7:name">(Laboratory Performer): Either an &lt;assignedPerson&gt; or a &lt;representedOrganization&gt; SHALL be present. In either case, the &lt;name&gt; sub-element SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:id) &gt;= 1">(Laboratory Performer): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:code) &lt;= 1">(Laboratory Performer): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:addr) &gt;= 1">(Laboratory Performer): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:telecom) &gt;= 1">(Laboratory Performer): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Laboratory Performer): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.7-2008-08-08T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(Laboratory Performer): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:id
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:code
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:addr
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:telecom
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:assignedPerson
Item: (Laboratory Performer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.7
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.7']]/hl7:assignedEntity/hl7:representedOrganization
Item: (Laboratory Performer)
-->
</pattern>
