<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Name: Laboratory Results Validator
Description: The ClinicalDocument/authenticator element MAY be present. When present it represents the clinical expert who performed the clinical validation (see the entries “validator” and “clinical expert” in the glossary in LAB TF-1:1.11) of the report or of a subset of its results, also called the validator. This element SHALL be in accordance with the HL7 CDA R2 standard
                and further constrained by this specification to require the presence of name, addr and telecom.   There MAY be more than one validator of the report. All the validators SHALL appear in the report header as authenticator elements AND, in the case of multiple validators, each individuavalidator SHALL be associated with the particular sections of the report he or she
                validatedcase, the validator of a section SHALL also appear in the validator SHALL appear as a participant with typeCode="AUTHEN". Additionally, the laboratory results validator SHALL have the following: 
                     <templat
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000">
   <title>Laboratory Results Validator</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]
Item: (Laboratory Results Validator)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]"
         id="d44e3219-false-d9695e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']) &gt;= 1">(Laboratory Results Validator): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']) &lt;= 1">(Laboratory Results Validator): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:time) &gt;= 1">(Laboratory Results Validator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:time) &lt;= 1">(Laboratory Results Validator): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:signatureCode) &gt;= 1">(Laboratory Results Validator): element hl7:signatureCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:signatureCode) &lt;= 1">(Laboratory Results Validator): element hl7:signatureCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:assignedEntity) &gt;= 1">(Laboratory Results Validator): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:assignedEntity) &lt;= 1">(Laboratory Results Validator): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']
Item: (Laboratory Results Validator)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']"
         id="d44e3449-false-d9736e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.5')">(Laboratory Results Validator): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.5'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:time
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:signatureCode
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity
Item: (Laboratory Results Validator)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity"
         id="d44e3458-false-d9763e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(Laboratory Results Validator): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="not(hl7:assignedPerson) or hl7:assignedPerson/hl7:name">(Laboratory Results Validator): the &lt;name&gt; sub-element of &lt;assignedPerson&gt; SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:id) &gt;= 1">(Laboratory Results Validator): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:code) &lt;= 1">(Laboratory Results Validator): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:addr) &gt;= 1">(Laboratory Results Validator): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:telecom) &gt;= 1">(Laboratory Results Validator): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:assignedPerson) &lt;= 1">(Laboratory Results Validator): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.5-2008-08-08T000000.html"
              test="count(hl7:representedOrganization) &lt;= 1">(Laboratory Results Validator): element hl7:representedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:id
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:code
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:addr
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:telecom
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:assignedPerson
Item: (Laboratory Results Validator)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.5
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.5']]/hl7:assignedEntity/hl7:representedOrganization
Item: (Laboratory Results Validator)
-->
</pattern>
