<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Name: XD-LAB Information Recipient
Description: ClinicalDocument/informationRecipient MAY be present. When present, it SHALL be in accordance with the HL7 CDA R2 standard and further constrained by this specification to require the presence of name (on the informationRecipient and/or receivedOrganization), addr and telecom. Additionally, it SHALL have the following:  
                     <templateId root="1.3.6.1.4.1.19376.1.3.3.1.4"/> - The templateId element identifies this participant as an intended recipient. The templateId SHALL have root="1.3.6.1.4.1.19376.1.3.3.1.4". 
                  The informationRecipient/intendedRecipient element can be multiple. It introduces an intended recipient of the laboratory report, other than the Ordering Provider (described as a referrer participant). These elements carry the list of the originally intended recipients of the laboratory report, i.e. those who were known at the time the report was created and published for
                sharing. 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000">
   <title>XD-LAB Information Recipient</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]
Item: (XD-LAB Information Recipient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]
Item: (XD-LAB Information Recipient)
-->

   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]"
         id="d44e3197-false-d9383e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']) &gt;= 1">(XD-LAB Information Recipient): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']) &lt;= 1">(XD-LAB Information Recipient): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:intendedRecipient) &gt;= 1">(XD-LAB Information Recipient): element hl7:intendedRecipient is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:intendedRecipient) &lt;= 1">(XD-LAB Information Recipient): element hl7:intendedRecipient appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']
Item: (XD-LAB Information Recipient)
-->

   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']"
         id="d44e3199-false-d9418e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.4')">(XD-LAB Information Recipient): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.4'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient
Item: (XD-LAB Information Recipient)
-->

   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient"
         id="d44e3204-false-d9438e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:addr) &gt;= 1">(XD-LAB Information Recipient): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:telecom) &gt;= 1">(XD-LAB Information Recipient): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:informationRecipient) &lt;= 1">(XD-LAB Information Recipient): element hl7:informationRecipient appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.4-2008-08-08T000000.html"
              test="count(hl7:receivedOrganization) &lt;= 1">(XD-LAB Information Recipient): element hl7:receivedOrganization appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:id
Item: (XD-LAB Information Recipient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:addr
Item: (XD-LAB Information Recipient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:telecom
Item: (XD-LAB Information Recipient)
-->


   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:informationRecipient
Item: (XD-LAB Information Recipient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.18
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:informationRecipient
Item: (PlayingEntity or person with Name)
-->
   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:informationRecipient">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.18-2016-07-05T000000.html"
              test="count(hl7:name) &gt;= 1">(PlayingEntity or person with Name): element hl7:name is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.18
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (PlayingEntity or person with Name)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.4
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization
Item: (XD-LAB Information Recipient)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization
Item: (Organization with Name, Addr, Telecom)
-->
   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:name) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:telecom) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:addr) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(Organization with Name, Addr, Telecom): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:name
Item: (Organization with Name, Addr, Telecom)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:telecom
Item: (Organization with Name, Addr, Telecom)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:addr
Item: (Organization with Name, Addr, Telecom)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf
Item: (Organization with Name, Addr, Telecom)
-->
   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:wholeOrganization) &lt;= 1">(Organization with Name, Addr, Telecom): element hl7:wholeOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization
Item: (Organization with Name, Addr, Telecom)
-->
   <rule fpi="RULC-1"
         context="*[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:name) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:telecom) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.10.9.13-2016-07-05T000000.html"
              test="count(hl7:addr) &gt;= 1">(Organization with Name, Addr, Telecom): element hl7:addr is required [min 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:name
Item: (Organization with Name, Addr, Telecom)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:telecom
Item: (Organization with Name, Addr, Telecom)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.10.9.13
Context: *[hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]]/hl7:informationRecipient[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.4']]/hl7:intendedRecipient/hl7:receivedOrganization/hl7:asOrganizationPartOf/hl7:wholeOrganization/hl7:addr
Item: (Organization with Name, Addr, Telecom)
--></pattern>
