<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Name: Human Patient with Non-Human Subject
Description: When the subject of the observations in this part of the report is a sample taken from a non-human subject, such as an animal, a lake, soil or other environmental element, while other parts of the report are related to the human patient, the following SHALL be present. In addition to the elements specified in the CDA body for the non-human subject, this non-human
                subject SHALL be represented in the CDA header as described in template Non-Human Subject 1.3.6.1.4.1.19376.1.3.3.1.2
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000">
   <title>Human Patient with Non-Human Subject</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]"
         id="d44e3040-false-d9263e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:relatedSubject) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:relatedSubject is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:relatedSubject) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:relatedSubject appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']"
         id="d44e3091-false-d9288e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.3.1')">(Human Patient with Non-Human Subject): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.3.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:relatedSubject
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:relatedSubject"
         id="d44e3096-false-d9299e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:code) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:code) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:addr) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3.1-2009-12-04T000000.html"
              test="count(hl7:addr) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:relatedSubject/hl7:code
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3.1
Context: *[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3.1']]/hl7:relatedSubject/hl7:addr
Item: (Human Patient with Non-Human Subject)
-->
</pattern>
