<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Name: Human Patient with Non-Human Subject
Description: ClinicalDocument/recordTarget SHALL be present and SHALL conform to the Human Patient, Non-Human Subject or Human Patient with Non-Human Subject templates defined below. There are three varieties of laboratory reports:  
                     Human (patient): The document reports laboratory observations produced on specimens collected exclusively from the patient. 
                     Non-Human Subject: The document reports laboratory observations produced on specimens collected from a non-human material (e.g. water, milk…) or living subject (e.g. animal). 
                     Human (patient) paired with Non-Human Subject: The document reports laboratory observations produced on a non-human specimen with a relationship to a human patient, (e.g. peanut butter eaten by a patient, a ferret that bit a patient). 
                 
                 Human Patient with Non-Human Subject  When the report assembles observations for a human (patient) with observations produced using a non-human 
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000">
   <title>Human Patient with Non-Human Subject</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]"
         id="d44e2917-false-d9080e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]"
         id="d44e3011-false-d9095e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']"
         id="d44e3013-false-d9121e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.3')">(Human Patient with Non-Human Subject): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]"
         id="d44e3018-false-d9132e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:id) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:addr) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:telecom) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:telecom is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:patient) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:patient is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:patient) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:patient appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:id
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient
Item: (Human Patient with Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient"
         id="d44e3026-false-d9190e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:id) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:name) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:administrativeGenderCode) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:administrativeGenderCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:administrativeGenderCode) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:administrativeGenderCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:birthTime) &gt;= 1">(Human Patient with Non-Human Subject): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.3-2008-08-08T000000.html"
              test="count(hl7:birthTime) &lt;= 1">(Human Patient with Non-Human Subject): element hl7:birthTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient/hl7:id
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient/hl7:name
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient/hl7:administrativeGenderCode
Item: (Human Patient with Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.3
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.3']]/hl7:patientRole[hl7:patient]/hl7:patient/hl7:birthTime
Item: (Human Patient with Non-Human Subject)
-->
</pattern>
