<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Name: Non-Human Subject
Description: ClinicalDocument/recordTarget SHALL be present and SHALL conform to the Human Patient, Non-Human Subject or Human Patient with Non-Human Subject templates defined below. There are three varieties of laboratory reports:  
                     Human (patient): The document reports laboratory observations produced on specimens collected exclusively from the patient. 
                     Non-Human Subject: The document reports laboratory observations produced on specimens collected from a non-human material (e.g. water, milk…) or living subject (e.g. animal). 
                     Human (patient) paired with Non-Human Subject: The document reports laboratory observations produced on a non-human specimen with a relationship to a human patient, (e.g. peanut butter eaten by a patient, a ferret that bit a patient). 
                 
                 Non-Human Subject  When the subject of the observations in the report is a sample exclusively taken from a non-human subject, such as an animal,
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000">
   <title>Non-Human Subject</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]
Item: (Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]"
         id="d44e2759-false-d8881e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]) &gt;= 1">(Non-Human Subject): element hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']] is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]
Item: (Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]"
         id="d44e2816-false-d8896e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(Non-Human Subject): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(Non-Human Subject): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']) &gt;= 1">(Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']) &lt;= 1">(Non-Human Subject): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]) &gt;= 1">(Non-Human Subject): element hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]) &lt;= 1">(Non-Human Subject): element hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']
Item: (Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']"
         id="d44e2822-false-d8930e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.3.1.2')">(Non-Human Subject): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.3.1.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]
Item: (Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]"
         id="d44e2827-false-d8941e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(Non-Human Subject): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:id) &gt;= 1">(Non-Human Subject): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:patient[@nullFlavor = 'OTH']) &gt;= 1">(Non-Human Subject): element hl7:patient[@nullFlavor = 'OTH'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="count(hl7:patient[@nullFlavor = 'OTH']) &lt;= 1">(Non-Human Subject): element hl7:patient[@nullFlavor = 'OTH'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]/hl7:id
Item: (Non-Human Subject)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.3.1.2
Context: *[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]/hl7:patient[@nullFlavor = 'OTH']
Item: (Non-Human Subject)
-->

   <rule fpi="RULC-1"
         context="*[hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]]/hl7:recordTarget[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.3.1.2']]/hl7:patientRole[hl7:patient[@nullFlavor = 'OTH']]/hl7:patient[@nullFlavor = 'OTH']"
         id="d44e2833-false-d8975e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(Non-Human Subject): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(Non-Human Subject): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.3.1.2-2008-08-08T000000.html"
              test="string(@nullFlavor) = ('OTH')">(Non-Human Subject): The value for nullFlavor SHALL be 'OTH'. Found: "<value-of select="@nullFlavor"/>"</assert>
   </rule>
</pattern>
