<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.1.2
Name: Specimen Collection
Description: Specimen Collection, when present, SHALL be recorded under the Specimen Act in an entryRelationship under the Laboratory Data Processing Entry. The table below shows how the information for this element is coded, and further constraints are provided in the following sections.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000">
   <title>Specimen Collection</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]
Item: (Specimen Collection)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]"
         id="d44e764-false-d4656e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@classCode) = ('PROC')">(Specimen Collection): The value for classCode SHALL be 'PROC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Specimen Collection): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']) &gt;= 1">(Specimen Collection): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']) &lt;= 1">(Specimen Collection): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:code[@code = '33882-2' or @nullFlavor]) &lt;= 1">(Specimen Collection): element hl7:code[@code = '33882-2' or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Specimen Collection): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Specimen Collection): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:targetSiteCode) &lt;= 1">(Specimen Collection): element hl7:targetSiteCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:performer) &lt;= 1">(Specimen Collection): element hl7:performer appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:participant[@typeCode = 'PRD'][hl7:participantRole]) &gt;= 1">(Specimen Collection): element hl7:participant[@typeCode = 'PRD'][hl7:participantRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:participant[@typeCode = 'PRD'][hl7:participantRole]) &lt;= 1">(Specimen Collection): element hl7:participant[@typeCode = 'PRD'][hl7:participantRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]) &lt;= 1">(Specimen Collection): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']"
         id="d44e770-false-d4727e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1.2')">(Specimen Collection): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.1.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:code[@code = '33882-2' or @nullFlavor]
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:code[@code = '33882-2' or @nullFlavor]"
         id="d44e775-false-d4739e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="@nullFlavor or (@code='33882-2')">(Specimen Collection): The element value SHALL be one of 'code '33882-2''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:effectiveTime
Item: (Specimen Collection)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:targetSiteCode
Item: (Specimen Collection)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:performer
Item: (Specimen Collection)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]"
         id="d44e794-false-d4776e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@typeCode) = ('PRD')">(Specimen Collection): The value for typeCode SHALL be 'PRD'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]) &gt;= 1">(Specimen Collection): element hl7:participantRole[not(@nullFlavor)][hl7:playingEntity] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]) &lt;= 1">(Specimen Collection): element hl7:participantRole[not(@nullFlavor)][hl7:playingEntity] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]"
         id="d44e801-false-d4796e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@classCode) = ('SPEC') or not(@classCode)">(Specimen Collection): The value for classCode SHALL be 'SPEC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:id) &gt;= 1">(Specimen Collection): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:id) &lt;= 1">(Specimen Collection): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:playingEntity[hl7:code]) &gt;= 1">(Specimen Collection): element hl7:playingEntity[hl7:code] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:playingEntity[hl7:code]) &lt;= 1">(Specimen Collection): element hl7:playingEntity[hl7:code] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]/hl7:id
Item: (Specimen Collection)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]/hl7:playingEntity[hl7:code]
Item: (Specimen Collection)
-->

   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]/hl7:playingEntity[hl7:code]"
         id="d44e807-false-d4832e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:code) &gt;= 1">(Specimen Collection): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="count(hl7:code) &lt;= 1">(Specimen Collection): element hl7:code appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:participant[@typeCode = 'PRD'][hl7:participantRole]/hl7:participantRole[not(@nullFlavor)][hl7:playingEntity]/hl7:playingEntity[hl7:code]/hl7:code
Item: (Specimen Collection)
-->


   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.2
Context: *[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]
Item: (Specimen Collection)
-->
   <rule fpi="RULC-1"
         context="*[hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]]/hl7:procedure[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.2']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.3']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.2-2008-08-08T000000.html"
              test="string(@typeCode) = ('COMP')">(Specimen Collection): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>
</pattern>
