<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Name: Outbreak Identification
Description: Outbreak Identification, when present, SHALL be recorded as an observation under the Notification Organizer as demonstrated. Outbreak Identification SHALL be present when dictated by local outbreak identification reporting requirements.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000">
   <title>Outbreak Identification</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]
Item: (Outbreak Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]
Item: (Outbreak Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]"
         id="d44e612-false-d4506e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="string(@classCode) = ('OUTB')">(Outbreak Identification): The value for classCode SHALL be 'OUTB'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Outbreak Identification): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']) &gt;= 1">(Outbreak Identification): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']) &lt;= 1">(Outbreak Identification): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:code) &gt;= 1">(Outbreak Identification): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:code) &lt;= 1">(Outbreak Identification): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &gt;= 1">(Outbreak Identification): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &lt;= 1">(Outbreak Identification): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Outbreak Identification): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:value) &gt;= 1">(Outbreak Identification): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="count(hl7:value) &lt;= 1">(Outbreak Identification): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']
Item: (Outbreak Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']"
         id="d44e618-false-d4567e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1.1.3')">(Outbreak Identification): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.1.1.3'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:id
Item: (Outbreak Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:code
Item: (Outbreak Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:statusCode[@code = 'completed' or @code = 'aborted']
Item: (Outbreak Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:statusCode[@code = 'completed' or @code = 'aborted']"
         id="d44e636-false-d4595e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.3-2008-08-08T000000.html"
              test="@nullFlavor or (@code='completed') or (@code='aborted')">(Outbreak Identification): The element value SHALL be one of 'code 'completed' or code 'aborted''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:effectiveTime
Item: (Outbreak Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.3
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]/hl7:value
Item: (Outbreak Identification)
-->
</pattern>
