<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Name: Case Identification
Description: Case Identification, when present, SHALL be recorded as an observation under the Notification Organizer as demonstrated. Case Identification SHALL be present when dictated by local case identification reporting requirements.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000">
   <title>Case Identification</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]
Item: (Case Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]
Item: (Case Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]"
         id="d44e533-false-d4368e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="string(@classCode) = ('CASE')">(Case Identification): The value for classCode SHALL be 'CASE'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Case Identification): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']) &gt;= 1">(Case Identification): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']) &lt;= 1">(Case Identification): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:code) &gt;= 1">(Case Identification): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:code) &lt;= 1">(Case Identification): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &gt;= 1">(Case Identification): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'aborted']) &lt;= 1">(Case Identification): element hl7:statusCode[@code = 'completed' or @code = 'aborted'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Case Identification): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:value) &gt;= 1">(Case Identification): element hl7:value is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="count(hl7:value) &lt;= 1">(Case Identification): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']
Item: (Case Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']"
         id="d44e539-false-d4429e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1.1.2')">(Case Identification): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.1.1.2'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:id
Item: (Case Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:code
Item: (Case Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:statusCode[@code = 'completed' or @code = 'aborted']
Item: (Case Identification)
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:statusCode[@code = 'completed' or @code = 'aborted']"
         id="d44e557-false-d4457e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1.2-2008-08-08T000000.html"
              test="@nullFlavor or (@code='completed') or (@code='aborted')">(Case Identification): The element value SHALL be one of 'code 'completed' or code 'aborted''.</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:effectiveTime
Item: (Case Identification)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1.2
Context: *[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]/hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]/hl7:value
Item: (Case Identification)
-->
</pattern>
