<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 1.3.6.1.4.1.19376.1.3.1.1
Name: Notification Organizer
Description: The document MAY contain a Notification Organizer in an <entryRelationship> under the Specimen Act of a Laboratory Data Processing Entry as demonstrated in the figure below. This <organizer> SHALL be present when any of the following Notifications are present:  
                     Notifiable Condition 1.3.6.1.4.1.19376.1.3.1.1.1 
                     Case Identification 1.3.6.1.4.1.19376.1.3.1.1.2 and/or 
                     Outbreak Identification 1.3.6.1.4.1.19376.1.3.1.1.3 
                 Notifications SHALL be present when dictated by local public health requirements.
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000">
   <title>Notification Organizer</title>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]
Item: (Notification Organizer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]
Item: (Notification Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]"
         id="d44e375-false-d4034e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="string(@classCode) = ('CLUSTER')">(Notification Organizer): The value for classCode SHALL be 'CLUSTER'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="string(@moodCode) = ('EVN')">(Notification Organizer): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="hl7:component">(Notification Organizer): Notification Organizer SHALL contain one or more of the following Notifications: Notifiable Condition, Case Identification, Outbreak Identification</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']) &gt;= 1">(Notification Organizer): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="count(hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']) &lt;= 1">(Notification Organizer): element hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'nullify']) &gt;= 1">(Notification Organizer): element hl7:statusCode[@code = 'completed' or @code = 'nullify'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = 'nullify']) &lt;= 1">(Notification Organizer): element hl7:statusCode[@code = 'completed' or @code = 'nullify'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']
Item: (Notification Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']"
         id="d44e381-false-d4090e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="string(@root) = ('1.3.6.1.4.1.19376.1.3.1.1')">(Notification Organizer): The value for root SHALL be '1.3.6.1.4.1.19376.1.3.1.1'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:statusCode[@code = 'completed' or @code = 'nullify']
Item: (Notification Organizer)
-->

   <rule fpi="RULC-1"
         context="*[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:statusCode[@code = 'completed' or @code = 'nullify']"
         id="d44e386-false-d4104e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-1.3.6.1.4.1.19376.1.3.1.1-2008-08-08T000000.html"
              test="@nullFlavor or (@code='completed') or (@code='nullify')">(Notification Organizer): The element value SHALL be one of 'code 'completed' or code 'nullify''.</assert>
   </rule>

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.1']]]
Item: (Notification Organizer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.2']]]
Item: (Notification Organizer)
-->

   <!--
Template derived rules for ID: 1.3.6.1.4.1.19376.1.3.1.1
Context: *[hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]]/hl7:organizer[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1']]/hl7:component[hl7:observation[hl7:templateId[@root = '1.3.6.1.4.1.19376.1.3.1.1.3']]]
Item: (Notification Organizer)
--></pattern>
