<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Create VPS (2.16.840.1.113883.3.1937.777.63.4.2 2022-06-06T00:00:00)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="urn:ihe:pharm:medication" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:oid:1.3.6.1.4.1.19376.1.3.2" prefix="lab"/>
   <ns uri="urn:ihe:pcc:hl7v3" prefix="ihe"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'cvps'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario cvps -->

   <!-- Verbale_di_Pronto_Soccorso_VPS -->
   <pattern>
      <title>Verbale_di_Pronto_Soccorso_VPS</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.1']]"
                 see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045.html">(Verbale di Pronto Soccorso (VPS)): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.6.1']]</assert>
      </rule>
   </pattern>
   <include href="include/2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045.sch"/>
   <include href="include/2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.24-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.29-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.34-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.47-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.65-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.66-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.67-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.69-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.70-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.72-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.73-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.74-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.92-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.11-2018-03-19T000000"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.316-2023-05-03T195254"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.317-2023-05-03T200614"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344"/>
   </phase>
   <phase id="Verbale_di_Pronto_Soccorso_VPS">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045"/>
   </phase>
   <phase id="Verbale_di_Pronto_Soccorso_VPS-closed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.1-2023-05-17T120045-closed"/>
   </phase>
   <phase id="Dimissione-20180319T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.24-2018-03-19T000000"/>
   </phase>
   <phase id="Terapia_farmacologica_in_Pronto_Soccorso">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.29-2018-03-19T000000"/>
   </phase>
   <phase id="Piano_di_cura_alla_dimissione">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.34-2018-03-19T000000"/>
   </phase>
   <phase id="Note_dimissione_Commento">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.47-2018-03-19T000000"/>
   </phase>
   <phase id="Encounter_Activity">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000"/>
   </phase>
   <phase id="Prognosi">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.65-2018-03-19T000000"/>
   </phase>
   <phase id="Dimissione-20180319T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.66-2018-03-19T000000"/>
   </phase>
   <phase id="Post_Dimissione">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.67-2018-03-19T000000"/>
   </phase>
   <phase id="Ragione">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000"/>
   </phase>
   <phase id="Esito">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.69-2018-03-19T000000"/>
   </phase>
   <phase id="Diagnosi_Dimissione">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.70-2018-03-19T000000"/>
   </phase>
   <phase id="Livello_Appropriatezza">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.72-2018-03-19T000000"/>
   </phase>
   <phase id="Richiesta_autopsia">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.73-2018-03-19T000000"/>
   </phase>
   <phase id="Terapia_farmacologica_alla_dimissione-20180319T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.74-2018-03-19T000000"/>
   </phase>
   <phase id="Data_decesso">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000"/>
   </phase>
   <phase id="Trasferimento_Post_Dimissione">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.6.92-2018-03-19T000000"/>
   </phase>
   <phase id="Terapie_Farmacologiche_dimissione-20180319T000000">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000"/>
   </phase>
   <phase id="Controlli">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.11-2018-03-19T000000"/>
   </phase>
   <phase id="AFP-20230503T195254">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.316-2023-05-03T195254"/>
   </phase>
   <phase id="AFam-20230503T200614">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.317-2023-05-03T200614"/>
   </phase>
   <phase id="allergieRAP-20230504T105332">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332"/>
   </phase>
   <phase id="Terapie_Farmacologiche_dimissione-20230517T114344">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- Dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.24-2018-03-19T000000.sch"/>
   <!-- Terapia_farmacologica_in_Pronto_Soccorso -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.29-2018-03-19T000000.sch"/>
   <!-- Piano_di_cura_alla_dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.34-2018-03-19T000000.sch"/>
   <!-- Note_dimissione_Commento -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.47-2018-03-19T000000.sch"/>
   <!-- Encounter_Activity -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.51-2018-03-19T000000.sch"/>
   <!-- Prognosi -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.65-2018-03-19T000000.sch"/>
   <!-- Dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.66-2018-03-19T000000.sch"/>
   <!-- Post_Dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.67-2018-03-19T000000.sch"/>
   <!-- Ragione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.68-2018-03-19T000000.sch"/>
   <!-- Esito -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.69-2018-03-19T000000.sch"/>
   <!-- Diagnosi_Dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.70-2018-03-19T000000.sch"/>
   <!-- Livello_Appropriatezza -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.72-2018-03-19T000000.sch"/>
   <!-- Richiesta_autopsia -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.73-2018-03-19T000000.sch"/>
   <!-- Terapia_farmacologica_alla_dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.74-2018-03-19T000000.sch"/>
   <!-- Data_decesso -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.86-2018-03-19T000000.sch"/>
   <!-- Trasferimento_Post_Dimissione -->
   <include href="include/2.16.840.1.113883.2.9.10.1.6.92-2018-03-19T000000.sch"/>
   <!-- Terapie_Farmacologiche_dimissione -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.10-2018-03-19T000000.sch"/>
   <!-- Controlli -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.11-2018-03-19T000000.sch"/>
   <!-- AFP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.316-2023-05-03T195254.sch"/>
   <!-- AFam -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.317-2023-05-03T200614.sch"/>
   <!-- allergieRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.319-2023-05-04T105332.sch"/>
   <!-- Terapie_Farmacologiche_dimissione -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.331-2023-05-17T114344.sch"/>

</schema>
