<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Create RSA (2.16.840.1.113883.3.1937.777.63.4.6 2022-06-06T00:00:00)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="urn:ihe:pharm:medication" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:oid:1.3.6.1.4.1.19376.1.3.2" prefix="lab"/>
   <ns uri="urn:ihe:pcc:hl7v3" prefix="ihe"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'crsa'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario crsa -->

   <!-- Referto_di_Specialistica_Ambulatoriale_RSA -->
   <pattern>
      <title>Referto_di_Specialistica_Ambulatoriale_RSA</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]"
                 see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000.html">(Referto di Specialistica Ambulatoriale (RSA)): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.9.1']]</assert>
      </rule>
   </pattern>
   <include href="include/2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000.sch"/>
   <include href="include/2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.301-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.302-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.303-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.304-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.305-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.306-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.307-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.308-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.10.12.309-2005-09-07T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.1-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.11-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.12-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.13-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.2-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.3-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.4-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.5-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.6-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.7-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.8-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.9-2018-04-11T000000"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.375-2023-12-18T102324"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.376-2023-12-18T125025"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.379-2023-12-18T144557"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917"/>
   </phase>
   <phase id="Referto_di_Specialistica_Ambulatoriale_RSA">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000"/>
   </phase>
   <phase id="Referto_di_Specialistica_Ambulatoriale_RSA-closed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.1-2018-04-11T000000-closed"/>
   </phase>
   <phase id="CDAAct">
      <active pattern="template-2.16.840.1.113883.10.12.301-2005-09-07T000000"/>
   </phase>
   <phase id="CDAEncounter-20050907T000000">
      <active pattern="template-2.16.840.1.113883.10.12.302-2005-09-07T000000"/>
   </phase>
   <phase id="CDAObservation-20050907T000000">
      <active pattern="template-2.16.840.1.113883.10.12.303-2005-09-07T000000"/>
   </phase>
   <phase id="CDAObservationMedia">
      <active pattern="template-2.16.840.1.113883.10.12.304-2005-09-07T000000"/>
   </phase>
   <phase id="CDAOrganizer">
      <active pattern="template-2.16.840.1.113883.10.12.305-2005-09-07T000000"/>
   </phase>
   <phase id="CDAProcedure">
      <active pattern="template-2.16.840.1.113883.10.12.306-2005-09-07T000000"/>
   </phase>
   <phase id="CDARegionOfInterest">
      <active pattern="template-2.16.840.1.113883.10.12.307-2005-09-07T000000"/>
   </phase>
   <phase id="CDASubstanceAdministration-20050907T000000">
      <active pattern="template-2.16.840.1.113883.10.12.308-2005-09-07T000000"/>
   </phase>
   <phase id="CDASupply">
      <active pattern="template-2.16.840.1.113883.10.12.309-2005-09-07T000000"/>
   </phase>
   <phase id="Quesito_Diagnostico-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.1-2018-04-11T000000"/>
   </phase>
   <phase id="Diagnosi-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000"/>
   </phase>
   <phase id="Conclusioni-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.11-2018-04-11T000000"/>
   </phase>
   <phase id="Suggerimenti_Per_Il_Medico_Prescrittore-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.12-2018-04-11T000000"/>
   </phase>
   <phase id="Accertamenti_e_Controlli_Consigliati-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.13-2018-04-11T000000"/>
   </phase>
   <phase id="Terapia_Farmacologica_Consigliata-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000"/>
   </phase>
   <phase id="Storia_Clinica-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.2-2018-04-11T000000"/>
   </phase>
   <phase id="Allergie-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.3-2018-04-11T000000"/>
   </phase>
   <phase id="Terapia_Farmacologica_In_Atto-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.4-2018-04-11T000000"/>
   </phase>
   <phase id="Precedenti_Esami_Eseguiti-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.5-2018-04-11T000000"/>
   </phase>
   <phase id="Esame_Obiettivo-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.6-2018-04-11T000000"/>
   </phase>
   <phase id="Prestazioni-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.7-2018-04-11T000000"/>
   </phase>
   <phase id="Confronto_Con_Precedenti_Esami_Eseguiti-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.8-2018-04-11T000000"/>
   </phase>
   <phase id="Referto-20180411T000000">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.9.3.9-2018-04-11T000000"/>
   </phase>
   <phase id="AFP-20231218T102324">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.375-2023-12-18T102324"/>
   </phase>
   <phase id="AFam-20231218T125025">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.376-2023-12-18T125025"/>
   </phase>
   <phase id="allergieRAP-20231218T144557">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.379-2023-12-18T144557"/>
   </phase>
   <phase id="Terapie_Farmacologiche_dimissione-20231220T151917">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- CDAAct -->
   <include href="include/2.16.840.1.113883.10.12.301-2005-09-07T000000.sch"/>
   <!-- CDAEncounter -->
   <include href="include/2.16.840.1.113883.10.12.302-2005-09-07T000000.sch"/>
   <!-- CDAObservation -->
   <include href="include/2.16.840.1.113883.10.12.303-2005-09-07T000000.sch"/>
   <!-- CDAObservationMedia -->
   <include href="include/2.16.840.1.113883.10.12.304-2005-09-07T000000.sch"/>
   <!-- CDAOrganizer -->
   <include href="include/2.16.840.1.113883.10.12.305-2005-09-07T000000.sch"/>
   <!-- CDAProcedure -->
   <include href="include/2.16.840.1.113883.10.12.306-2005-09-07T000000.sch"/>
   <!-- CDARegionOfInterest -->
   <include href="include/2.16.840.1.113883.10.12.307-2005-09-07T000000.sch"/>
   <!-- CDASubstanceAdministration -->
   <include href="include/2.16.840.1.113883.10.12.308-2005-09-07T000000.sch"/>
   <!-- CDASupply -->
   <include href="include/2.16.840.1.113883.10.12.309-2005-09-07T000000.sch"/>
   <!-- Quesito_Diagnostico -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.1-2018-04-11T000000.sch"/>
   <!-- Diagnosi -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.10-2018-04-11T000000.sch"/>
   <!-- Conclusioni -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.11-2018-04-11T000000.sch"/>
   <!-- Suggerimenti_Per_Il_Medico_Prescrittore -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.12-2018-04-11T000000.sch"/>
   <!-- Accertamenti_e_Controlli_Consigliati -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.13-2018-04-11T000000.sch"/>
   <!-- Terapia_Farmacologica_Consigliata -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.14-2018-04-11T000000.sch"/>
   <!-- Storia_Clinica -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.2-2018-04-11T000000.sch"/>
   <!-- Allergie -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.3-2018-04-11T000000.sch"/>
   <!-- Terapia_Farmacologica_In_Atto -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.4-2018-04-11T000000.sch"/>
   <!-- Precedenti_Esami_Eseguiti -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.5-2018-04-11T000000.sch"/>
   <!-- Esame_Obiettivo -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.6-2018-04-11T000000.sch"/>
   <!-- Prestazioni -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.7-2018-04-11T000000.sch"/>
   <!-- Confronto_Con_Precedenti_Esami_Eseguiti -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.8-2018-04-11T000000.sch"/>
   <!-- Referto -->
   <include href="include/2.16.840.1.113883.2.9.10.1.9.3.9-2018-04-11T000000.sch"/>
   <!-- AFP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.375-2023-12-18T102324.sch"/>
   <!-- AFam -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.376-2023-12-18T125025.sch"/>
   <!-- allergieRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.379-2023-12-18T144557.sch"/>
   <!-- Terapie_Farmacologiche_dimissione -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.388-2023-12-20T151917.sch"/>

</schema>
