<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                xmlns:lab="urn:oid:1.3.6.1.4.1.19376.1.3.2"
                xmlns:ihe="urn:ihe:pcc:hl7v3"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M11"/>
      <xsl:apply-templates select="/" mode="M12"/>
      <xsl:apply-templates select="/" mode="M13"/>
      <xsl:apply-templates select="/" mode="M14"/>
      <xsl:apply-templates select="/" mode="M37"/>
      <xsl:apply-templates select="/" mode="M38"/>
      <xsl:apply-templates select="/" mode="M39"/>
      <xsl:apply-templates select="/" mode="M40"/>
      <xsl:apply-templates select="/" mode="M41"/>
      <xsl:apply-templates select="/" mode="M42"/>
      <xsl:apply-templates select="/" mode="M43"/>
      <xsl:apply-templates select="/" mode="M44"/>
      <xsl:apply-templates select="/" mode="M45"/>
      <xsl:apply-templates select="/" mode="M46"/>
      <xsl:apply-templates select="/" mode="M47"/>
      <xsl:apply-templates select="/" mode="M48"/>
      <xsl:apply-templates select="/" mode="M49"/>
      <xsl:apply-templates select="/" mode="M50"/>
      <xsl:apply-templates select="/" mode="M51"/>
      <xsl:apply-templates select="/" mode="M52"/>
      <xsl:apply-templates select="/" mode="M53"/>
      <xsl:apply-templates select="/" mode="M54"/>
      <xsl:apply-templates select="/" mode="M55"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <xsl:param name="scenariolabel" select="'RAPv1'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN Referto_Anatomia_Patologica-->


	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M12">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']] (descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337Referto di Anatomia Patologica (RAP)-->


	  <!--RULE d44e21105-false-d3272298e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]"
                 priority="1754"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:realmCode is required [min 1x]. (count(hl7:realmCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@nullFlavor)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:id[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:id[not(@nullFlavor)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[not(@nullFlavor)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:id[not(@nullFlavor)] appears too often [max 1x]. (count(hl7:id[not(@nullFlavor)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(sdtc:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element sdtc:statusCode appears too often [max 1x]. (count(sdtc:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x]. (count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x]. (count(hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:languageCode is required [min 1x]. (count(hl7:languageCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:languageCode appears too often [max 1x]. (count(hl7:languageCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:recordTarget[hl7:patientRole] is required [min 1x]. (count(hl7:recordTarget[hl7:patientRole]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x]. (count(hl7:recordTarget[hl7:patientRole]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:author[hl7:assignedAuthor] is required [min 1x]. (count(hl7:author[hl7:assignedAuthor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x]. (count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:custodian[hl7:assignedCustodian] is required [min 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x]. (count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] is required [min 1x]. (count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x]. (count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:inFulfillmentOf[hl7:order]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:inFulfillmentOf[hl7:order] is required [min 1x]. (count(hl7:inFulfillmentOf[hl7:order]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:documentationOf[hl7:serviceEvent] appears too often [max 1x]. (count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x]. (count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x]. (count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x]. (count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:structuredBody] is required [min 1x]. (count(hl7:component[hl7:structuredBody]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): element hl7:component[hl7:structuredBody] appears too often [max 1x]. (count(hl7:component[hl7:structuredBody]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21136-false-d3273647e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1753"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('POCD_MT000040UV02') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21154-false-d3273666e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']"
                 priority="1752"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.8.1')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.8.1'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.8.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21176-false-d3273683e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:id[not(@nullFlavor)]"
                 priority="1751"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21199-false-d3273705e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1750"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('11526-1')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for code SHALL be '11526-1'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('11526-1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21228-false-d3273733e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:code[(@code = '11526-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1749"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e21310-false-d3273782e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:confidentialityCode[(@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
                 priority="1748"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' or code 'V' codeSystem '2.16.840.1.113883.5.25''. (@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Referto di Anatomia Patologica (RAP)): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e22-false-d3273927e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1747"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RCT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:patientRole[hl7:patient] is required [min 1x]. (count(hl7:patientRole[hl7:patient]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:patientRole[hl7:patient] appears too often [max 1x]. (count(hl7:patientRole[hl7:patient]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e37-false-d3274153e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1746"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PAT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] is required [min 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]] appears too often [max 1x]. (count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e50-false-d3274297e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1745"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1744"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e206-false-d3274469e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1742"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e220-false-d3274557e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]"
                 priority="1741"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] is required [min 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x]. (count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:birthTime is required [min 1x]. (count(hl7:birthTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:birthTime appears too often [max 1x]. (count(hl7:birthTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:birthplace[hl7:place] appears too often [max 1x]. (count(hl7:birthplace[hl7:place]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:name"
                 priority="1740"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e250-false-d3274764e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
                 priority="1739"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e269-false-d3274837e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian"
                 priority="1738"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('GUARD') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for classCode SHALL be 'GUARD'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('GUARD') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:guardianPerson appears too often [max 1x]. (count(hl7:guardianPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e273-false-d3274926e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:id"
                 priority="1737"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:addr"
                 priority="1736"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e295-false-d3275103e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:telecom"
                 priority="1734"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson"
                 priority="1733"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianPerson/hl7:name"
                 priority="1731"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']"
                 priority="1730"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1729"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1728"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1727"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1725"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1723"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1722"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1721"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1719"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1718"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1717"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1715"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1713"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1712"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1711"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e317-false-d3276404e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]"
                 priority="1710"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('BIRTHPL') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:place is required [min 1x]. (count(hl7:place) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:place appears too often [max 1x]. (count(hl7:place) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3273819e321-false-d3276440e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place"
                 priority="1709"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PLC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:addr is required [min 1x]. (count(hl7:addr) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr"
                 priority="1708"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AddressBirthPlace): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.116-2022-09-20T152830.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA recordTarget RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.112-2022-09-20T112028.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']"
                 priority="1706"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1705"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1704"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1703"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1701"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1699"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1698"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1697"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1695"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1694"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1693"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1691"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1689"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1688"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1687"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3276639e400-false-d3277793e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]"
                 priority="1686"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:functionCode appears too often [max 1x]. (count(hl7:functionCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:assignedAuthor is required [min 1x]. (count(hl7:assignedAuthor) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:assignedAuthor appears too often [max 1x]. (count(hl7:assignedAuthor) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3276639e417-false-d3277973e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
                 priority="1685"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:assignedAuthoringDevice[hl7:templateId] appears too often [max 1x]. (count(hl7:assignedAuthoringDevice[hl7:templateId]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3276639e436-false-d3278085e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
                 priority="1684"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr"
                 priority="1683"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3276639e468-false-d3278265e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
                 priority="1681"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson"
                 priority="1680"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name"
                 priority="1678"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]"
                 priority="1677"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): element hl7:templateId is required [min 1x]. (count(hl7:templateId) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:manufacturerModelName) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): element hl7:manufacturerModelName appears too often [max 1x]. (count(hl7:manufacturerModelName) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:softwareName) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): element hl7:softwareName appears too often [max 1x]. (count(hl7:softwareName) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): element hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']] appears too often [max 1x]. (count(hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DEV') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for classCode SHALL be 'DEV'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DEV') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA author RAP): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.118-2022-09-20T153550.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:templateId"
                 priority="1675"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:code"
                 priority="1674"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]"
                 priority="1673"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:maintainingPerson) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): element hl7:maintainingPerson is required [min 1x]. (count(hl7:maintainingPerson) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:maintainingPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): element hl7:maintainingPerson appears too often [max 1x]. (count(hl7:maintainingPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('MNT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedAuthoringDevice ): The value for classCode SHALL be 'MNT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('MNT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.35-2022-07-04T104340.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']"
                 priority="1671"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272')"/>
         <xsl:otherwise>
            <xsl:message>(MaintainedEntity): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.272'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.272') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.272-2022-12-13T103208.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson"
                 priority="1670"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedAuthoringDevice[hl7:templateId]/hl7:asMaintainedEntity[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.272']]/hl7:maintainingPerson/hl7:name"
                 priority="1669"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1668"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1667"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1666"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1665"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1663"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1661"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1660"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1659"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1657"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1656"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1655"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1653"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1651"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1650"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1649"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3278843e400-false-d3279983e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]"
                 priority="1648"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('ENT') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): The value for typeCode SHALL be 'ENT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('ENT') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA dataEnterer RAP): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.119-2022-09-20T160655.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1647"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1646"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1645"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1644"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1642"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1641"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1640"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1639"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1638"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1637"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1636"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1634"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1632"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1631"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1630"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1628"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1627"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1626"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1624"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1622"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1621"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1620"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3280126e568-false-d3281785e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1619"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian RAP): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('CST') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian RAP): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian RAP): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x]. (count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1618"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x]. (count(hl7:representedCustodianOrganization) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x]. (count(hl7:representedCustodianOrganization) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA custodian RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.120-2022-09-20T160934.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
                 priority="1616"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
                 priority="1615"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1614"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1613"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3281844e146-false-d3282226e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]"
                 priority="1611"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('PRCP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): The value for typeCode SHALL be 'PRCP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('PRCP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:intendedRecipient) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): element hl7:intendedRecipient is required [min 1x]. (count(hl7:intendedRecipient) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:intendedRecipient) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): element hl7:intendedRecipient appears too often [max 1x]. (count(hl7:intendedRecipient) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3281844e156-false-d3282342e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient"
                 priority="1610"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:informationRecipient) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): element hl7:informationRecipient appears too often [max 1x]. (count(hl7:informationRecipient) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:receivedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): element hl7:receivedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:receivedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3281844e179-false-d3282428e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id"
                 priority="1609"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr"
                 priority="1608"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3281844e196-false-d3282597e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom"
                 priority="1606"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA informationRecipient RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.121-2022-09-20T161454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient"
                 priority="1605"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name"
                 priority="1604"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']"
                 priority="1603"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1602"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1601"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1600"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1598"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1596"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1595"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1594"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1592"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1591"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1590"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1588"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1586"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1585"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1584"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3282794e400-false-d3283935e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1583"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LA') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3282794e431-false-d3284034e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1582"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDA legalAuthenticator RAP): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.122-2022-09-20T162310.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1581"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1580"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1579"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1578"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1576"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1575"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1574"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1573"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1572"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1571"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1570"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1568"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1566"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1565"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1564"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1562"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1561"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1560"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1558"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1556"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1555"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1554"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3284099e568-false-d3285790e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1553"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTHEN') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): The value for typeCode SHALL be 'AUTHEN'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUTHEN') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3284099e605-false-d3285885e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1552"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDA authenticator RAP): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.123-2022-09-20T162745.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1551"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1550"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1549"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1548"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1546"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1545"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1544"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1543"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1542"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1541"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1540"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1538"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1536"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1535"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1534"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1532"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1531"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1530"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1528"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1526"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1525"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1524"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e568-false-d3287639e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
                 priority="1523"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:associatedEntity[@classCode] is required [min 1x]. (count(hl7:associatedEntity[@classCode]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:associatedEntity[@classCode] appears too often [max 1x]. (count(hl7:associatedEntity[@classCode]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e602-false-d3287740e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1522"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e618-false-d3287829e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
                 priority="1521"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@classCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @classCode SHALL be present. (@classCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC). (not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:associatedPerson appears too often [max 1x]. (count(hl7:associatedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): element hl7:scopingOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e625-false-d3287932e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
                 priority="1520"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e634-false-d3287953e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
                 priority="1519"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr"
                 priority="1518"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3285950e655-false-d3288124e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
                 priority="1516"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA participant RAP): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.124-2022-09-20T162945.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson"
                 priority="1515"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name"
                 priority="1514"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']"
                 priority="1513"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1512"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1511"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1510"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1508"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1506"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1505"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1504"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1502"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1501"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1500"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1498"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1496"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1495"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1494"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3288321e400-false-d3289412e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]"
                 priority="1493"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('FLFS') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): The value for typeCode SHALL be 'FLFS'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('FLFS') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:order) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:order is required [min 1x]. (count(hl7:order) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:order) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:order appears too often [max 1x]. (count(hl7:order) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3288321e410-false-d3289432e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
                 priority="1492"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('RQO') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): The value for moodCode SHALL be 'RQO'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('RQO') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:priorityCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): element hl7:priorityCode appears too often [max 1x]. (count(hl7:priorityCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3288321e416-false-d3289468e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
                 priority="1491"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA inFulfillmentOf RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.125-2022-09-20T163646.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289496e20-false-d3289552e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]"
                 priority="1490"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('DOC') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): The value for typeCode SHALL be 'DOC'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('DOC') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:serviceEvent is required [min 1x]. (count(hl7:serviceEvent) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceEvent) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:serviceEvent appears too often [max 1x]. (count(hl7:serviceEvent) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289496e30-false-d3289670e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent"
                 priority="1489"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289496e47-false-d3289754e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:id"
                 priority="1488"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289496e75-false-d3289837e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]"
                 priority="1487"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>' (not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:functionCode appears too often [max 1x]. (count(hl7:functionCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA documentationOf RAP): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.126-2022-09-20T163907.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1486"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1485"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1484"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1483"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1481"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1480"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1479"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1478"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1477"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1476"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1475"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1473"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1471"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1470"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1469"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1467"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1466"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1465"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1463"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1461"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1460"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:documentationOf[hl7:serviceEvent]/hl7:serviceEvent/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1459"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289989e568-false-d3291630e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1458"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:parentDocument is required [min 1x]. (count(hl7:parentDocument) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:parentDocument appears too often [max 1x]. (count(hl7:parentDocument) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289989e613-false-d3291661e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1457"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289989e619-false-d3291707e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1456"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3289989e639-false-d3291725e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1455"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA relatedDocument RAP): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.128-2022-09-20T170104.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3291767e20-false-d3291867e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]"
                 priority="1454"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:encompassingEncounter is required [min 1x]. (count(hl7:encompassingEncounter) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:encompassingEncounter appears too often [max 1x]. (count(hl7:encompassingEncounter) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3291767e30-false-d3292073e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter"
                 priority="1453"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ENC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): The value for classCode SHALL be 'ENC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ENC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x]. (count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:responsibleParty[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:responsibleParty[hl7:assignedEntity] appears too often [max 1x]. (count(hl7:responsibleParty[hl7:assignedEntity]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:location[hl7:healthCareFacility] appears too often [max 1x]. (count(hl7:location[hl7:healthCareFacility]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3291767e36-false-d3292215e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:id"
                 priority="1452"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3291767e45-false-d3292239e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
                 priority="1451"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d3291767e78-false-d3292325e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]"
                 priority="1450"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RESP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): The value for typeCode SHALL be 'RESP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RESP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA componentOf RAP): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.127-2022-09-20T164155.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1449"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x]. (count(hl7:telecom) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1448"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1447"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1446"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1444"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1443"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA person ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1442"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA name ): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1441"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x]. (count(hl7:asOrganizationPartOf) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1440"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1439"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1438"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA addr): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1436"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1434"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1433"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemVersion"/>
               <xsl:text/>' (not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1432"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') or not(@determinerCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
 