<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
   <title>Schematron file for transaction Referto Anatomia Patologica(RAP) (2.16.840.1.113883.3.1937.777.63.4.20 2022-09-16T00:00:00)</title>
   <ns uri="urn:hl7-org:v3" prefix="hl7"/>
   <ns uri="urn:hl7-org:v3" prefix="cda"/>
   <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
   <ns uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
   <!-- Add extra namespaces -->
   <ns uri="urn:hl7-org:sdtc" prefix="sdtc"/>
   <ns uri="urn:ihe:pharm:medication" prefix="pharm"/>
   <ns uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
   <ns uri="urn:oid:1.3.6.1.4.1.19376.1.3.2" prefix="lab"/>
   <ns uri="urn:ihe:pcc:hl7v3" prefix="ihe"/>
   <!-- Include realm specific schematron -->
   <!-- Include scenario label -->
   <let name="scenariolabel" value="'RAPv1'"/>
   <!-- Include datatype abstract schematrons -->
   <pattern>
      <include href="include/DTr1_AD.sch"/>
      <include href="include/DTr1_AD.CA.sch"/>
      <include href="include/DTr1_AD.CA.BASIC.sch"/>
      <include href="include/DTr1_AD.DE.sch"/>
      <include href="include/DTr1_AD.EPSOS.sch"/>
      <include href="include/DTr1_AD.IPS.sch"/>
      <include href="include/DTr1_AD.NL.sch"/>
      <include href="include/DTr1_ADXP.sch"/>
      <include href="include/DTr1_ANY.sch"/>
      <include href="include/DTr1_BIN.sch"/>
      <include href="include/DTr1_BL.sch"/>
      <include href="include/DTr1_BN.sch"/>
      <include href="include/DTr1_BXIT_IVL_PQ.sch"/>
      <include href="include/DTr1_CD.sch"/>
      <include href="include/DTr1_CD.EPSOS.sch"/>
      <include href="include/DTr1_CD.IPS.sch"/>
      <include href="include/DTr1_CD.SDTC.sch"/>
      <include href="include/DTr1_CE.sch"/>
      <include href="include/DTr1_CE.EPSOS.sch"/>
      <include href="include/DTr1_CE.IPS.sch"/>
      <include href="include/DTr1_CO.sch"/>
      <include href="include/DTr1_CO.EPSOS.sch"/>
      <include href="include/DTr1_CR.sch"/>
      <include href="include/DTr1_CS.sch"/>
      <include href="include/DTr1_CS.LANG.sch"/>
      <include href="include/DTr1_CV.sch"/>
      <include href="include/DTr1_CV.EPSOS.sch"/>
      <include href="include/DTr1_CV.IPS.sch"/>
      <include href="include/DTr1_ED.sch"/>
      <include href="include/DTr1_EIVL.event.sch"/>
      <include href="include/DTr1_EIVL_TS.sch"/>
      <include href="include/DTr1_EN.sch"/>
      <include href="include/DTr1_ENXP.sch"/>
      <include href="include/DTr1_GLIST.sch"/>
      <include href="include/DTr1_GLIST_PQ.sch"/>
      <include href="include/DTr1_GLIST_TS.sch"/>
      <include href="include/DTr1_hl7nl-INT.sch"/>
      <include href="include/DTr1_hl7nl-IVL_QTY.sch"/>
      <include href="include/DTr1_hl7nl-IVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PIVL_TS.sch"/>
      <include href="include/DTr1_hl7nl-PQ.sch"/>
      <include href="include/DTr1_hl7nl-QSET_QTY.sch"/>
      <include href="include/DTr1_hl7nl-RTO.sch"/>
      <include href="include/DTr1_hl7nl-TS.sch"/>
      <include href="include/DTr1_II.sch"/>
      <include href="include/DTr1_II.AT.ATU.sch"/>
      <include href="include/DTr1_II.AT.BLZ.sch"/>
      <include href="include/DTr1_II.AT.DVR.sch"/>
      <include href="include/DTr1_II.AT.KTONR.sch"/>
      <include href="include/DTr1_II.EPSOS.sch"/>
      <include href="include/DTr1_II.NL.AGB.sch"/>
      <include href="include/DTr1_II.NL.BIG.sch"/>
      <include href="include/DTr1_II.NL.BSN.sch"/>
      <include href="include/DTr1_II.NL.URA.sch"/>
      <include href="include/DTr1_II.NL.UZI.sch"/>
      <include href="include/DTr1_INT.sch"/>
      <include href="include/DTr1_INT.NONNEG.sch"/>
      <include href="include/DTr1_INT.POS.sch"/>
      <include href="include/DTr1_IVL_INT.sch"/>
      <include href="include/DTr1_IVL_MO.sch"/>
      <include href="include/DTr1_IVL_PQ.sch"/>
      <include href="include/DTr1_IVL_REAL.sch"/>
      <include href="include/DTr1_IVL_TS.sch"/>
      <include href="include/DTr1_IVL_TS.CH.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_IVL_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_IVL_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_IVXB_INT.sch"/>
      <include href="include/DTr1_IVXB_MO.sch"/>
      <include href="include/DTr1_IVXB_PQ.sch"/>
      <include href="include/DTr1_IVXB_REAL.sch"/>
      <include href="include/DTr1_IVXB_TS.sch"/>
      <include href="include/DTr1_list_int.sch"/>
      <include href="include/DTr1_MO.sch"/>
      <include href="include/DTr1_ON.sch"/>
      <include href="include/DTr1_PIVL_TS.sch"/>
      <include href="include/DTr1_PN.sch"/>
      <include href="include/DTr1_PN.CA.sch"/>
      <include href="include/DTr1_PN.NL.sch"/>
      <include href="include/DTr1_PQ.sch"/>
      <include href="include/DTr1_PQR.sch"/>
      <include href="include/DTr1_QTY.sch"/>
      <include href="include/DTr1_REAL.sch"/>
      <include href="include/DTr1_REAL.NONNEG.sch"/>
      <include href="include/DTr1_REAL.POS.sch"/>
      <include href="include/DTr1_RTO.sch"/>
      <include href="include/DTr1_RTO_PQ_PQ.sch"/>
      <include href="include/DTr1_RTO_QTY_QTY.sch"/>
      <include href="include/DTr1_SC.sch"/>
      <include href="include/DTr1_SD.TEXT.sch"/>
      <include href="include/DTr1_SLIST.sch"/>
      <include href="include/DTr1_SLIST_PQ.sch"/>
      <include href="include/DTr1_SLIST_TS.sch"/>
      <include href="include/DTr1_ST.sch"/>
      <include href="include/DTr1_SXCM_INT.sch"/>
      <include href="include/DTr1_SXCM_MO.sch"/>
      <include href="include/DTr1_SXCM_PQ.sch"/>
      <include href="include/DTr1_SXCM_REAL.sch"/>
      <include href="include/DTr1_SXCM_TS.sch"/>
      <include href="include/DTr1_SXPR_TS.sch"/>
      <include href="include/DTr1_TEL.sch"/>
      <include href="include/DTr1_TEL.AT.sch"/>
      <include href="include/DTr1_TEL.CA.EMAIL.sch"/>
      <include href="include/DTr1_TEL.CA.PHONE.sch"/>
      <include href="include/DTr1_TEL.EPSOS.sch"/>
      <include href="include/DTr1_TEL.IPS.sch"/>
      <include href="include/DTr1_TEL.NL.EXTENDED.sch"/>
      <include href="include/DTr1_thumbnail.sch"/>
      <include href="include/DTr1_TN.sch"/>
      <include href="include/DTr1_TS.sch"/>
      <include href="include/DTr1_TS.AT.TZ.sch"/>
      <include href="include/DTr1_TS.AT.VAR.sch"/>
      <include href="include/DTr1_TS.CH.TZ.sch"/>
      <include href="include/DTr1_TS.DATE.sch"/>
      <include href="include/DTr1_TS.DATE.FULL.sch"/>
      <include href="include/DTr1_TS.DATE.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIME.MIN.sch"/>
      <include href="include/DTr1_TS.DATETIMETZ.MIN.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.sch"/>
      <include href="include/DTr1_TS.EPSOS.TZ.OPT.sch"/>
      <include href="include/DTr1_TS.IPS.TZ.sch"/>
      <include href="include/DTr1_URL.sch"/>
      <include href="include/DTr1_URL.NL.EXTENDED.sch"/>
   </pattern>

   <!-- Include the project schematrons related to scenario RAPv1 -->

   <!-- Referto_Anatomia_Patologica -->
   <pattern>
      <title>Referto_Anatomia_Patologica</title>
      <rule fpi="RUL-EXPEL" context="/">
         <assert role="warning"
                 test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]"
                 see="https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.html">(Referto di Anatomia Patologica (RAP)): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.8.1']]</assert>
      </rule>
   </pattern>
   <include href="include/2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337.sch"/>
   <include href="include/2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337-closed.sch"/>


   <!-- Create phases for more targeted validation on large instances -->
   <phase id="AllExceptClosed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.130-2022-09-20T174017"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.135-2022-09-21T135439"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.138-2022-09-21T161610"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.150-2022-09-22T110216"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.155-2022-09-25T131720"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.156-2022-09-25T132816"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.167-2022-09-25T202731"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.169-2022-09-25T210055"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.170-2022-09-25T211318"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.175-2022-09-26T150417"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.180-2022-09-26T155316"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.183-2022-09-26T161142"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.184-2022-09-26T164206"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.186-2022-09-26T165549"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.190-2022-09-26T173349"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.211-2022-09-27T123552"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.220-2022-09-27T151552"/>
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.257-2022-10-06T102014"/>
   </phase>
   <phase id="Referto_Anatomia_Patologica">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337"/>
   </phase>
   <phase id="Referto_Anatomia_Patologica-closed">
      <active pattern="template-2.16.840.1.113883.2.9.10.1.8.1-2022-09-20T145337-closed"/>
   </phase>
   <phase id="QuesitoDiagnosticoRAP-20220920T174017">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.130-2022-09-20T174017"/>
   </phase>
   <phase id="QuesitoDiagnosticoRAP-20220921T111356">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356"/>
   </phase>
   <phase id="AFP-20220921T135439">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.135-2022-09-21T135439"/>
   </phase>
   <phase id="AFam-20220921T161610">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.138-2022-09-21T161610"/>
   </phase>
   <phase id="OsservazioneMacroscopicaRAP">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.150-2022-09-22T110216"/>
   </phase>
   <phase id="AllergieRAP-20220925T131720">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.155-2022-09-25T131720"/>
   </phase>
   <phase id="allergieRAP-20220925T132816">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.156-2022-09-25T132816"/>
   </phase>
   <phase id="precExamEsegRAP">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.167-2022-09-25T202731"/>
   </phase>
   <phase id="terapFarmacPregRAP-20220925T210055">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.169-2022-09-25T210055"/>
   </phase>
   <phase id="entryTerapRAP-20220925T211318">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.170-2022-09-25T211318"/>
   </phase>
   <phase id="TerapiaOncologicapregressaRAP">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.175-2022-09-26T150417"/>
   </phase>
   <phase id="Precedentitrattamentiprocedureregresse">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.180-2022-09-26T155316"/>
   </phase>
   <phase id="ProcedureRAP-20220926T161142">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.183-2022-09-26T161142"/>
   </phase>
   <phase id="IndaginiRadiologicheRAP-20220926T164206">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.184-2022-09-26T164206"/>
   </phase>
   <phase id="IndaginiRadiologicheRAP-20220926T165549">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.186-2022-09-26T165549"/>
   </phase>
   <phase id="StatodelmargineRAP">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.190-2022-09-26T173349"/>
   </phase>
   <phase id="CDASection-20220927T123552">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.211-2022-09-27T123552"/>
   </phase>
   <phase id="CDASection-20220927T151552">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.220-2022-09-27T151552"/>
   </phase>
   <phase id="OggettiCorrelatiRAP">
      <active pattern="template-2.16.840.1.113883.3.1937.777.63.10.257-2022-10-06T102014"/>
   </phase>

   <!-- Include schematrons from templates with explicit * or ** context (but no representing templates), only those used in scenario template -->

   <!-- QuesitoDiagnosticoRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.130-2022-09-20T174017.sch"/>
   <!-- QuesitoDiagnosticoRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.131-2022-09-21T111356.sch"/>
   <!-- AFP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.135-2022-09-21T135439.sch"/>
   <!-- AFam -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.138-2022-09-21T161610.sch"/>
   <!-- OsservazioneMacroscopicaRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.150-2022-09-22T110216.sch"/>
   <!-- AllergieRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.155-2022-09-25T131720.sch"/>
   <!-- allergieRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.156-2022-09-25T132816.sch"/>
   <!-- precExamEsegRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.167-2022-09-25T202731.sch"/>
   <!-- terapFarmacPregRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.169-2022-09-25T210055.sch"/>
   <!-- entryTerapRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.170-2022-09-25T211318.sch"/>
   <!-- TerapiaOncologicapregressaRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.175-2022-09-26T150417.sch"/>
   <!-- Precedentitrattamentiprocedureregresse -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.180-2022-09-26T155316.sch"/>
   <!-- ProcedureRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.183-2022-09-26T161142.sch"/>
   <!-- IndaginiRadiologicheRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.184-2022-09-26T164206.sch"/>
   <!-- IndaginiRadiologicheRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.186-2022-09-26T165549.sch"/>
   <!-- StatodelmargineRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.190-2022-09-26T173349.sch"/>
   <!-- CDASection -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.211-2022-09-27T123552.sch"/>
   <!-- CDASection -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.220-2022-09-27T151552.sch"/>
   <!-- OggettiCorrelatiRAP -->
   <include href="include/2.16.840.1.113883.3.1937.777.63.10.257-2022-10-06T102014.sch"/>

</schema>
