<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                xmlns:lab="urn:oid:1.3.6.1.4.1.19376.1.3.2"
                xmlns:ihe="urn:ihe:pcc:hl7v3"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="Schematron file for transaction Erogazione Farmaceutica Erogazione Farmaceutica (2.16.840.1.113883.3.1937.777.63.4.24 2023-02-15T00:00:00)"
                              schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="hl7"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="cda"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:sdtc" prefix="sdtc"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pharm:medication" prefix="pharm"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:oid:1.3.6.1.4.1.19376.1.3.2" prefix="lab"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pcc:hl7v3" prefix="ihe"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="name">ErogazioneFarmaceutica</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918</xsl:attribute>
            <xsl:attribute name="name">ErogazioneFarmaceutica</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918-closed</xsl:attribute>
            <xsl:attribute name="name">ErogazioneFarmaceutica</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematron file for transaction Erogazione Farmaceutica Erogazione Farmaceutica (2.16.840.1.113883.3.1937.777.63.4.24 2023-02-15T00:00:00)</svrl:text>
   <xsl:param name="scenariolabel" select="'ErogFarmV1.0'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN ErogazioneFarmaceutica-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">ErogazioneFarmaceutica</svrl:text>

	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M12">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918ErogazioneFarmaceutica-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">ErogazioneFarmaceutica</svrl:text>

	  <!--RULE d44e9349-false-d370761e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]"
                 priority="1269"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime[not(@nullFlavor)]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:effectiveTime[not(@nullFlavor)] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime[not(@nullFlavor)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:effectiveTime[not(@nullFlavor)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:languageCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:languageCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:author[hl7:assignedAuthor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): element hl7:component[not(@nullFlavor)][hl7:structuredBody[@classCode = 'DOCBODY']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9351-false-d371300e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:realmCode"
                 priority="1268"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9367-false-d371314e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1267"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.1.3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('POCD_MT000040UV02')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9395-false-d371333e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']"
                 priority="1266"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.13.1.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.10.1.13.1.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.13.1.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.0')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('1.0')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for extension SHALL be '1.0'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9410-false-d371351e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:id"
                 priority="1265"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9425-false-d371373e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1264"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('60593-1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('60593-1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for code SHALL be '60593-1'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9449-false-d371401e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:code[(@code = '60593-1' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1263"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9477-false-d371433e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:effectiveTime[not(@nullFlavor)]"
                 priority="1262"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9494-false-d371447e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V' or @nullFlavor]"
                 priority="1261"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N') or (@code='V')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or (@code='N') or (@code='V')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The element value SHALL be one of 'code 'N' or code 'V''.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9535-false-d371478e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:languageCode"
                 priority="1260"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9553-false-d371491e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:setId"
                 priority="1259"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e9577-false-d371512e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:versionNumber"
                 priority="1258"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.2.9.10.1.13.1.1-2023-02-09T102918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(ErogazioneFarmaceutica): Attribute @value is not a valid int number <xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e29-false-d371606e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]"
                 priority="1257"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RCT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:patientRole[@classCode = 'PAT'][hl7:patient] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:patientRole[@classCode = 'PAT'][hl7:patient] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e41-false-d371790e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]"
                 priority="1256"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PAT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e45-false-d371913e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:id"
                 priority="1255"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:addr"
                 priority="1254"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e164-false-d372085e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:telecom"
                 priority="1252"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e204-false-d372155e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1251"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:birthTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:birthTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e216-false-d372249e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
                 priority="1250"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e255-false-d372292e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1249"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e295-false-d372327e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
                 priority="1248"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e318-false-d372379e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
                 priority="1247"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('GUARD') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('GUARD') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'GUARD'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:guardianPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:guardianPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e328-false-d372461e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
                 priority="1246"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e343-false-d372482e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
                 priority="1245"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr"
                 priority="1244"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e384-false-d372657e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom"
                 priority="1242"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson"
                 priority="1241"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']"
                 priority="1240"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1239"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1238"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1237"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1235"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1233"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1232"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1231"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1229"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1228"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1227"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1225"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1223"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1222"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1221"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e427-false-d373851e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]"
                 priority="1220"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('BIRTHPL')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:place is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:place appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e437-false-d373871e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place"
                 priority="1219"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PLC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:addr is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d371519e467-false-d373895e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place]/hl7:place/hl7:addr"
                 priority="1218"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.284-2023-02-13T103036.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (Erog)): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']"
                 priority="1217"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1216"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1215"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1214"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1212"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1210"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1209"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1208"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1206"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1205"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1204"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1202"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1200"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1199"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:recordTarget[hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1198"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e436-false-d375117e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]"
                 priority="1197"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:assignedAuthor[hl7:assignedPerson] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:assignedAuthor[hl7:assignedPerson] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e450-false-d375197e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:time"
                 priority="1196"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e476-false-d375258e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]"
                 priority="1195"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:assignedPerson is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e484-false-d375348e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id"
                 priority="1194"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e530-false-d375369e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code"
                 priority="1193"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr"
                 priority="1192"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d373978e567-false-d375554e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom"
                 priority="1190"
                 mode="M13">
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.285-2023-02-13T104452.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author (Erog)): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson"
                 priority="1189"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name"
                 priority="1188"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1187"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1186"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1185"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1184"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1182"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1180"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1179"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1178"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1176"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1175"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1174"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1172"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1170"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1169"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1168"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d375753e404-false-d376893e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]"
                 priority="1167"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('ENT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('ENT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): The value for typeCode SHALL be 'ENT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d375753e416-false-d376972e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time"
                 priority="1166"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.286-2023-02-13T105410.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEnterer (Erog)): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1165"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1164"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1163"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1162"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1160"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1159"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1158"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1157"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1156"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1155"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1154"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1152"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1150"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1149"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1148"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1146"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1145"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1144"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1142"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1140"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1139"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1138"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d377039e572-false-d378689e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1137"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('CST') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d377039e626-false-d378727e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1136"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:representedCustodianOrganization is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:representedCustodianOrganization appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d377039e636-false-d378765e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization"
                 priority="1135"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d377039e642-false-d378810e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id"
                 priority="1134"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d377039e676-false-d378839e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom"
                 priority="1133"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr"
                 priority="1132"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.287-2023-02-13T105745.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian (Erog)): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d378881e79-false-d379069e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1130"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('LA') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d378881e91-false-d379159e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1129"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d378881e107-false-d379173e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1128"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.288-2023-02-13T110318.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator (Erog)): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1127"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1126"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1125"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1124"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1122"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1121"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1120"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1119"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1118"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1117"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1116"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1114"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1112"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1111"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1110"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1108"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1107"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1106"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1104"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1102"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1101"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1100"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d379238e572-false-d380929e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1099"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTHEN') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): The value for typeCode SHALL be 'AUTHEN'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d379238e595-false-d381015e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1098"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d379238e605-false-d381029e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1097"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or string-length(@code)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or string-length(@code)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.289-2023-02-13T111835.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticator (Erog)): Attribute @code SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1096"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1095"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1094"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1093"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1091"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1090"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1089"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1088"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1087"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1086"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1085"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1083"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1081"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1080"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1079"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1077"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1076"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1075"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1073"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1071"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1070"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1069"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d381097e572-false-d382768e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
                 priority="1068"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@typeCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): attribute @typeCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d381097e578-false-d382841e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1067"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d381097e600-false-d382912e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]"
                 priority="1066"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@classCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@classCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): attribute @classCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG'] is mandatory [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.290-2023-02-13T112618.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant (Erog)): element hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']"
                 priority="1065"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']/hl7:id"
                 priority="1064"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']/hl7:telecom"
                 priority="1063"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']/hl7:addr"
                 priority="1062"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1060"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.13.1.1'][@extension = '1.0']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[not(@nullFlavor)][@classCode][hl7:scopingOrganization[@classCode = 'ORG']]/hl7:scopingOrganization[not(@nullFlavor)][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1058"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute