<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                xmlns:lab="urn:oid:1.3.6.1.4.1.19376.1.3.2"
                xmlns:ihe="urn:ihe:pcc:hl7v3"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
               method="xml"
               omit-xml-declaration="no"
               standalone="yes"
               indent="yes"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <svrl:schematron-output xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                              title="Schematron file for transaction Profilo Sanitario Sintetico (2.16.840.1.113883.3.1937.777.63.4.32 2024-02-28T00:00:00)"
                              schemaVersion="">
         <xsl:comment>
            <xsl:value-of select="$archiveDirParameter"/>   
		 <xsl:value-of select="$archiveNameParameter"/>  
		 <xsl:value-of select="$fileNameParameter"/>  
		 <xsl:value-of select="$fileDirParameter"/>
         </xsl:comment>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="hl7"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:v3" prefix="cda"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/2001/XMLSchema" prefix="xs"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:hl7-org:sdtc" prefix="sdtc"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pharm:medication" prefix="pharm"/>
         <svrl:ns-prefix-in-attribute-values uri="http://www.w3.org/XML/1998/namespace" prefix="xml"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:oid:1.3.6.1.4.1.19376.1.3.2" prefix="lab"/>
         <svrl:ns-prefix-in-attribute-values uri="urn:ihe:pcc:hl7v3" prefix="ihe"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M11"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="name">CDAClinicalDocument</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M12"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915</xsl:attribute>
            <xsl:attribute name="name">Profilo_Sanitario_Sintetico</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M13"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915-closed</xsl:attribute>
            <xsl:attribute name="name">Profilo_Sanitario_Sintetico</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M14"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.415-2024-01-09T152507</xsl:attribute>
            <xsl:attribute name="name">Allergie e Intolleranze PSS</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M30"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.416-2024-01-09T155318</xsl:attribute>
            <xsl:attribute name="name">Allergie o Intolleranze (act) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M31"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.419-2024-01-09T174603</xsl:attribute>
            <xsl:attribute name="name">Terapie Farmacologiche (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M32"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.420-2024-01-09T175802</xsl:attribute>
            <xsl:attribute name="name">Terapie Farmacologiche - Presenza Terapia (substanceAdministration) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M33"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.423-2024-01-10T113755</xsl:attribute>
            <xsl:attribute name="name">Terapie Farmacologiche - Assenza Terapia (substanceAdministration) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M34"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.424-2024-01-10T121315</xsl:attribute>
            <xsl:attribute name="name">Vaccinazioni - (substanceAdministration) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M35"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.425-2024-01-10T121954</xsl:attribute>
            <xsl:attribute name="name">Vaccinazioni (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M36"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.429-2024-01-10T172613</xsl:attribute>
            <xsl:attribute name="name">Vaccinazioni - Periodo Copertura (observation) PSS</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M37"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.431-2024-01-11T152622</xsl:attribute>
            <xsl:attribute name="name">Lista dei Problemi - Problema (act) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M38"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.438-2024-01-12T173004</xsl:attribute>
            <xsl:attribute name="name">Lista dei Problemi - Riferimenti interni (act) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M39"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.457-2024-01-16T175251</xsl:attribute>
            <xsl:attribute name="name">PianidiCura - Dettagli (Procedure) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M40"/>
         <svrl:active-pattern>
            <xsl:attribute name="document">
               <xsl:value-of select="document-uri(/)"/>
            </xsl:attribute>
            <xsl:attribute name="id">template-2.16.840.1.113883.3.1937.777.63.10.459-2024-01-16T183143</xsl:attribute>
            <xsl:attribute name="name">PianiDiCura - Dettaglii (Act) (PSS)</xsl:attribute>
            <xsl:apply-templates/>
         </svrl:active-pattern>
         <xsl:apply-templates select="/" mode="M41"/>
      </svrl:schematron-output>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Schematron file for transaction Profilo Sanitario Sintetico (2.16.840.1.113883.3.1937.777.63.4.32 2024-02-28T00:00:00)</svrl:text>
   <xsl:param name="scenariolabel" select="'2.16.840.1.113883.3.1937.777.63.4.32'"/>

   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M11"/>
   <xsl:template match="@*|node()" priority="-2" mode="M11">
      <xsl:apply-templates select="*" mode="M11"/>
   </xsl:template>

   <!--PATTERN CDAClinicalDocument-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">CDAClinicalDocument</svrl:text>

	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M12">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">warning</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M12"/>
   <xsl:template match="@*|node()" priority="-2" mode="M12">
      <xsl:apply-templates select="*" mode="M12"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915Profilo_Sanitario_Sintetico-->
   <svrl:text xmlns:svrl="http://purl.oclc.org/dsdl/svrl">Profilo_Sanitario_Sintetico</svrl:text>

	  <!--RULE d44e59205-false-d4547772e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]"
                 priority="1661"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('DOCCLIN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@moodCode) = ('EVN') or not(@moodCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
                  <xsl:value-of select="@moodCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode[@code = 'IT']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:realmCode[@code = 'IT']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:realmCode[@code = 'IT'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:realmCode[@code = 'IT']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:realmCode[@code = 'IT']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:realmCode[@code = 'IT'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '60591-5']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@code = '60591-5']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:code[@code = '60591-5'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@code = '60591-5']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@code = '60591-5']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:code[@code = '60591-5'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:title) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:title appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:effectiveTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:languageCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:languageCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:languageCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:setId) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:setId appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:versionNumber) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:versionNumber appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:author[hl7:assignedAuthor] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[hl7:assignedAuthor]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:author[hl7:assignedAuthor]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:author[hl7:assignedAuthor] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:dataEnterer[hl7:assignedEntity]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:dataEnterer[hl7:assignedEntity] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:authenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:authenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:authenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:documentationOf[hl7:serviceEvent] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:documentationOf[hl7:serviceEvent]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:documentationOf[hl7:serviceEvent] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:structuredBody] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:component[hl7:structuredBody]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): element hl7:component[hl7:structuredBody] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59217-false-d4548539e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:realmCode[@code = 'IT']"
                 priority="1660"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('IT')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('IT')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for code SHALL be 'IT'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59233-false-d4548551e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1659"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.1.3')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('POCD_MT000040UV02')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59254-false-d4548570e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']"
                 priority="1658"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.1.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.10.1.4.1.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.4.1.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('1.5')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@extension) = ('1.5')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for extension SHALL be '1.5'. Found: "<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59274-false-d4548588e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:id"
                 priority="1657"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59310-false-d4548610e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:code[@code = '60591-5']"
                 priority="1656"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('60591-5')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@code) = ('60591-5')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for code SHALL be '60591-5'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.6.1') or not(@codeSystem)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Profilo Sanitario Sintetico') or not(@displayName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@displayName) = ('Profilo Sanitario Sintetico') or not(@displayName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for displayName SHALL be 'Profilo Sanitario Sintetico'. Found: "<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59329-false-d4548644e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:code[@code = '60591-5']/hl7:translation"
                 priority="1655"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59393-false-d4548679e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:effectiveTime"
                 priority="1654"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59416-false-d4548695e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @code = 'V' or @code = 'N']"
                 priority="1653"
                 mode="M13">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='V' and @displayName='Very Restricted') or (@code='N' and @displayName='Normal') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="@nullFlavor or (@code='V' and @displayName='Very Restricted') or (@code='N' and @displayName='Normal') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The element value SHALL be one of 'code 'V' displayName='Very Restricted' or code 'N' displayName='Normal' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('HL7 Confidentiality')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59448-false-d4548734e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:languageCode"
                 priority="1652"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59471-false-d4548747e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:setId"
                 priority="1651"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d44e59507-false-d4548768e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:versionNumber"
                 priority="1650"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.391-2023-12-20T153915.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(Profilo_Sanitario_Sintetico): Attribute @value is not a valid int number <xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>
               </svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e13-false-d4548877e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]"
                 priority="1649"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('RCT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:patientRole[hl7:patient] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[hl7:patient]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patientRole[hl7:patient]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:patientRole[hl7:patient] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e25-false-d4549091e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
                 priority="1648"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PAT') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:addr is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e35-false-d4549229e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
                 priority="1647"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr"
                 priority="1646"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:censusTract is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:postalCode is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.412-2024-01-08T161555.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr PSS_v2): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e200-false-d4549405e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
                 priority="1644"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e226-false-d4549490e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]"
                 priority="1643"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:birthTime is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:birthTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthPlace[hl7:place]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthPlace[hl7:place]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:birthPlace[hl7:place] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthPlace[hl7:place]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:birthPlace[hl7:place]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:birthPlace[hl7:place] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e232-false-d4549599e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:name"
                 priority="1642"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e274-false-d4549640e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']"
                 priority="1641"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.1' AdministrativeGender (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.1')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.5.1')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e320-false-d4549735e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian"
                 priority="1640"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:guardianPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:guardianPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e322-false-d4549824e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:id"
                 priority="1639"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e331-false-d4549845e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:code"
                 priority="1638"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:addr"
                 priority="1637"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianPerson"
                 priority="1636"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianPerson/hl7:name"
                 priority="1634"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']"
                 priority="1633"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1632"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1631"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1630"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1628"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1626"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1625"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1624"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1622"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1621"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1620"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1618"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1616"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1615"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1614"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e374-false-d4551296e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]"
                 priority="1613"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or string-length(@classCode) &gt; 0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or string-length(@classCode) &gt; 0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @classCode SHALL be of data type 'set_cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:place is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:place) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:place appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4548775e387-false-d4551331e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]/hl7:place"
                 priority="1612"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PLC') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:addr[hl7:country] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr[hl7:country]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:addr[hl7:country]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): element hl7:addr[hl7:country] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1']]/hl7:birthPlace[hl7:place]/hl7:place/hl7:addr[hl7:country]"
                 priority="1611"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.743-2025-07-24T145313.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AddressBirthPlace (PSS)): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']"
                 priority="1610"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.411-2024-01-08T151919.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA recordTarget (PSS)V2): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1608"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1607"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1606"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1604"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1602"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1601"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1600"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1598"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1597"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1596"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1594"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1592"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1591"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1590"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4551523e419-false-d4552668e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]"
                 priority="1589"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4551523e440-false-d4552806e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
                 priority="1588"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:telecom is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:assignedPerson is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4551523e471-false-d4552906e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
                 priority="1587"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4551523e502-false-d4552927e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.77.22.11.13']"
                 priority="1586"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.51-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.51-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.51' assignedAuthorCode_PSSIT (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.13')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@codeSystem) = ('2.16.840.1.113883.2.9.77.22.11.13')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.77.22.11.13'. Found: "<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:addr"
                 priority="1585"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4551523e533-false-d4553114e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:telecom"
                 priority="1583"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson"
                 priority="1582"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PSN') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.413-2024-01-09T093932.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA author PSS_v2): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:assignedPerson/hl7:name"
                 priority="1580"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1579"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1578"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1577"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1576"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1574"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1572"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1571"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1570"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1568"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1567"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1566"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1564"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1562"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1561"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1560"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4553318e408-false-d4554458e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]"
                 priority="1559"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('ENT') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('ENT') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): The value for typeCode SHALL be 'ENT'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4553318e420-false-d4554537e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:time"
                 priority="1558"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.402-2023-12-21T145804.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA dataEntererPSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1557"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1556"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1555"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1554"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1552"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1551"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1550"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1549"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1548"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1547"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1546"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1544"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1542"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1541"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1540"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1538"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1537"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1536"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1534"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1532"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1531"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:dataEnterer[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1530"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4554604e558-false-d4556251e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant"
                 priority="1529"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4554604e560-false-d4556279e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]"
                 priority="1528"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedPerson[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:relatedPerson[hl7:name]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:relatedPerson[hl7:name] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4554604e571-false-d4556312e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']"
                 priority="1527"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@root) = ('2.16.840.1.113883.2.9.4.3.2')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.2'. Found: "<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assignedAuthorityName) or string-length(@assignedAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assignedAuthorityName) or string-length(@assignedAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): Attribute @assignedAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assignedAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4554604e580-false-d4556336e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:relatedPerson[hl7:name]"
                 priority="1526"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.404-2023-12-21T154622.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA informant PSS): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:informant/hl7:relatedEntity[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.2']]/hl7:relatedPerson[hl7:name]/hl7:name"
                 priority="1525"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556369e55-false-d4556463e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]"
                 priority="1524"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('CST') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556369e65-false-d4556513e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]"
                 priority="1523"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[hl7:name]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization[hl7:name]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:representedCustodianOrganization[hl7:name] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[hl7:name]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedCustodianOrganization[hl7:name]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:representedCustodianOrganization[hl7:name] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556369e75-false-d4556563e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]"
                 priority="1522"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556369e81-false-d4556620e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:id"
                 priority="1521"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:name"
                 priority="1520"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556369e121-false-d4556730e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:telecom"
                 priority="1519"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or string-length(@value)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization[hl7:name]/hl7:addr"
                 priority="1518"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.405-2023-12-21T162532.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA custodian PSS): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556772e81-false-d4556960e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1516"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('LA') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556772e93-false-d4557050e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1515"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4556772e122-false-d4557064e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1514"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.406-2023-12-21T170447.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA legalAuthenticator PSS): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1513"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1512"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1511"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1510"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1508"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1507"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1506"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1505"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1504"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1503"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1502"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1500"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1498"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1497"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1496"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1494"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1493"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1492"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1490"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1488"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1487"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1486"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4557129e574-false-d4558820e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1485"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTHEN') or not(@typeCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): The value for typeCode SHALL be 'AUTHEN'. Found: "<xsl:text/>
                  <xsl:value-of select="@typeCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:time is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:signatureCode[@code = 'S'] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:assignedEntity is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedEntity) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): element hl7:assignedEntity appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4557129e584-false-d4558906e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1484"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@value">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): attribute @value SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
                  <xsl:value-of select="@value"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4557129e600-false-d4558920e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1483"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="string(@code) = ('S')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): The value for code SHALL be 'S'. Found: "<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or string-length(@code)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or string-length(@code)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.407-2023-12-21T172957.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA authenticatorPSS): Attribute @code SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1482"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ASSIGNED') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:id is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:addr) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:telecom) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:telecom) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:assignedPerson) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1481"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1480"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1479"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1477"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1476"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA person ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1475"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:given) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:given appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:family) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:family appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:prefix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:prefix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:suffix) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA name ): element hl7:suffix appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']"
                 priority="1474"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id"
                 priority="1473"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom"
                 priority="1472"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr"
                 priority="1471"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1469"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1467"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1466"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1465"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('ORG')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:id) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:id appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:name) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:name appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:asOrganizationPartOf) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id"
                 priority="1463"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom"
                 priority="1462"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr"
                 priority="1461"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:country) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:country appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:state) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:state appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:county) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:county appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:city) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:city appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:postalCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:postalCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:streetAddressLine) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:censusTract) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA addr): element hl7:censusTract appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@use">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): attribute @use SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf"
                 priority="1459"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:code) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:statusCode) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:effectiveTime) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART') or not(@classCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART') or not(@classCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@determinerCode"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id"
                 priority="1457"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@root">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @root SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@root"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@extension">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @extension SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@extension) or string-length(@extension)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@extension"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@assigningAuthorityName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code"
                 priority="1456"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@code">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @code SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
                  <xsl:value-of select="@code"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@codeSystem">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystem"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@displayName) or string-length(@displayName)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@displayName"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<xsl:text/>
                  <xsl:value-of select="@codeSystemVersion"/>
                  <xsl:text/>'</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']"
                 priority="1455"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@classCode) = ('PART')">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
                  <xsl:value-of select="@classCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M13"/>
   </xsl:template>

	  <!--RULE d4558988e572-false-d4560647e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.4.1.1'][@extension = '1.5']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
                 priority="1454"
                 mode="M13">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="@typeCode">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant PSS): attribute @typeCode SHALL be present.</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant PSS): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant PSS): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
                  <xsl:value-of select="@contextControlCode"/>
                  <xsl:text/>"</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl" test="count(hl7:time) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant PSS): element hl7:time appears too often [max 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &gt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[@classCode]) &gt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-12-21T173918.html</xsl:attribute>
               <xsl:attribute name="role">error</xsl:attribute>
               <xsl:attribute name="location">
                  <xsl:apply-templates select="." mode="schematron-select-full-path"/>
               </xsl:attribute>
               <svrl:text>(CDA participant PSS): element hl7:associatedEntity[@classCode] is required [min 1x].</svrl:text>
            </svrl:failed-assert>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &lt;= 1"/>
         <xsl:otherwise>
            <svrl:failed-assert xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
                                test="count(hl7:associatedEntity[@classCode]) &lt;= 1">
               <xsl:attribute name="see">https://hl7itig.art-decor.pub/hl7itig-html-20251023T100718/tmp-2.16.840.1.113883.3.1937.777.63.10.408-2023-1