<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.3.1937.777.63.10.355
Name: Condizioni sanitarie a rischio (VACC)
Description: Template CDA Observation (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552">
   <title>Condizioni sanitarie a rischio (VACC)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]"
         id="d44e2467-false-d23815e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]) &gt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]) &lt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]"
         id="d44e2477-false-d23832e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@classCode) = ('OBS') or not(@classCode)">(Condizioni sanitarie a rischio (VACC)): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@moodCode) = ('EVN')">(Condizioni sanitarie a rischio (VACC)): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']) &gt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']) &lt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &gt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]) &lt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']]) &gt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="count(hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']]) &lt;= 1">(Condizioni sanitarie a rischio (VACC)): element hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']"
         id="d44e2495-false-d23884e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.11.4.6')">(Condizioni sanitarie a rischio (VACC)): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.11.4.6'. Found: "<value-of select="@root"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:code[(@code = '59785-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d44e2500-false-d23896e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@code) = ('59785-6')">(Condizioni sanitarie a rischio (VACC)): The value for code SHALL be '59785-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Condizioni sanitarie a rischio (VACC)): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Condizioni sanitarie a rischio (VACC)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Condizioni sanitarie a rischio (VACC)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:statusCode[@code = 'completed' or @code = doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/*/@code]"
         id="d44e2526-false-d23921e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.15933-DYNAMIC.xml')//valueSet[1]/conceptList/concept[@code = $theCode] or completeCodeSystem)">(Condizioni sanitarie a rischio (VACC)): The element value SHALL be one of '2.16.840.1.113883.1.11.15933 ActStatus (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="string(@code) = ('completed')">(Condizioni sanitarie a rischio (VACC)): The value for code SHALL be 'completed'. Found: "<value-of select="@code"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.355
Context: *[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']]
Item: (Condizioni sanitarie a rischio (VACC))
-->

   <rule fpi="RULC-1"
         context="*[hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]]/hl7:observation[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.11.4.6']]/hl7:value[[@codeSystem='2.16.840.1.113883.6.103' or @codeSystem='2.16.840.1.113883.2.9.6.1.56.1']]"
         id="d44e2533-false-d23939e0">
      <let name="xsiLocalName"
           value="if (contains(@xsi:type, ':')) then substring-after(@xsi:type,':') else @xsi:type"/>
      <let name="xsiLocalNS"
           value="if (contains(@xsi:type, ':')) then namespace-uri-for-prefix(substring-before(@xsi:type,':'),.) else namespace-uri-for-prefix('',.)"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="@nullFlavor or ($xsiLocalName='CD' and $xsiLocalNS='urn:hl7-org:v3')">(Condizioni sanitarie a rischio (VACC)): If an @xsi:type instruction is present it SHALL be valued "{urn:hl7-org:v3}:CD". Found "{<value-of select="namespace-uri-from-QName(resolve-QName(@xsi:type,.))"/>}:<value-of select="local-name-from-QName(resolve-QName(@xsi:type,.))"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="@code">(Condizioni sanitarie a rischio (VACC)): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Condizioni sanitarie a rischio (VACC)): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="@codeSystem">(Condizioni sanitarie a rischio (VACC)): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Condizioni sanitarie a rischio (VACC)): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Condizioni sanitarie a rischio (VACC)): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251017T162324/tmp-2.16.840.1.113883.3.1937.777.63.10.355-2023-07-27T122552.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Condizioni sanitarie a rischio (VACC)): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
</pattern>
