<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Name: Referto di Televisita
Description: 
                    Referto di Televisita (TL)    
            
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334">
   <title>Referto di Televisita</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]"
         id="d44e1859-false-d88174e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(Referto di Televisita): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Televisita): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:realmCode) &gt;= 1">(Referto di Televisita): element hl7:realmCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:realmCode) &lt;= 1">(Referto di Televisita): element hl7:realmCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &gt;= 1">(Referto di Televisita): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']) &lt;= 1">(Referto di Televisita): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']) &gt;= 1">(Referto di Televisita): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 '] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:id) &gt;= 1">(Referto di Televisita): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:id) &lt;= 1">(Referto di Televisita): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &gt;= 1">(Referto di Televisita): element hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']) &lt;= 1">(Referto di Televisita): element hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:title) &lt;= 1">(Referto di Televisita): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:effectiveTime) &gt;= 1">(Referto di Televisita): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:effectiveTime) &lt;= 1">(Referto di Televisita): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &gt;= 1">(Referto di Televisita): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]) &lt;= 1">(Referto di Televisita): element hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:languageCode) &lt;= 1">(Referto di Televisita): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:setId) &lt;= 1">(Referto di Televisita): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:versionNumber) &lt;= 1">(Referto di Televisita): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &gt;= 1">(Referto di Televisita): element hl7:recordTarget[hl7:patientRole] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:recordTarget[hl7:patientRole]) &lt;= 1">(Referto di Televisita): element hl7:recordTarget[hl7:patientRole] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:author[hl7:assignedAuthor]) &gt;= 1">(Referto di Televisita): element hl7:author[hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:author[hl7:assignedAuthor]) &lt;= 1">(Referto di Televisita): element hl7:author[hl7:assignedAuthor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]) &lt;= 1">(Referto di Televisita): element hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &gt;= 1">(Referto di Televisita): element hl7:custodian[hl7:assignedCustodian] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:custodian[hl7:assignedCustodian]) &lt;= 1">(Referto di Televisita): element hl7:custodian[hl7:assignedCustodian] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:informationRecipient[hl7:intendedRecipient]) &lt;= 1">(Referto di Televisita): element hl7:informationRecipient[hl7:intendedRecipient] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &gt;= 1">(Referto di Televisita): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(Referto di Televisita): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:inFulfillmentOf[hl7:order]) &gt;= 1">(Referto di Televisita): element hl7:inFulfillmentOf[hl7:order] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(Referto di Televisita): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &gt;= 1">(Referto di Televisita): element hl7:componentOf[hl7:encompassingEncounter] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter]) &lt;= 1">(Referto di Televisita): element hl7:componentOf[hl7:encompassingEncounter] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(Referto di Televisita): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:realmCode
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:realmCode"
         id="d44e1862-false-d89059e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@code">(Referto di Televisita): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Referto di Televisita): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = ' POCD_MT000040UV02']"
         id="d44e1882-false-d89073e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(Referto di Televisita): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(Referto di Televisita): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']"
         id="d44e1896-false-d89092e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.16.1.1')">(Referto di Televisita): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.16.1.1'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@extension">(Referto di Televisita): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Referto di Televisita): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:id
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:id"
         id="d44e1919-false-d89113e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@root">(Referto di Televisita): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Televisita): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@extension">(Referto di Televisita): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Referto di Televisita): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@assigningAuthorityName">(Referto di Televisita): attribute @assigningAuthorityName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Referto di Televisita): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']"
         id="d44e1947-false-d89137e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@nullFlavor or (@codeSystem='2.16.840.1.113883.6.1')">(Referto di Televisita): The element value SHALL be one of 'codeSystem '2.16.840.1.113883.6.1''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@code) = ('75496-0')">(Referto di Televisita): The value for code SHALL be '75496-0'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Referto di Televisita): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@codeSystemName) = ('LOINC')">(Referto di Televisita): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Televisita): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Televisita): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']/hl7:translation
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:code[(@code = '75496-0' and @codeSystem = '2.16.840.1.113883.6.1') or @codeSystem = '2.16.840.1.113883.6.1']/hl7:translation"
         id="d44e1963-false-d89170e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@code">(Referto di Televisita): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Referto di Televisita): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@codeSystem">(Referto di Televisita): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Referto di Televisita): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@codeSystemName">(Referto di Televisita): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Referto di Televisita): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Referto di Televisita): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:title
Item: (Referto di Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:effectiveTime
Item: (Referto di Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:confidentialityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or (@code = 'N' and @codeSystem = '2.16.840.1.113883.5.25') or (@code = 'V' and @codeSystem = '2.16.840.1.113883.5.25') or @nullFlavor]"
         id="d44e1994-false-d89215e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="@nullFlavor or (@code='N' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Normal' and @codeSystemName='HL7 Confidentiality') or (@code='V' and @codeSystem='2.16.840.1.113883.5.25' and @displayName='Very Restricted' and @codeSystemName='HL7 Confidentiality') or exists(doc('include/voc-2.16.840.1.113883.1.11.16926-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(Referto di Televisita): The element value SHALL be one of 'code 'N' codeSystem '2.16.840.1.113883.5.25' displayName='Normal' codeSystemName='HL7 Confidentiality' or code 'V' codeSystem '2.16.840.1.113883.5.25' displayName='Very Restricted' codeSystemName='HL7 Confidentiality' or 2.16.840.1.113883.1.11.16926 x_BasicConfidentialityKind (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:languageCode
Item: (Referto di Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:setId
Item: (Referto di Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:versionNumber
Item: (Referto di Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]"
         id="d89260e17-false-d89362e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@typeCode) = ('RCT') or not(@typeCode)">(CDA recordTargetTele): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA recordTargetTele): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:patientRole[hl7:patient]) &gt;= 1">(CDA recordTargetTele): element hl7:patientRole[hl7:patient] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:patientRole[hl7:patient]) &lt;= 1">(CDA recordTargetTele): element hl7:patientRole[hl7:patient] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]"
         id="d89260e38-false-d89576e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@classCode) = ('PAT') or not(@classCode)">(CDA recordTargetTele): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTargetTele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA recordTargetTele): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA recordTargetTele): element hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTargetTele): element hl7:providerOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:id"
         id="d89260e48-false-d89714e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@root">(CDA recordTargetTele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTargetTele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@extension">(CDA recordTargetTele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTargetTele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA recordTargetTele): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA recordTargetTele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr">
      <extends rule="d89768e0-false-d89774e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@use">(CDA recordTargetTele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetTele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr
Item: (CDA addrTEL)
-->
   <rule fpi="RULC-1" id="d89768e0-false-d89774e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:country) &gt;= 1">(CDA addrTEL): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:country) &lt;= 1">(CDA addrTEL): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:state) &gt;= 1">(CDA addrTEL): element hl7:state is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:state) &lt;= 1">(CDA addrTEL): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:county) &gt;= 1">(CDA addrTEL): element hl7:county is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:county) &lt;= 1">(CDA addrTEL): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:city) &lt;= 1">(CDA addrTEL): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addrTEL): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addrTEL): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:censusTract) &gt;= 1">(CDA addrTEL): element hl7:censusTract is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.610-2025-05-21T144714.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addrTEL): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:country
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:state
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:county
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:city
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:postalCode
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:streetAddressLine
Item: (CDA addrTEL)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.610
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:addr/hl7:censusTract
Item: (CDA addrTEL)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:telecom"
         id="d89260e258-false-d89888e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@use">(CDA recordTargetTele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA recordTargetTele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@value">(CDA recordTargetTele): attribute @value SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d89260e291-false-d89973e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTargetTele): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTele): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:name) &gt;= 1">(CDA recordTargetTele): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetTele): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA recordTargetTele): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA recordTargetTele): element hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:birthTime) &gt;= 1">(CDA recordTargetTele): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:birthTime) &lt;= 1">(CDA recordTargetTele): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:birthplace[hl7:place]) &gt;= 1">(CDA recordTargetTele): element hl7:birthplace[hl7:place] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:birthplace[hl7:place]) &lt;= 1">(CDA recordTargetTele): element hl7:birthplace[hl7:place] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d89260e303-false-d90084e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:given) &gt;= 1">(CDA recordTargetTele): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:family) &gt;= 1">(CDA recordTargetTele): element hl7:family is required [min 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d89260e336-false-d90123e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA recordTargetTele): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@code">(CDA recordTargetTele): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@codeSystem">(CDA recordTargetTele): attribute @codeSystem SHALL be present.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian"
         id="d89260e407-false-d90203e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:id) &gt;= 1">(CDA recordTargetTele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:code) &lt;= 1">(CDA recordTargetTele): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:guardianPerson) &gt;= 1">(CDA recordTargetTele): element hl7:guardianPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:guardianPerson) &lt;= 1">(CDA recordTargetTele): element hl7:guardianPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &gt;= 1">(CDA recordTargetTele): element hl7:guardianOrganization[@classCode = 'ORG'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG']) &lt;= 1">(CDA recordTargetTele): element hl7:guardianOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:id"
         id="d89260e415-false-d90295e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@root">(CDA recordTargetTele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA recordTargetTele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@extension">(CDA recordTargetTele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA recordTargetTele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:code"
         id="d89260e424-false-d90313e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@code">(CDA recordTargetTele): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="@codeSystem">(CDA recordTargetTele): attribute @codeSystem SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:telecom
Item: (CDA recordTargetTele)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA recordTargetTele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson">
      <extends rule="d90497e0-false-d90509e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA recordTargetTele): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTele): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d90497e0-false-d90509e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d90827e0-false-d90833e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d90827e0-false-d90833e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d90991e0-false-d91027e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d90991e0-false-d91027e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d91197e0-false-d91201e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d91197e0-false-d91201e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d91367e0-false-d91373e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d91367e0-false-d91373e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d91531e0-false-d91567e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d91531e0-false-d91567e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian/hl7:guardianOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]"
         id="d89260e468-false-d91751e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@classCode) = ('BIRTHPL') or not(@classCode)">(CDA recordTargetTele): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:place) &gt;= 1">(CDA recordTargetTele): element hl7:place is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:place) &lt;= 1">(CDA recordTargetTele): element hl7:place appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place
Item: (CDA recordTargetTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place"
         id="d89260e506-false-d91787e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA recordTargetTele): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA recordTargetTele): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:name) &lt;= 1">(CDA recordTargetTele): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:addr[hl7:country]) &gt;= 1">(CDA recordTargetTele): element hl7:addr[hl7:country] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="count(hl7:addr[hl7:country]) &lt;= 1">(CDA recordTargetTele): element hl7:addr[hl7:country] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:name
Item: (CDA recordTargetTele)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA recordTargetTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]
Item: (CDA AddressBirthPlaceTele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:country) &gt;= 1">(CDA AddressBirthPlaceTele): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:country) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:state) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:county) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:city) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.747-2025-07-24T172414.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA AddressBirthPlaceTele): element hl7:postalCode appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:country
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:state
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:county
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:city
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:censusTract
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.747
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:patient[hl7:administrativeGenderCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[hl7:place]/hl7:place/hl7:addr[hl7:country]/hl7:postalCode
Item: (CDA AddressBirthPlaceTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.609
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA recordTargetTele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']">
      <extends rule="d91989e0-false-d91993e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDA recordTargetTele): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.609-2025-05-21T144244.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA recordTargetTele): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d91989e0-false-d91993e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d92159e0-false-d92165e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d92159e0-false-d92165e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d92323e0-false-d92359e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d92323e0-false-d92359e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d92529e0-false-d92533e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d92529e0-false-d92533e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d92699e0-false-d92705e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d92699e0-false-d92705e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d92863e0-false-d92899e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d92863e0-false-d92899e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:recordTarget[hl7:patientRole]/hl7:patientRole[hl7:patient]/hl7:providerOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]
Item: (CDA author Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]"
         id="d91979e409-false-d93124e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="string(@typeCode) = ('AUT') or not(@typeCode)">(CDA author Televisita): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA author Televisita): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA author Televisita): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:time) &gt;= 1">(CDA author Televisita): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:time) &lt;= 1">(CDA author Televisita): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:assignedAuthor) &gt;= 1">(CDA author Televisita): element hl7:assignedAuthor is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:assignedAuthor) &lt;= 1">(CDA author Televisita): element hl7:assignedAuthor appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:functionCode
Item: (CDA author Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:time
Item: (CDA author Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor
Item: (CDA author Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor"
         id="d91979e426-false-d93274e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA author Televisita): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:id) &gt;= 1">(CDA author Televisita): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:code) &lt;= 1">(CDA author Televisita): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA author Televisita): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA author Televisita): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id
Item: (CDA author Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:id"
         id="d91979e445-false-d93366e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="@root">(CDA author Televisita): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA author Televisita): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="@extension">(CDA author Televisita): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA author Televisita): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA author Televisita): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:code
Item: (CDA author Televisita)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA author Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr">
      <extends rule="d93428e0-false-d93434e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="@use">(CDA author Televisita): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author Televisita): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d93428e0-false-d93434e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom
Item: (CDA author Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:telecom"
         id="d91979e477-false-d93546e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="@use">(CDA author Televisita): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA author Televisita): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA author Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson">
      <extends rule="d93594e0-false-d93606e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="string(@classCode) = ('PSN') or not(@classCode)">(CDA author Televisita): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.630-2025-05-26T185548.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA author Televisita): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1" id="d93594e0-false-d93606e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.630
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA author Televisita)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d93924e0-false-d93930e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d93924e0-false-d93930e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d94088e0-false-d94124e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d94088e0-false-d94124e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d94294e0-false-d94298e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d94294e0-false-d94298e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d94464e0-false-d94470e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d94464e0-false-d94470e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d94628e0-false-d94664e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d94628e0-false-d94664e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:author[hl7:assignedAuthor]/hl7:assignedAuthor/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.639
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]
Item: (CDA dataEnterer Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]"
         id="d93750e397-false-d94890e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="string(@typeCode) = ('ENT')">(CDA dataEnterer Tele): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="string(@contextControlCode) = ('OP')">(CDA dataEnterer Tele): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="count(hl7:time) &gt;= 1">(CDA dataEnterer Tele): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="count(hl7:time) &lt;= 1">(CDA dataEnterer Tele): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA dataEnterer Tele): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA dataEnterer Tele): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.639
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time
Item: (CDA dataEnterer Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time"
         id="d93750e409-false-d94971e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="@value">(CDA dataEnterer Tele): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.639-2025-05-27T113024.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDA dataEnterer Tele): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.639
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA dataEnterer Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d95273e0-false-d95279e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d95273e0-false-d95279e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d95762e0-false-d95768e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d95762e0-false-d95768e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d95926e0-false-d95962e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d95926e0-false-d95962e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d96132e0-false-d96136e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d96132e0-false-d96136e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d96302e0-false-d96308e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d96302e0-false-d96308e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d96466e0-false-d96502e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d96466e0-false-d96502e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.640
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]
Item: (CDA custodian Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]"
         id="d95038e564-false-d96697e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.640-2025-05-27T113602.html"
              test="string(@typeCode) = ('CST') or not(@typeCode)">(CDA custodian Televisita): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.640-2025-05-27T113602.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &gt;= 1">(CDA custodian Televisita): element hl7:assignedCustodian[hl7:representedCustodianOrganization] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.640-2025-05-27T113602.html"
              test="count(hl7:assignedCustodian[hl7:representedCustodianOrganization]) &lt;= 1">(CDA custodian Televisita): element hl7:assignedCustodian[hl7:representedCustodianOrganization] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.640
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA custodian Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]">
      <extends rule="d96763e0-false-d96767e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.640-2025-05-27T113602.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA custodian Televisita): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]
Item: (CDA assignedCustodian )
-->
   <rule fpi="RULC-1" id="d96763e0-false-d96767e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &gt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.75-2022-07-07T132020.html"
              test="count(hl7:representedCustodianOrganization) &lt;= 1">(CDA assignedCustodian ): element hl7:representedCustodianOrganization appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.75
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (CDA assignedCustodian )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@classCode) = ('ORG') or not(@classCode)">(custodianOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(custodianOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:id) &gt;= 1">(custodianOrganization): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &gt;= 1">(custodianOrganization): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:name) &lt;= 1">(custodianOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="count(hl7:addr) &lt;= 1">(custodianOrganization): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@root">(custodianOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(custodianOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@extension">(custodianOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@extension) or string-length(@extension)&gt;0">(custodianOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(custodianOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:name
Item: (custodianOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.260
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (custodianOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr">
      <extends rule="d96971e0-false-d96977e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="@use">(custodianOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.260-2022-10-11T093833.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(custodianOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d96971e0-false-d96977e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:custodian[hl7:assignedCustodian]/hl7:assignedCustodian[hl7:representedCustodianOrganization]/hl7:representedCustodianOrganization/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]
Item: (CDA informationRecipient Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]"
         id="d96756e142-false-d97138e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="string(@typeCode) = ('PRCP') or not(@typeCode)">(CDA informationRecipient Tele): The value for typeCode SHALL be 'PRCP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="count(hl7:intendedRecipient) &gt;= 1">(CDA informationRecipient Tele): element hl7:intendedRecipient is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="count(hl7:intendedRecipient) &lt;= 1">(CDA informationRecipient Tele): element hl7:intendedRecipient appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient
Item: (CDA informationRecipient Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient"
         id="d96756e152-false-d97254e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA informationRecipient Tele): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="count(hl7:addr) &lt;= 1">(CDA informationRecipient Tele): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="count(hl7:informationRecipient) &lt;= 1">(CDA informationRecipient Tele): element hl7:informationRecipient appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="count(hl7:receivedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA informationRecipient Tele): element hl7:receivedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id
Item: (CDA informationRecipient Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:id"
         id="d96756e180-false-d97340e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="@root">(CDA informationRecipient Tele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA informationRecipient Tele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="@extension">(CDA informationRecipient Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA informationRecipient Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA informationRecipient Tele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr">
      <extends rule="d97391e0-false-d97397e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="@use">(CDA informationRecipient Tele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient Tele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d97391e0-false-d97397e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom
Item: (CDA informationRecipient Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:telecom"
         id="d96756e197-false-d97509e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="@use">(CDA informationRecipient Tele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.728-2025-07-15T160445.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA informationRecipient Tele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA informationRecipient Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:informationRecipient/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.728
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA informationRecipient Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d97880e0-false-d97886e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d97880e0-false-d97886e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d98044e0-false-d98080e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d98044e0-false-d98080e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d98250e0-false-d98254e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d98250e0-false-d98254e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d98420e0-false-d98426e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d98420e0-false-d98426e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d98584e0-false-d98620e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d98584e0-false-d98620e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:informationRecipient[hl7:intendedRecipient]/hl7:intendedRecipient/hl7:receivedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.641
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDA legalAuthenticator Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d97706e396-false-d98847e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDA legalAuthenticator Tele): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA legalAuthenticator Tele): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:time) &gt;= 1">(CDA legalAuthenticator Tele): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:time) &lt;= 1">(CDA legalAuthenticator Tele): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDA legalAuthenticator Tele): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDA legalAuthenticator Tele): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA legalAuthenticator Tele): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA legalAuthenticator Tele): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.641
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDA legalAuthenticator Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.641
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDA legalAuthenticator Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d97706e427-false-d98946e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.641-2025-05-27T114148.html"
              test="string(@code) = ('S')">(CDA legalAuthenticator Tele): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.641
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA legalAuthenticator Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d99246e0-false-d99252e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d99246e0-false-d99252e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d99735e0-false-d99741e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d99735e0-false-d99741e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d99899e0-false-d99935e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d99899e0-false-d99935e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d100105e0-false-d100109e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d100105e0-false-d100109e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d100275e0-false-d100281e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d100275e0-false-d100281e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d100439e0-false-d100475e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d100439e0-false-d100475e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d99011e564-false-d100700e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@typeCode">(CDA participant Tele): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.10901-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant Tele): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.10901' ParticipationType (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDA participant Tele): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA participant Tele): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:time) &lt;= 1">(CDA participant Tele): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(CDA participant Tele): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(CDA participant Tele): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d99011e616-false-d100801e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA participant Tele): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@code">(CDA participant Tele): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant Tele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@codeSystem">(CDA participant Tele): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant Tele): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant Tele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant Tele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDA participant Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d99011e632-false-d100890e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@classCode">(CDA participant Tele): attribute @classCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@classCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@classCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.19313-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant Tele): The value for classCode SHALL be selected from value set '2.16.840.1.113883.1.11.19313' RoleClassAssociative (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:id) &gt;= 1">(CDA participant Tele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:code) &lt;= 1">(CDA participant Tele): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:associatedPerson) &lt;= 1">(CDA participant Tele): element hl7:associatedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="count(hl7:scopingOrganization[@classCode = 'ORG']) &lt;= 1">(CDA participant Tele): element hl7:scopingOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d99011e645-false-d100993e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@root">(CDA participant Tele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant Tele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@extension">(CDA participant Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA participant Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA participant Tele): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
         id="d99011e654-false-d101014e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA participant Tele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA participant Tele): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA participant Tele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA participant Tele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA participant Tele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr">
      <extends rule="d101067e0-false-d101073e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@use">(CDA participant Tele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant Tele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d101067e0-false-d101073e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (CDA participant Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
         id="d99011e675-false-d101185e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="@use">(CDA participant Tele): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.642-2025-05-27T114554.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA participant Tele): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA participant Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.642
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA participant Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d101556e0-false-d101562e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d101556e0-false-d101562e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d101720e0-false-d101756e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d101720e0-false-d101756e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d101926e0-false-d101930e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d101926e0-false-d101930e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d102096e0-false-d102102e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d102096e0-false-d102102e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d102260e0-false-d102296e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d102260e0-false-d102296e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.643
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]
Item: (CDA inFulfillmentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]"
         id="d101382e396-false-d102473e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="string(@typeCode) = ('FLFS') or not(@typeCode)">(CDA inFulfillmentOf Tele): The value for typeCode SHALL be 'FLFS'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:order) &gt;= 1">(CDA inFulfillmentOf Tele): element hl7:order is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:order) &lt;= 1">(CDA inFulfillmentOf Tele): element hl7:order appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.643
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order
Item: (CDA inFulfillmentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order"
         id="d101382e409-false-d102493e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA inFulfillmentOf Tele): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="string(@moodCode) = ('RQO') or not(@moodCode)">(CDA inFulfillmentOf Tele): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:id) &gt;= 1">(CDA inFulfillmentOf Tele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:id) &lt;= 1">(CDA inFulfillmentOf Tele): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:code) &lt;= 1">(CDA inFulfillmentOf Tele): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="count(hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA inFulfillmentOf Tele): element hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.643
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id
Item: (CDA inFulfillmentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:id"
         id="d101382e415-false-d102532e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="@root">(CDA inFulfillmentOf Tele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA inFulfillmentOf Tele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="@extension">(CDA inFulfillmentOf Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA inFulfillmentOf Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.643
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:code
Item: (CDA inFulfillmentOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.643
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA inFulfillmentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:inFulfillmentOf[hl7:order]/hl7:order/hl7:priorityCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d101382e441-false-d102561e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.643-2025-05-27T120418.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.5.7-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA inFulfillmentOf Tele): The element value SHALL be one of '2.16.840.1.113883.5.7 HL7  ActPriority (DYNAMIC)'.</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]
Item: (CDA documentationOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]"
         id="d102567e20-false-d102631e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="string(@typeCode) = ('DOC') or not(@typeCode)">(CDA documentationOf Tele): The value for typeCode SHALL be 'DOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDA documentationOf Tele): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDA documentationOf Tele): element hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDA documentationOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d102567e30-false-d102755e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="string(@classCode) = ('ACT') or not(@classCode)">(CDA documentationOf Tele): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA documentationOf Tele): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDA documentationOf Tele): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDA documentationOf Tele): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA documentationOf Tele): element hl7:effectiveTime appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:id
Item: (CDA documentationOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:id"
         id="d102567e47-false-d102844e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="@root">(CDA documentationOf Tele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA documentationOf Tele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="@extension">(CDA documentationOf Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA documentationOf Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDA documentationOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d102567e67-false-d102865e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA documentationOf Tele): The element value SHALL be one of '2.16.840.1.113883.2.9.5.1.4  Estensione Vocabolario ActCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="@code">(CDA documentationOf Tele): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA documentationOf Tele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.5.1.4')">(CDA documentationOf Tele): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.5.1.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA documentationOf Tele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA documentationOf Tele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:effectiveTime
Item: (CDA documentationOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]
Item: (CDA documentationOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]"
         id="d102567e83-false-d102954e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="@typeCode">(CDA documentationOf Tele): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(CDA documentationOf Tele): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:functionCode) &lt;= 1">(CDA documentationOf Tele): element hl7:functionCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:time) &lt;= 1">(CDA documentationOf Tele): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA documentationOf Tele): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.644-2025-05-27T120730.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA documentationOf Tele): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:functionCode
Item: (CDA documentationOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:time
Item: (CDA documentationOf Tele)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.644
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA documentationOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d103341e0-false-d103347e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d103341e0-false-d103347e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d103830e0-false-d103836e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d103830e0-false-d103836e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d103994e0-false-d104030e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d103994e0-false-d104030e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d104200e0-false-d104204e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d104200e0-false-d104204e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d104370e0-false-d104376e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d104370e0-false-d104376e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d104534e0-false-d104570e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d104534e0-false-d104570e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:documentationOf[hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]]/hl7:serviceEvent[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.5.1.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.2.9.5.1.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:performer[@typeCode][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDA relatedDocumentTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d103106e564-false-d104747e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="@typeCode">(CDA relatedDocumentTele): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA relatedDocumentTele): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDA relatedDocumentTele): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDA relatedDocumentTele): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDA relatedDocumentTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d103106e610-false-d104778e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDA relatedDocumentTele): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA relatedDocumentTele): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:id) &gt;= 1">(CDA relatedDocumentTele): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:code) &lt;= 1">(CDA relatedDocumentTele): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:text) &lt;= 1">(CDA relatedDocumentTele): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:setId) &lt;= 1">(CDA relatedDocumentTele): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDA relatedDocumentTele): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDA relatedDocumentTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d103106e616-false-d104824e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="@root">(CDA relatedDocumentTele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocumentTele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="@extension">(CDA relatedDocumentTele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA relatedDocumentTele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDA relatedDocumentTele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d103106e636-false-d104842e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="@code">(CDA relatedDocumentTele): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA relatedDocumentTele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="@codeSystem">(CDA relatedDocumentTele): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA relatedDocumentTele): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA relatedDocumentTele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.645-2025-05-27T120921.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA relatedDocumentTele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDA relatedDocumentTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDA relatedDocumentTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.645
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDA relatedDocumentTele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]"
         id="d104884e20-false-d104984e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDA componentOf Tele): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &gt;= 1">(CDA componentOf Tele): element hl7:encompassingEncounter[hl7:location] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:encompassingEncounter[hl7:location]) &lt;= 1">(CDA componentOf Tele): element hl7:encompassingEncounter[hl7:location] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]"
         id="d104884e30-false-d105190e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDA componentOf Tele): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDA componentOf Tele): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf Tele): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDA componentOf Tele): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA componentOf Tele): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:responsibleParty[hl7:assignedEntity]) &lt;= 1">(CDA componentOf Tele): element hl7:responsibleParty[hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:location[hl7:healthCareFacility]) &gt;= 1">(CDA componentOf Tele): element hl7:location[hl7:healthCareFacility] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:location[hl7:healthCareFacility]) &lt;= 1">(CDA componentOf Tele): element hl7:location[hl7:healthCareFacility] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:id"
         id="d104884e36-false-d105334e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="@root">(CDA componentOf Tele): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf Tele): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="@extension">(CDA componentOf Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf Tele): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d104884e73-false-d105358e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.13955-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf Tele): The element value SHALL be one of '2.16.840.1.113883.1.11.13955 ActEncounterCode (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf Tele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf Tele): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf Tele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf Tele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:effectiveTime
Item: (CDA componentOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]"
         id="d104884e106-false-d105444e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@typeCode) = ('RESP') or not(@typeCode)">(CDA componentOf Tele): The value for typeCode SHALL be 'RESP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDA componentOf Tele): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDA componentOf Tele): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA componentOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDA AssignedEntity ): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDA AssignedEntity ): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDA AssignedEntity ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:addr) &lt;= 1">(CDA AssignedEntity ): element hl7:addr appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:telecom) &lt;= 1">(CDA AssignedEntity ): element hl7:telecom appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDA AssignedEntity ): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG']) &lt;= 1">(CDA AssignedEntity ): element hl7:representedOrganization[@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDA AssignedEntity ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDA AssignedEntity ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA AssignedEntity ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA AssignedEntity ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDA AssignedEntity ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA AssignedEntity ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDA AssignedEntity ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA AssignedEntity ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA AssignedEntity ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA AssignedEntity ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d105802e0-false-d105808e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d105802e0-false-d105808e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDA AssignedEntity )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDA AssignedEntity ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA AssignedEntity ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDA person )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &gt;= 1">(CDA person ): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDA person ): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA person )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDA name )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDA name ): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDA name ): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDA name ): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDA name ): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDA name ): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDA name ): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDA name )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA AssignedEntity )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr">
      <extends rule="d106291e0-false-d106297e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d106291e0-false-d106297e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d106455e0-false-d106491e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d106455e0-false-d106491e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d106661e0-false-d106665e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d106661e0-false-d106665e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d106831e0-false-d106837e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d106831e0-false-d106837e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d106995e0-false-d107031e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d106995e0-false-d107031e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:responsibleParty[hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]"
         id="d104884e119-false-d107251e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(CDA componentOf Tele): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]) &gt;= 1">(CDA componentOf Tele): element hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]) &lt;= 1">(CDA componentOf Tele): element hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]"
         id="d104884e123-false-d107359e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@classCode) = ('SDLOC') or not(@classCode)">(CDA componentOf Tele): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]) &lt;= 1">(CDA componentOf Tele): element hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:location) &lt;= 1">(CDA componentOf Tele): element hl7:location appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]) &gt;= 1">(CDA componentOf Tele): element hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]) &lt;= 1">(CDA componentOf Tele): element hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.1.6']"
         id="d104884e154-false-d107444e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.1.6')">(CDA componentOf Tele): The value for root SHALL be '2.16.840.1.113883.2.9.4.1.6'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="@extension">(CDA componentOf Tele): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA componentOf Tele): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA componentOf Tele): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]
Item: (CDA componentOf Tele)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:code[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem) or @nullFlavor]"
         id="d104884e177-false-d107467e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.17660-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDA componentOf Tele): The element value SHALL be one of '2.16.840.1.113883.1.11.17660 ServiceDeliveryLocationRoleType (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA componentOf Tele): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA componentOf Tele): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA componentOf Tele): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA componentOf Tele): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location
Item: (CDA componentOf Tele)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location">
      <extends rule="d107526e0-false-d107541e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@classCode) = ('PLC') or not(@classCode)">(CDA componentOf Tele): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.646-2025-05-27T121115.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA componentOf Tele): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location
Item: (CDA place )
-->
   <rule fpi="RULC-1" id="d107526e0-false-d107541e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:name) &lt;= 1">(CDA place ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="count(hl7:addr) &lt;= 1">(CDA place ): element hl7:addr appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:templateId
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:name
Item: (CDA place )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.52
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr
Item: (CDA place )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr">
      <extends rule="d107623e0-false-d107629e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="@use">(CDA place ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.52-2022-07-04T145935.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA place ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d107623e0-false-d107629e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:location/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.646
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]
Item: (CDA componentOf Tele)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@classCode) = ('ORG')">(CDA Organization RSA): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization RSA): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization RSA): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:asOrganizationPartOf) &gt;= 1">(CDA Organization RSA): element hl7:asOrganizationPartOf is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization RSA): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:id
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@root">(CDA Organization RSA): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization RSA): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@extension">(CDA Organization RSA): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization RSA): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization RSA): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:name
Item: (CDA Organization RSA)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:telecom
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@use">(CDA Organization RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr">
      <extends rule="d107948e0-false-d107954e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="@use">(CDA Organization RSA): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization RSA): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d107948e0-false-d107954e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.374
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf
Item: (CDA Organization RSA)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf">
      <extends rule="d108112e0-false-d108148e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization RSA): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.374-2023-12-17T123945.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization RSA): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d108112e0-false-d108148e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d108318e0-false-d108322e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d108318e0-false-d108322e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d108488e0-false-d108494e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d108488e0-false-d108494e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <extends rule="d108652e0-false-d108688e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1" id="d108652e0-false-d108688e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDA organizationPartOf ): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDA organizationPartOf ): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDA organizationPartOf ): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']) &lt;= 1">(CDA organizationPartOf ): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDA organizationPartOf ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDA organizationPartOf ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA organizationPartOf ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA organizationPartOf ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDA organizationPartOf ): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDA organizationPartOf ): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDA organizationPartOf ): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA organizationPartOf ): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDA organizationPartOf ): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@codeSystemVersion) or string-length(@codeSystemVersion)&gt;0">(CDA organizationPartOf ): Attribute @codeSystemVersion SHALL be of data type 'st'  - '<value-of select="@codeSystemVersion"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:statusCode
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:effectiveTime
Item: (CDA organizationPartOf )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA organizationPartOf )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']">
      <extends rule="d108858e0-false-d108862e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDA organizationPartOf ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']
Item: (CDA Organization )
-->
   <rule fpi="RULC-1" id="d108858e0-false-d108862e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDA Organization ): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE') or not(@determinerCode)">(CDA Organization ): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:id) &lt;= 1">(CDA Organization ): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDA Organization ): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf) &lt;= 1">(CDA Organization ): element hl7:asOrganizationPartOf appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDA Organization ): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDA Organization ): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDA Organization ): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDA Organization ): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDA Organization ): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:name
Item: (CDA Organization )
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr">
      <extends rule="d109028e0-false-d109034e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDA Organization ): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDA Organization ): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr
Item: (CDA addr)
-->
   <rule fpi="RULC-1" id="d109028e0-false-d109034e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDA addr): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDA addr): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDA addr): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDA addr): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDA addr): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDA addr): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDA addr): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDA addr): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDA addr): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDA addr): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:country
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:state
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:county
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:city
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:postalCode
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:streetAddressLine
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:addr/hl7:censusTract
Item: (CDA addr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf
Item: (CDA Organization )
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:componentOf[hl7:encompassingEncounter]/hl7:encompassingEncounter[hl7:location]/hl7:location[hl7:healthCareFacility]/hl7:healthCareFacility[hl7:serviceProviderOrganization[@classCode = 'ORG']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][hl7:asOrganizationPartOf]/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG']/hl7:asOrganizationPartOf">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART') or not(@classCode)">(CDA Organization ): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDA Organization ): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]"
         id="d44e2043-false-d109322e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:structuredBody) &gt;= 1">(Referto di Televisita): element hl7:structuredBody is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:structuredBody) &lt;= 1">(Referto di Televisita): element hl7:structuredBody appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody
Item: (Referto di Televisita)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
         id="d44e2046-false-d109594e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(Referto di Televisita): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(Referto di Televisita): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(Referto di Televisita): element hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29299-5 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '11329-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '30954-2' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '30954-2 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29545-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62387-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93126-1' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '47045-0' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '47045-0 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '29548-5' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '55110-1' and @codeSystem = '2.16.840.1.113883.6.1') or (@code = '55110-1 ' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '62385-0' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '80615-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.16.1.1
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Referto di Televisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.16.1.1 ']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '93341-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(Referto di Televisita): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20251014T155738/tmp-2.16.840.1.113883.2.9.10.1.16.1.1-2025-05-16T122334.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(Referto di Televisita): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
   </rule>
</pattern>
