<?xml version="1.0" encoding="UTF-8"?>
<!--
Template derived pattern
===========================================
ID: 2.16.840.1.113883.2.9.10.1.2.2
Name: Prescrizione Specialistica (PrS)
Description: Template CDA ClinicalDocument (prototype, directly derived from POCD_RM000040 MIF)
-->
<pattern xmlns="http://purl.oclc.org/dsdl/schematron"
         id="template-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732">
   <title>Prescrizione Specialistica (PrS)</title>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]"
         id="d42e15-false-d480e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@classCode) = ('DOCCLIN')">(CDAClinicalDocument): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@moodCode) = ('EVN')">(CDAClinicalDocument): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1">(CDAClinicalDocument): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1">(CDAClinicalDocument): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']) &gt;= 1">(CDAClinicalDocument): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1">(CDAClinicalDocument): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1">(CDAClinicalDocument): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(CDAClinicalDocument): element hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(CDAClinicalDocument): element hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:title) &lt;= 1">(CDAClinicalDocument): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDAClinicalDocument): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAClinicalDocument): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1">(CDAClinicalDocument): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1">(CDAClinicalDocument): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:languageCode) &gt;= 1">(CDAClinicalDocument): element hl7:languageCode is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:languageCode) &lt;= 1">(CDAClinicalDocument): element hl7:languageCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:setId) &gt;= 1">(CDAClinicalDocument): element hl7:setId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:setId) &lt;= 1">(CDAClinicalDocument): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:versionNumber) &gt;= 1">(CDAClinicalDocument): element hl7:versionNumber is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDAClinicalDocument): element hl7:versionNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &gt;= 1">(CDAClinicalDocument): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &lt;= 1">(CDAClinicalDocument): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]) &gt;= 1">(CDAClinicalDocument): element hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]) &lt;= 1">(CDAClinicalDocument): element hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &gt;= 1">(CDAClinicalDocument): element hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &lt;= 1">(CDAClinicalDocument): element hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1">(CDAClinicalDocument): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2">(CDAClinicalDocument): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &gt;= 1">(CDAClinicalDocument): element hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &lt;= 1">(CDAClinicalDocument): element hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:structuredBody]) &gt;= 1">(CDAClinicalDocument): element hl7:component[hl7:structuredBody] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:structuredBody]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:structuredBody] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:realmCode
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:realmCode"
         id="d42e18-false-d1115e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@code">(CDAClinicalDocument): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
         id="d42e37-false-d1131e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@root) = ('2.16.840.1.113883.1.3')">(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@extension) = ('POCD_MT000040UV02')">(CDAClinicalDocument): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']"
         id="d42e72-false-d1150e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.10.1.2.2')">(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.2.2'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@extension) = ('2.3')">(CDAClinicalDocument): The value for extension SHALL be '2.3'. Found: "<value-of select="@extension"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']"
         id="d42e91-false-d1169e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')">(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@extension">(CDAClinicalDocument): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAClinicalDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
         id="d42e115-false-d1190e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@code) = ('57832-8')">(CDAClinicalDocument): The value for code SHALL be '57832-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(CDAClinicalDocument): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@displayName) = ('Prescrizione specialistica') or not(@displayName)">(CDAClinicalDocument): The value for displayName SHALL be 'Prescrizione specialistica'. Found: "<value-of select="@displayName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
         id="d42e140-false-d1221e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@code">(CDAClinicalDocument): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAClinicalDocument): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:qualifier[hl7:name[@code = 'TP']]) &gt;= 1">(CDAClinicalDocument): element hl7:qualifier[hl7:name[@code = 'TP']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:qualifier[hl7:name[@code = 'TP']]) &lt;= 1">(CDAClinicalDocument): element hl7:qualifier[hl7:name[@code = 'TP']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]"
         id="d42e175-false-d1253e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:name[@code = 'TP']) &gt;= 1">(CDAClinicalDocument): element hl7:name[@code = 'TP'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:name[@code = 'TP']) &lt;= 1">(CDAClinicalDocument): element hl7:name[@code = 'TP'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:value) &lt;= 1">(CDAClinicalDocument): element hl7:value appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:name[@code = 'TP']
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:name[@code = 'TP']"
         id="d42e181-false-d1277e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@code) = ('TP')">(CDAClinicalDocument): The value for code SHALL be 'TP'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.5.2.1') or not(@codeSystem)">(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.5.2.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystemName) = ('Classificazione Prescrizione') or not(@codeSystemName)">(CDAClinicalDocument): The value for codeSystemName SHALL be 'Classificazione Prescrizione'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:value
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:value"
         id="d42e186-false-d1302e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAClinicalDocument): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:title
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:effectiveTime
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:effectiveTime"
         id="d42e215-false-d1330e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@value">(CDAClinicalDocument): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAClinicalDocument): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
         id="d42e231-false-d1344e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@nullFlavor or (@code='N') or (@code='V')">(CDAClinicalDocument): The element value SHALL be one of 'code 'N' or code 'V''.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@code">(CDAClinicalDocument): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.25')">(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)">(CDAClinicalDocument): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:languageCode
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:languageCode"
         id="d42e263-false-d1377e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@code">(CDAClinicalDocument): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:setId
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:setId"
         id="d42e282-false-d1390e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@root">(CDAClinicalDocument): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAClinicalDocument): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@extension">(CDAClinicalDocument): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAClinicalDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:versionNumber
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:versionNumber"
         id="d42e308-false-d1411e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="@value">(CDAClinicalDocument): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(CDAClinicalDocument): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]"
         id="d1418e19-false-d1505e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@typeCode) = ('RCT')">(CDArecordTarget): The value for typeCode SHALL be 'RCT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@contextControlCode) = ('OP')">(CDArecordTarget): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1">(CDArecordTarget): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDArecordTarget): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]"
         id="d1418e26-false-d1689e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('PAT')">(CDArecordTarget): The value for classCode SHALL be 'PAT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:id) &gt;= 1">(CDArecordTarget): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1">(CDArecordTarget): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1">(CDArecordTarget): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDArecordTarget): element hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:id
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:id"
         id="d1418e31-false-d1813e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@root">(CDArecordTarget): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDArecordTarget): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@extension">(CDArecordTarget): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDArecordTarget): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDArecordTarget): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr
Item: (CDArecordTarget)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr">
      <extends rule="d1867e0-false-d1873e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@use">(CDArecordTarget): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d1867e0-false-d1873e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:telecom
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:telecom"
         id="d1418e113-false-d1985e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@use">(CDArecordTarget): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@value) or string-length(@value)&gt;0">(CDArecordTarget): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
         id="d1418e132-false-d2055e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('PSN')">(CDArecordTarget): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:name) &gt;= 1">(CDArecordTarget): element hl7:name is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:name) &lt;= 1">(CDArecordTarget): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1">(CDArecordTarget): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDArecordTarget): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:birthTime) &gt;= 1">(CDArecordTarget): element hl7:birthTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:birthTime) &lt;= 1">(CDArecordTarget): element hl7:birthTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:guardian[@classCode = 'GUARD']) &gt;= 1">(CDArecordTarget): element hl7:guardian[@classCode = 'GUARD'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDArecordTarget): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
         id="d1418e139-false-d2151e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:family) &gt;= 1">(CDArecordTarget): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:family) &lt;= 1">(CDArecordTarget): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:given) &gt;= 1">(CDArecordTarget): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:given) &lt;= 1">(CDArecordTarget): element hl7:given appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:family
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name/hl7:given
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d1418e163-false-d2194e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDArecordTarget): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@code">(CDArecordTarget): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDArecordTarget): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.1')">(CDArecordTarget): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)">(CDArecordTarget): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDArecordTarget): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDArecordTarget): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
         id="d1418e184-false-d2229e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@value">(CDArecordTarget): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDArecordTarget): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']"
         id="d1418e193-false-d2283e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('GUARD')">(CDArecordTarget): The value for classCode SHALL be 'GUARD'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:code) &lt;= 1">(CDArecordTarget): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDArecordTarget): element hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDArecordTarget): element hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:id
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:id"
         id="d1418e199-false-d2365e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@root">(CDArecordTarget): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDArecordTarget): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@extension">(CDArecordTarget): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDArecordTarget): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDArecordTarget): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:code
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:code"
         id="d1418e207-false-d2386e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@code">(CDArecordTarget): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDArecordTarget): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@codeSystem">(CDArecordTarget): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDArecordTarget): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDArecordTarget): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDArecordTarget): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr
Item: (CDArecordTarget)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr">
      <extends rule="d2443e0-false-d2449e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@use">(CDArecordTarget): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d2443e0-false-d2449e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:telecom
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:telecom"
         id="d1418e232-false-d2561e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@use">(CDArecordTarget): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="@value">(CDArecordTarget): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="not(@value) or string-length(@value)&gt;0">(CDArecordTarget): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (CDArecordTarget)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('PSN')">(CDArecordTarget): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.61
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (CDApersonPr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.61
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDApersonPr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d2833e0-false-d2839e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d2833e0-false-d2839e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d2995e0-false-d2999e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d2995e0-false-d2999e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d3162e0-false-d3166e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d3162e0-false-d3166e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d3330e0-false-d3336e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d3330e0-false-d3336e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d3492e0-false-d3496e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d3492e0-false-d3496e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]"
         id="d1418e254-false-d3665e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('BIRTHPL')">(CDArecordTarget): The value for classCode SHALL be 'BIRTHPL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &gt;= 1">(CDArecordTarget): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDArecordTarget): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']"
         id="d1418e260-false-d3685e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@classCode) = ('PLC')">(CDArecordTarget): The value for classCode SHALL be 'PLC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:addr) &gt;= 1">(CDArecordTarget): element hl7:addr is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:addr) &lt;= 1">(CDArecordTarget): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDArecordTarget)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr"
         id="d1418e283-false-d3709e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:country) &lt;= 1">(CDArecordTarget): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:censusTract) &lt;= 1">(CDArecordTarget): element hl7:censusTract appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html"
              test="count(hl7:city) &lt;= 1">(CDArecordTarget): element hl7:city appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDArecordTarget)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.18
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDArecordTarget)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d3964e0-false-d3970e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d3964e0-false-d3970e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d4126e0-false-d4130e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d4126e0-false-d4130e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d4293e0-false-d4297e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d4293e0-false-d4297e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d4461e0-false-d4467e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d4461e0-false-d4467e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d4623e0-false-d4627e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d4623e0-false-d4627e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]"
         id="d3792e395-false-d4844e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="string(@typeCode) = ('AUT')">(CDAauthor): The value for typeCode SHALL be 'AUT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="string(@contextControlCode) = ('OP')">(CDAauthor): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:time) &gt;= 1">(CDAauthor): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:time) &lt;= 1">(CDAauthor): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1">(CDAauthor): element hl7:assignedAuthor[hl7:assignedPerson] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1">(CDAauthor): element hl7:assignedAuthor[hl7:assignedPerson] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:time
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:time"
         id="d3792e408-false-d4923e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@value">(CDAauthor): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAauthor): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]"
         id="d3792e430-false-d4983e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:id) &gt;= 1">(CDAauthor): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:code) &lt;= 1">(CDAauthor): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:assignedPerson) &gt;= 1">(CDAauthor): element hl7:assignedPerson is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAauthor): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAauthor): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id"
         id="d3792e437-false-d5072e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@root">(CDAauthor): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAauthor): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@extension">(CDAauthor): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAauthor): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAauthor): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code"
         id="d3792e474-false-d5093e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@code">(CDAauthor): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAauthor): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@codeSystem">(CDAauthor): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDAauthor): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAauthor): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAauthor): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr
Item: (CDAauthor)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr">
      <extends rule="d5160e0-false-d5166e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@use">(CDAauthor): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAauthor): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d5160e0-false-d5166e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom
Item: (CDAauthor)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom"
         id="d3792e514-false-d5278e0">
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAauthor): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="@value">(CDAauthor): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html"
              test="not(@value) or string-length(@value)&gt;0">(CDAauthor): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson
Item: (CDAauthor)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson
Item: (CDApersonDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDApersonDocGen): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (CDApersonDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name
Item: (CDAnameDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDAnameDocGen): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDAnameDocGen): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDAnameDocGen): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDAnameDocGen): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDAnameDocGen): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDAnameDocGen): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.39
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAauthor)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d5646e0-false-d5652e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d5646e0-false-d5652e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d5808e0-false-d5812e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d5808e0-false-d5812e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d5975e0-false-d5979e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d5975e0-false-d5979e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d6143e0-false-d6149e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d6143e0-false-d6149e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d6305e0-false-d6309e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d6305e0-false-d6309e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.64
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]
Item: (CDAdataEnterer)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]"
         id="d5474e362-false-d6527e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="string(@typeCode) = ('ENT')">(CDAdataEnterer): The value for typeCode SHALL be 'ENT'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="string(@contextControlCode) = ('OP')">(CDAdataEnterer): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="count(hl7:time) &lt;= 1">(CDAdataEnterer): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDAdataEnterer): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDAdataEnterer): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.64
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time
Item: (CDAdataEnterer)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time"
         id="d5474e374-false-d6605e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="@value">(CDAdataEnterer): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAdataEnterer): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.64
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDAdataEnterer)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDAAssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDAAssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDAAssignedEntity): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDAAssignedEntity): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDAAssignedEntity): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDAAssignedEntity): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr">
      <extends rule="d6897e0-false-d6903e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d6897e0-false-d6903e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDApersonDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDApersonDocGen): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDApersonDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDAnameDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDAnameDocGen): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDAnameDocGen): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDAnameDocGen): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDAnameDocGen): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDAnameDocGen): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDAnameDocGen): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d7381e0-false-d7387e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d7381e0-false-d7387e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d7543e0-false-d7547e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d7543e0-false-d7547e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d7710e0-false-d7714e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d7710e0-false-d7714e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d7878e0-false-d7884e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d7878e0-false-d7884e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d8040e0-false-d8044e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d8040e0-false-d8044e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]
Item: (CDAcustodian)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]"
         id="d6671e520-false-d8223e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="string(@typeCode) = ('CST')">(CDAcustodian): The value for typeCode SHALL be 'CST'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1">(CDAcustodian): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDAcustodian): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]
Item: (CDAcustodian)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]"
         id="d6671e530-false-d8261e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="string(@classCode) = ('ASSIGNED')">(CDAcustodian): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1">(CDAcustodian): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAcustodian): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAcustodian)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
         id="d6671e540-false-d8299e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="string(@classCode) = ('ORG')">(CDAcustodian): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAcustodian): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:name) &lt;= 1">(CDAcustodian): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="count(hl7:addr) &lt;= 1">(CDAcustodian): element hl7:addr appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAcustodian)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
         id="d6671e546-false-d8344e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="@root">(CDAcustodian): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAcustodian): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="@extension">(CDAcustodian): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAcustodian): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAcustodian): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAcustodian)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAcustodian)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
         id="d6671e580-false-d8373e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="@use">(CDAcustodian): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAcustodian): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="@value">(CDAcustodian): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@value) or string-length(@value)&gt;0">(CDAcustodian): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.41
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAcustodian)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d8434e0-false-d8440e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="@use">(CDAcustodian): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAcustodian): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d8434e0-false-d8440e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]
Item: (CDAlegalAuthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
         id="d8415e77-false-d8602e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="string(@typeCode) = ('LA') or not(@typeCode)">(CDAlegalAuthenticator): The value for typeCode SHALL be 'LA'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDAlegalAuthenticator): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:time) &gt;= 1">(CDAlegalAuthenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:time) &lt;= 1">(CDAlegalAuthenticator): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDAlegalAuthenticator): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDAlegalAuthenticator): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDAlegalAuthenticator): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDAlegalAuthenticator): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDAlegalAuthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
         id="d8415e89-false-d8691e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="@value">(CDAlegalAuthenticator): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAlegalAuthenticator): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDAlegalAuthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d8415e105-false-d8705e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html"
              test="string(@code) = ('S')">(CDAlegalAuthenticator): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.42
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDAlegalAuthenticator)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDAAssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDAAssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDAAssignedEntity): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDAAssignedEntity): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDAAssignedEntity): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDAAssignedEntity): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d8995e0-false-d9001e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d8995e0-false-d9001e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDApersonDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDApersonDocGen): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDApersonDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDAnameDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDAnameDocGen): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDAnameDocGen): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDAnameDocGen): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDAnameDocGen): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDAnameDocGen): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDAnameDocGen): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d9479e0-false-d9485e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d9479e0-false-d9485e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d9641e0-false-d9645e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d9641e0-false-d9645e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d9808e0-false-d9812e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d9808e0-false-d9812e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d9976e0-false-d9982e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d9976e0-false-d9982e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d10138e0-false-d10142e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d10138e0-false-d10142e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.62
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]
Item: (CDAauthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
         id="d8769e520-false-d10361e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="string(@typeCode) = ('AUTHEN') or not(@typeCode)">(CDAauthenticator): The value for typeCode SHALL be 'AUTHEN'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:time) &gt;= 1">(CDAauthenticator): element hl7:time is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:time) &lt;= 1">(CDAauthenticator): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:signatureCode[@code = 'S']) &gt;= 1">(CDAauthenticator): element hl7:signatureCode[@code = 'S'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:signatureCode[@code = 'S']) &lt;= 1">(CDAauthenticator): element hl7:signatureCode[@code = 'S'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:assignedEntity) &gt;= 1">(CDAauthenticator): element hl7:assignedEntity is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="count(hl7:assignedEntity) &lt;= 1">(CDAauthenticator): element hl7:assignedEntity appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.62
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time
Item: (CDAauthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
         id="d8769e541-false-d10446e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="@value">(CDAauthenticator): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAauthenticator): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.62
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']
Item: (CDAauthenticator)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
         id="d8769e551-false-d10460e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="string(@code) = ('S')">(CDAauthenticator): The value for code SHALL be 'S'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html"
              test="not(@code) or string-length(@code)&gt;0">(CDAauthenticator): Attribute @code SHALL be of data type 'st'  - '<value-of select="@code"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.62
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDAauthenticator)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="string(@classCode) = ('ASSIGNED') or not(@classCode)">(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:id) &gt;= 1">(CDAAssignedEntity): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:code) &lt;= 1">(CDAAssignedEntity): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:assignedPerson) &lt;= 1">(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@root">(CDAAssignedEntity): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@extension">(CDAAssignedEntity): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@code">(CDAAssignedEntity): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@codeSystem">(CDAAssignedEntity): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr">
      <extends rule="d10753e0-false-d10759e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d10753e0-false-d10759e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom
Item: (CDAAssignedEntity)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="@use">(CDAAssignedEntity): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson
Item: (CDApersonDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDApersonDocGen): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDApersonDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name
Item: (CDAnameDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDAnameDocGen): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDAnameDocGen): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDAnameDocGen): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDAnameDocGen): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDAnameDocGen): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDAnameDocGen): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:given
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:family
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:prefix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name/hl7:suffix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.36
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAAssignedEntity)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d11237e0-false-d11243e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d11237e0-false-d11243e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d11399e0-false-d11403e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d11399e0-false-d11403e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d11566e0-false-d11570e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d11566e0-false-d11570e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d11734e0-false-d11740e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d11734e0-false-d11740e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d11896e0-false-d11900e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d11896e0-false-d11900e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
         id="d10527e512-false-d12117e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@typeCode">(CDAparticipant): attribute @typeCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))">(CDAparticipant): Attribute @typeCode SHALL be of data type 'cs'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="string(@contextControlCode) = ('OP') or not(@contextControlCode)">(CDAparticipant): The value for contextControlCode SHALL be 'OP'. Found: "<value-of select="@contextControlCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(CDAparticipant): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:time) &lt;= 1">(CDAparticipant): element hl7:time appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:associatedEntity[@classCode]) &gt;= 1">(CDAparticipant): element hl7:associatedEntity[@classCode] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:associatedEntity[@classCode]) &lt;= 1">(CDAparticipant): element hl7:associatedEntity[@classCode] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
         id="d10527e531-false-d12207e0">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(CDAparticipant): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@code">(CDAparticipant): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAparticipant): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@codeSystem">(CDAparticipant): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAparticipant): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAparticipant): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAparticipant): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time"
         id="d10527e561-false-d12240e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAparticipant): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:high) &lt;= 1">(CDAparticipant): element hl7:high appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time/hl7:high
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time/hl7:high"
         id="d10527e568-false-d12257e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@value">(CDAparticipant): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@value) or matches(string(@value), '^[0-9]{4,14}')">(CDAparticipant): Attribute @value SHALL be of data type 'ts'  - '<value-of select="@value"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
         id="d10527e575-false-d12317e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@classCode">(CDAparticipant): attribute @classCode SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))">(CDAparticipant): Attribute @classCode SHALL be of data type 'cs'  - '<value-of select="@classCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:id) &gt;= 1">(CDAparticipant): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:code) &lt;= 1">(CDAparticipant): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAparticipant): element hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="count(hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAparticipant): element hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
         id="d10527e610-false-d12409e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@root">(CDAparticipant): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAparticipant): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@extension">(CDAparticipant): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAparticipant): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAparticipant): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
         id="d10527e629-false-d12430e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@code">(CDAparticipant): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAparticipant): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@codeSystem">(CDAparticipant): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDAparticipant): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAparticipant): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAparticipant): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDAparticipant)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr">
      <extends rule="d12497e0-false-d12503e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@use">(CDAparticipant): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAparticipant): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d12497e0-false-d12503e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom
Item: (CDAparticipant)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
         id="d10527e682-false-d12615e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@use">(CDAparticipant): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAparticipant): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="@value">(CDAparticipant): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="not(@value) or string-length(@value)&gt;0">(CDAparticipant): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (CDAparticipant)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']">
      <extends rule="d12665e0-false-d12669e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="string(@classCode) = ('PSN')">(CDAparticipant): The value for classCode SHALL be 'PSN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAparticipant): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']
Item: (CDApersonDocGen)
-->
   <rule fpi="RULC-1" id="d12665e0-false-d12669e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html"
              test="count(hl7:name) &lt;= 1">(CDApersonDocGen): element hl7:name appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.54
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDApersonDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAnameDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &gt;= 1">(CDAnameDocGen): element hl7:given is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:given) &lt;= 1">(CDAnameDocGen): element hl7:given appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &gt;= 1">(CDAnameDocGen): element hl7:family is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:family) &lt;= 1">(CDAnameDocGen): element hl7:family appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:prefix) &lt;= 1">(CDAnameDocGen): element hl7:prefix appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html"
              test="count(hl7:suffix) &lt;= 1">(CDAnameDocGen): element hl7:suffix appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name/hl7:given
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name/hl7:family
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name/hl7:prefix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.60
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name/hl7:suffix
Item: (CDAnameDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.63
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAparticipant)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d12983e0-false-d12989e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d12983e0-false-d12989e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d13145e0-false-d13149e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d13145e0-false-d13149e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d13312e0-false-d13316e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d13312e0-false-d13316e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d13480e0-false-d13486e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d13480e0-false-d13486e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d13642e0-false-d13646e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d13642e0-false-d13646e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]
Item: (CDArelatedDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
         id="d12811e362-false-d13816e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="@typeCode">(CDArelatedDocument): attribute @typeCode SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDArelatedDocument): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:parentDocument) &gt;= 1">(CDArelatedDocument): element hl7:parentDocument is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:parentDocument) &lt;= 1">(CDArelatedDocument): element hl7:parentDocument appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument
Item: (CDArelatedDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
         id="d12811e399-false-d13847e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="string(@classCode) = ('DOCCLIN') or not(@classCode)">(CDArelatedDocument): The value for classCode SHALL be 'DOCCLIN'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDArelatedDocument): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:id) &gt;= 1">(CDArelatedDocument): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:code) &lt;= 1">(CDArelatedDocument): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:text) &lt;= 1">(CDArelatedDocument): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:setId) &lt;= 1">(CDArelatedDocument): element hl7:setId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="count(hl7:versionNumber) &lt;= 1">(CDArelatedDocument): element hl7:versionNumber appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id
Item: (CDArelatedDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
         id="d12811e427-false-d13893e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="@root">(CDArelatedDocument): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDArelatedDocument): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="@extension">(CDArelatedDocument): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDArelatedDocument): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDArelatedDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code
Item: (CDArelatedDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
         id="d12811e443-false-d13914e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="@code">(CDArelatedDocument): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDArelatedDocument): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="@codeSystem">(CDArelatedDocument): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(CDArelatedDocument): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDArelatedDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDArelatedDocument): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:text
Item: (CDArelatedDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:setId
Item: (CDArelatedDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.66
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:versionNumber
Item: (CDArelatedDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]
Item: (CDAcomponentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]"
         id="d13956e15-false-d13994e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDAcomponentOf): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &gt;= 1">(CDAcomponentOf): element hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &lt;= 1">(CDAcomponentOf): element hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]
Item: (CDAcomponentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]"
         id="d13956e22-false-d14076e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@classCode) = ('ENC') or not(@classCode)">(CDAcomponentOf): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDAcomponentOf): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &gt;= 1">(CDAcomponentOf): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &lt;= 1">(CDAcomponentOf): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:effectiveTime) &gt;= 1">(CDAcomponentOf): element hl7:effectiveTime is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAcomponentOf): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &gt;= 1">(CDAcomponentOf): element hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &lt;= 1">(CDAcomponentOf): element hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4']
Item: (CDAcomponentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4']"
         id="d13956e48-false-d14148e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="@code">(CDAcomponentOf): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CDAcomponentOf): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(CDAcomponentOf): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CDAcomponentOf): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CDAcomponentOf): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:effectiveTime
Item: (CDAcomponentOf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]
Item: (CDAcomponentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]"
         id="d13956e83-false-d14209e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@typeCode) = ('LOC')">(CDAcomponentOf): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1">(CDAcomponentOf): element hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1">(CDAcomponentOf): element hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]
Item: (CDAcomponentOf)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]"
         id="d13956e85-false-d14289e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="string(@classCode) = ('SDLOC')">(CDAcomponentOf): The value for classCode SHALL be 'SDLOC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:id) &gt;= 1">(CDAcomponentOf): element hl7:id is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:id) &lt;= 1">(CDAcomponentOf): element hl7:id appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1">(CDAcomponentOf): element hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html"
              test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAcomponentOf): element hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:id
Item: (CDAcomponentOf)
-->


   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.95
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAcomponentOf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d14560e0-false-d14566e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d14560e0-false-d14566e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d14722e0-false-d14726e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d14722e0-false-d14726e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <extends rule="d14889e0-false-d14893e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1" id="d14889e0-false-d14893e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('ORG')">(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@determinerCode) = ('INSTANCE')">(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<value-of select="@determinerCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:name) &lt;= 1">(CDAOrganization): element hl7:name appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1">(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@root">(CDAOrganization): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@extension">(CDAOrganization): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:name
Item: (CDAOrganization)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr">
      <extends rule="d15057e0-false-d15063e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="@use">(CDAOrganization): attribute @use SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@use),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC).</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr
Item: (CDAaddrDocGen)
-->
   <rule fpi="RULC-1" id="d15057e0-false-d15063e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &gt;= 1">(CDAaddrDocGen): element hl7:country is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:country) &lt;= 1">(CDAaddrDocGen): element hl7:country appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:state) &lt;= 1">(CDAaddrDocGen): element hl7:state appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:county) &lt;= 1">(CDAaddrDocGen): element hl7:county appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &gt;= 1">(CDAaddrDocGen): element hl7:city is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:city) &lt;= 1">(CDAaddrDocGen): element hl7:city appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:postalCode) &lt;= 1">(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &gt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:streetAddressLine) &lt;= 1">(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html"
              test="count(hl7:censusTract) &lt;= 1">(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:country
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:state
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:county
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:city
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:postalCode
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:streetAddressLine
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.34
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr/hl7:censusTract
Item: (CDAaddrDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.58
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAOrganization)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']">
      <extends rule="d15219e0-false-d15223e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="string(@classCode) = ('PART')">(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html"
              test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))">(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<value-of select="@determinerCode"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1" id="d15219e0-false-d15223e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:code) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:statusCode) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:effectiveTime) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1">(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@root">(CDAorganizationPartOfDocGen): attribute @root SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')">(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<value-of select="@root"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@extension">(CDAorganizationPartOfDocGen): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="not(@extension) or string-length(@extension)&gt;0">(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@assigningAuthorityName">(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@code">(CDAorganizationPartOfDocGen): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystem">(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@codeSystemName">(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="@displayName">(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present.</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:statusCode
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:effectiveTime
Item: (CDAorganizationPartOfDocGen)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.59
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']
Item: (CDAorganizationPartOfDocGen)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html"
              test="string(@classCode) = ('PART')">(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<value-of select="@classCode"/>"</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]"
         id="d42e336-false-d15438e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@typeCode) = ('COMP') or not(@typeCode)">(CDAClinicalDocument): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)">(CDAClinicalDocument): The value for contextConductionInd SHALL be 'true'. Found: "<value-of select="@contextConductionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:structuredBody) &gt;= 1">(CDAClinicalDocument): element hl7:structuredBody is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:structuredBody) &lt;= 1">(CDAClinicalDocument): element hl7:structuredBody appears too often [max 1x].</assert>
   </rule>
   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody
Item: (CDAClinicalDocument)
-->

   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
         id="d42e339-false-d15554e0">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@classCode) = ('DOCBODY') or not(@classCode)">(CDAClinicalDocument): The value for classCode SHALL be 'DOCBODY'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="string(@moodCode) = ('EVN') or not(@moodCode)">(CDAClinicalDocument): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html"
              test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]) &lt;= 1">(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Esenzioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1">(Esenzioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1">(Esenzioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]
Item: (Esenzioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1">(Esenzioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1">(Esenzioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Esenzioniv2_PrS): element hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Esenzioniv2_PrS): element hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:title) &lt;= 1">(Esenzioniv2_PrS): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:text) &gt;= 1">(Esenzioniv2_PrS): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:text) &lt;= 1">(Esenzioniv2_PrS): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1">(Esenzioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1">(Esenzioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']
Item: (Esenzioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')">(Esenzioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="@extension">(Esenzioniv2_PrS): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Esenzioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Esenzioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Esenzioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="string(@code) = ('57827-8')">(Esenzioniv2_PrS): The value for code SHALL be '57827-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Esenzioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Esenzioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Esenzioniv2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Esenzioniv2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:title
Item: (Esenzioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:text
Item: (Esenzioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.108
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Esenzioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.89
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Esenzioni_PrF_entry_2)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1">(Esenzioni_PrF_entry_2): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1">(Esenzioni_PrF_entry_2): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.89
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']
Item: (Esenzioni_PrF_entry_2)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="string(@classCode) = ('ACT')">(Esenzioni_PrF_entry_2): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="string(@moodCode) = ('EVN')">(Esenzioni_PrF_entry_2): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:code) &gt;= 1">(Esenzioni_PrF_entry_2): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:code) &lt;= 1">(Esenzioni_PrF_entry_2): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.89
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code
Item: (Esenzioni_PrF_entry_2)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="@code">(Esenzioni_PrF_entry_2): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Esenzioni_PrF_entry_2): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="@codeSystem">(Esenzioni_PrF_entry_2): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Esenzioni_PrF_entry_2): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Esenzioni_PrF_entry_2): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Esenzioni_PrF_entry_2): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:originalText) &lt;= 1">(Esenzioni_PrF_entry_2): element hl7:originalText appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.89
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText
Item: (Esenzioni_PrF_entry_2)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:reference) &gt;= 1">(Esenzioni_PrF_entry_2): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="count(hl7:reference) &lt;= 1">(Esenzioni_PrF_entry_2): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.89
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText/hl7:reference
Item: (Esenzioni_PrF_entry_2)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="@value">(Esenzioni_PrF_entry_2): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html"
              test="not(@value) or string-length(@value)&gt;0">(Esenzioni_PrF_entry_2): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Prescrizioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1">(Prescrizioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1">(Prescrizioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]
Item: (Prescrizioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1">(Prescrizioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1">(Prescrizioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Prescrizioniv2_PrS): element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Prescrizioniv2_PrS): element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:title) &lt;= 1">(Prescrizioniv2_PrS): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:text) &gt;= 1">(Prescrizioniv2_PrS): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:text) &lt;= 1">(Prescrizioniv2_PrS): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &gt;= 1">(Prescrizioniv2_PrS): element hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &lt;= 1">(Prescrizioniv2_PrS): element hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']
Item: (Prescrizioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')">(Prescrizioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="@extension">(Prescrizioniv2_PrS): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Prescrizioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Prescrizioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Prescrizioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="string(@code) = ('57828-6')">(Prescrizioniv2_PrS): The value for code SHALL be '57828-6'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Prescrizioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Prescrizioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizioniv2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizioniv2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:title
Item: (Prescrizioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:text
Item: (Prescrizioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.109
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]
Item: (Prescrizioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &gt;= 1">(Prescrizione_Specialistica_PrS): element hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@classCode) = ('OBS')">(Prescrizione_Specialistica_PrS): The value for classCode SHALL be 'OBS'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@moodCode) = ('RQO')">(Prescrizione_Specialistica_PrS): The value for moodCode SHALL be 'RQO'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:code) &gt;= 1">(Prescrizione_Specialistica_PrS): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:code) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:repeatNumber) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:repeatNumber appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:participant) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:participant appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]) &gt;= 1">(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@code">(Prescrizione_Specialistica_PrS): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@codeSystem">(Prescrizione_Specialistica_PrS): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code/hl7:translation
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@code">(Prescrizione_Specialistica_PrS): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@codeSystem">(Prescrizione_Specialistica_PrS): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@code">(Prescrizione_Specialistica_PrS): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione_Specialistica_PrS): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.16866' ActPriority (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.7')">(Prescrizione_Specialistica_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.5.7'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@codeSystemName) = ('ActPriority') or not(@codeSystemName)">(Prescrizione_Specialistica_PrS): The value for codeSystemName SHALL be 'ActPriority'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']/hl7:translation
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@code">(Prescrizione_Specialistica_PrS): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')">(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'oid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:repeatNumber
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:repeatNumber">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(Prescrizione_Specialistica_PrS): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('LOC') or not(@typeCode)">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'LOC'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@classCode) = ('ROL') or not(@classCode)">(Prescrizione_Specialistica_PrS): The value for classCode SHALL be 'ROL'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &gt;= 1">(Prescrizione_Specialistica_PrS): element hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &gt;= 1">(Prescrizione_Specialistica_PrS): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &lt;= 1">(Prescrizione_Specialistica_PrS): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="@code">(Prescrizione_Specialistica_PrS): attribute @code SHALL be present.</assert>
      <let name="theAttValue"
           value="distinct-values(tokenize(normalize-space(@code),'\s'))"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.9.6.3.1.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])">(Prescrizione_Specialistica_PrS): The value for code SHALL be selected from value set '2.16.840.1.113883.2.9.6.3.1.1' Tipo Ambulatoriale SP (DYNAMIC).</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.1')">(Prescrizione_Specialistica_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.3.1.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]">
      <extends rule="d16590e0-false-d16594e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('SUBJ')">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'SUBJ'. Found: "<value-of select="@typeCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@typeCode) or string-length(@typeCode)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @typeCode SHALL be of data type 'st'  - '<value-of select="@typeCode"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@inversionInd) = ('true')">(Prescrizione_Specialistica_PrS): The value for inversionInd SHALL be 'true'. Found: "<value-of select="@inversionInd"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="not(@inversionInd) or string-length(@inversionInd)&gt;0">(Prescrizione_Specialistica_PrS): Attribute @inversionInd SHALL be of data type 'st'  - '<value-of select="@inversionInd"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1" id="d16590e0-false-d16594e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &gt;= 1">(NotaEsplicativa_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &lt;= 1">(NotaEsplicativa_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@classCode) = ('ACT')">(NotaEsplicativa_Pr): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@moodCode) = ('EVN')">(NotaEsplicativa_Pr): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &gt;= 1">(NotaEsplicativa_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &lt;= 1">(NotaEsplicativa_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(NotaEsplicativa_Pr): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(NotaEsplicativa_Pr): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:text) &gt;= 1">(NotaEsplicativa_Pr): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:text) &lt;= 1">(NotaEsplicativa_Pr): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.274')">(NotaEsplicativa_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.274'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@code) = ('48767-8')">(NotaEsplicativa_Pr): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(NotaEsplicativa_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(NotaEsplicativa_Pr): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(NotaEsplicativa_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(NotaEsplicativa_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:reference) &gt;= 1">(NotaEsplicativa_Pr): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="count(hl7:reference) &lt;= 1">(NotaEsplicativa_Pr): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.274
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text/hl7:reference
Item: (NotaEsplicativa_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html"
              test="not(@value) or string-length(@value)&gt;0">(NotaEsplicativa_Pr): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]">
      <extends rule="d16733e0-false-d16737e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('REFR') or not(@typeCode)">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.275
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]
Item: (CodicePatologia_Pr)
-->
   <rule fpi="RULC-1" id="d16733e0-false-d16737e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &gt;= 1">(CodicePatologia_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &lt;= 1">(CodicePatologia_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.275
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]
Item: (CodicePatologia_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="string(@moodCode) = ('EVN')">(CodicePatologia_Pr): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="string(@classCode) = ('ACT')">(CodicePatologia_Pr): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &gt;= 1">(CodicePatologia_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &lt;= 1">(CodicePatologia_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &gt;= 1">(CodicePatologia_Pr): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &lt;= 1">(CodicePatologia_Pr): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.275
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']
Item: (CodicePatologia_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.275')">(CodicePatologia_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.275'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.275
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']
Item: (CodicePatologia_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="@code">(CodicePatologia_Pr): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(CodicePatologia_Pr): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.3')">(CodicePatologia_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.3.1.3'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(CodicePatologia_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(CodicePatologia_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]">
      <extends rule="d16839e0-false-d16843e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('REFR')">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.276
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]
Item: (TipologiaAccesso_Pr)
-->
   <rule fpi="RULC-1" id="d16839e0-false-d16843e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &gt;= 1">(TipologiaAccesso_Pr): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &lt;= 1">(TipologiaAccesso_Pr): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.276
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]
Item: (TipologiaAccesso_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="string(@classCode) = ('ENC')">(TipologiaAccesso_Pr): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="string(@moodCode) = ('INT')">(TipologiaAccesso_Pr): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &gt;= 1">(TipologiaAccesso_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &lt;= 1">(TipologiaAccesso_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:code) &gt;= 1">(TipologiaAccesso_Pr): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="count(hl7:code) &lt;= 1">(TipologiaAccesso_Pr): element hl7:code appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.276
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']
Item: (TipologiaAccesso_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.276')">(TipologiaAccesso_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.276'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.276
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:code
Item: (TipologiaAccesso_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="@code">(TipologiaAccesso_Pr): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(TipologiaAccesso_Pr): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="@codeSystem">(TipologiaAccesso_Pr): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(TipologiaAccesso_Pr): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(TipologiaAccesso_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(TipologiaAccesso_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]">
      <extends rule="d16944e0-false-d16948e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('REFR')">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.281
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]
Item: (TipoVisita)
-->
   <rule fpi="RULC-1" id="d16944e0-false-d16948e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &gt;= 1">(TipoVisita): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &lt;= 1">(TipoVisita): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.281
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]
Item: (TipoVisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="string(@classCode) = ('ENC')">(TipoVisita): The value for classCode SHALL be 'ENC'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="string(@moodCode) = ('INT')">(TipoVisita): The value for moodCode SHALL be 'INT'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &gt;= 1">(TipoVisita): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &lt;= 1">(TipoVisita): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281'] appears too often [max 1x].</assert>
      <report fpi="CD-UNKN-BSP"
              role="warning"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">(TipoVisita): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set.</report>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1">(TipoVisita): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.281
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']
Item: (TipoVisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.281')">(TipoVisita): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.281'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.281
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]
Item: (TipoVisita)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]">
      <let name="theCode" value="@code"/>
      <let name="theCodeSystem" value="@codeSystem"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])">(TipoVisita): The element value SHALL be one of '2.16.840.1.113883.5.4 TipoVisita (DYNAMIC)'.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="@code">(TipoVisita): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(TipoVisita): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.5.4')">(TipoVisita): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(TipoVisita): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(TipoVisita): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]">
      <extends rule="d17063e0-false-d17067e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('AUTH')">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'AUTH'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1" id="d17063e0-false-d17067e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &gt;= 1">(NumeroProgressivo_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &lt;= 1">(NumeroProgressivo_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="string(@classCode) = ('ACT')">(NumeroProgressivo_Pr): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="string(@moodCode) = ('EVN')">(NumeroProgressivo_Pr): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &gt;= 1">(NumeroProgressivo_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &lt;= 1">(NumeroProgressivo_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:code[not(@nullFlavor)]) &gt;= 1">(NumeroProgressivo_Pr): element hl7:code[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:code[not(@nullFlavor)]) &lt;= 1">(NumeroProgressivo_Pr): element hl7:code[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.278')">(NumeroProgressivo_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.278'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(NumeroProgressivo_Pr): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="@codeSystem">(NumeroProgressivo_Pr): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(NumeroProgressivo_Pr): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(NumeroProgressivo_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(NumeroProgressivo_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:translation) &lt;= 1">(NumeroProgressivo_Pr): element hl7:translation appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]) &lt;= 1">(NumeroProgressivo_Pr): element hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &gt;= 1">(NumeroProgressivo_Pr): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &lt;= 1">(NumeroProgressivo_Pr): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.278
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']
Item: (NumeroProgressivo_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="@code">(NumeroProgressivo_Pr): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(NumeroProgressivo_Pr): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.55')">(NumeroProgressivo_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.55'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(NumeroProgressivo_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(NumeroProgressivo_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.93
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]
Item: (Prescrizione_Specialistica_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]">
      <extends rule="d17228e0-false-d17232e0"/>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html"
              test="string(@typeCode) = ('COMP')">(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'COMP'. Found: "<value-of select="@typeCode"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.277
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]
Item: (NumeroRipetizionisedute_Pr)
-->
   <rule fpi="RULC-1" id="d17228e0-false-d17232e0" abstract="true">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:observation) &gt;= 1">(NumeroRipetizionisedute_Pr): element hl7:observation is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:observation) &lt;= 1">(NumeroRipetizionisedute_Pr): element hl7:observation appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.277
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation
Item: (NumeroRipetizionisedute_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:templateId) &gt;= 1">(NumeroRipetizionisedute_Pr): element hl7:templateId is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:templateId) &lt;= 1">(NumeroRipetizionisedute_Pr): element hl7:templateId appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:repeatNumber[not(@nullFlavor)]) &gt;= 1">(NumeroRipetizionisedute_Pr): element hl7:repeatNumber[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="count(hl7:repeatNumber[not(@nullFlavor)]) &lt;= 1">(NumeroRipetizionisedute_Pr): element hl7:repeatNumber[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.277
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:templateId
Item: (NumeroRipetizionisedute_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:templateId">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.277') or not(@root)">(NumeroRipetizionisedute_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.277'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.277
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:repeatNumber[not(@nullFlavor)]
Item: (NumeroRipetizionisedute_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:repeatNumber[not(@nullFlavor)]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="@value">(NumeroRipetizionisedute_Pr): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html"
              test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')">(NumeroRipetizionisedute_Pr): Attribute @value is not a valid int number <value-of select="@value"/>
      </assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (Annotazioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1">(Annotazioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]
Item: (Annotazioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1">(Annotazioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1">(Annotazioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Annotazioniv2_PrS): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Annotazioniv2_PrS): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:title) &lt;= 1">(Annotazioniv2_PrS): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:text) &gt;= 1">(Annotazioniv2_PrS): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:text) &lt;= 1">(Annotazioniv2_PrS): element hl7:text appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1">(Annotazioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1">(Annotazioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']
Item: (Annotazioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')">(Annotazioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<value-of select="@root"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="@extension">(Annotazioniv2_PrS): attribute @extension SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="not(@extension) or string-length(@extension)&gt;0">(Annotazioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<value-of select="@extension"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0">(Annotazioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<value-of select="@assigningAuthorityName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Annotazioniv2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="string(@code) = ('48767-8')">(Annotazioniv2_PrS): The value for code SHALL be '48767-8'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Annotazioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Annotazioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Annotazioniv2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Annotazioniv2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:title
Item: (Annotazioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:text
Item: (Annotazioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.110
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Annotazioniv2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.91
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]
Item: (Elemento30NoteGenerali)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1">(Elemento30NoteGenerali): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1">(Elemento30NoteGenerali): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.91
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']
Item: (Elemento30NoteGenerali)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="string(@classCode) = ('ACT')">(Elemento30NoteGenerali): The value for classCode SHALL be 'ACT'. Found: "<value-of select="@classCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="string(@moodCode) = ('EVN')">(Elemento30NoteGenerali): The value for moodCode SHALL be 'EVN'. Found: "<value-of select="@moodCode"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:code) &gt;= 1">(Elemento30NoteGenerali): element hl7:code is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:code) &lt;= 1">(Elemento30NoteGenerali): element hl7:code appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:text) &gt;= 1">(Elemento30NoteGenerali): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:text) &lt;= 1">(Elemento30NoteGenerali): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.91
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code
Item: (Elemento30NoteGenerali)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="@code">(Elemento30NoteGenerali): attribute @code SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))">(Elemento30NoteGenerali): Attribute @code SHALL be of data type 'cs'  - '<value-of select="@code"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="@codeSystem">(Elemento30NoteGenerali): attribute @codeSystem SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')">(Elemento30NoteGenerali): Attribute @codeSystem SHALL be of data type 'uid'  - '<value-of select="@codeSystem"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Elemento30NoteGenerali): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Elemento30NoteGenerali): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.91
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:text
Item: (Elemento30NoteGenerali)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:text">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:reference) &gt;= 1">(Elemento30NoteGenerali): element hl7:reference is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="count(hl7:reference) &lt;= 1">(Elemento30NoteGenerali): element hl7:reference appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.91
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:text/hl7:reference
Item: (Elemento30NoteGenerali)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:text/hl7:reference">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="@value">(Elemento30NoteGenerali): attribute @value SHALL be present.</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.91-2022-07-13T073830.html"
              test="not(@value) or string-length(@value)&gt;0">(Elemento30NoteGenerali): Attribute @value SHALL be of data type 'st'  - '<value-of select="@value"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.111
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]
Item: (MessaggioRegionalev2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &gt;= 1">(MessaggioRegionalev2_PrS): element hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]) &lt;= 1">(MessaggioRegionalev2_PrS): element hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.111
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]
Item: (MessaggioRegionalev2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(MessaggioRegionalev2_PrS): element hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(MessaggioRegionalev2_PrS): element hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:title) &lt;= 1">(MessaggioRegionalev2_PrS): element hl7:title appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:text) &gt;= 1">(MessaggioRegionalev2_PrS): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="count(hl7:text) &lt;= 1">(MessaggioRegionalev2_PrS): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.111
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (MessaggioRegionalev2_PrS)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="string(@code) = ('51851-4')">(MessaggioRegionalev2_PrS): The value for code SHALL be '51851-4'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(MessaggioRegionalev2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="string(@codeSystemName) = ('LOINC')">(MessaggioRegionalev2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(MessaggioRegionalev2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.111-2022-07-19T114404.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(MessaggioRegionalev2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.111
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:title
Item: (MessaggioRegionalev2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.111
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]/hl7:text
Item: (MessaggioRegionalev2_PrS)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.263
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]
Item: (ParametriVitaliPr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]) &gt;= 1">(ParametriVitaliPr): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]) &lt;= 1">(ParametriVitaliPr): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.263
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]
Item: (ParametriVitaliPr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']) &gt;= 1">(ParametriVitaliPr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']) &lt;= 1">(ParametriVitaliPr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(ParametriVitaliPr): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(ParametriVitaliPr): element hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:text) &gt;= 1">(ParametriVitaliPr): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="count(hl7:text) &lt;= 1">(ParametriVitaliPr): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.263
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']
Item: (ParametriVitaliPr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.263')">(ParametriVitaliPr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.263'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.263
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (ParametriVitaliPr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]/hl7:code[(@code = '8716-3' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="string(@code) = ('8716-3')">(ParametriVitaliPr): The value for code SHALL be '8716-3'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(ParametriVitaliPr): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(ParametriVitaliPr): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(ParametriVitaliPr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.263-2022-11-14T170515.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(ParametriVitaliPr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.263
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]/hl7:text
Item: (ParametriVitaliPr)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.265
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]
Item: (Act_AllergieIntolleranze_Prf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.265
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]
Item: (Act_AllergieIntolleranze_Prf)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']) &gt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265'] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']) &lt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:text[not(@nullFlavor)]) &gt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:text[not(@nullFlavor)] is mandatory [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="count(hl7:text[not(@nullFlavor)]) &lt;= 1">(Act_AllergieIntolleranze_Prf): element hl7:text[not(@nullFlavor)] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.265
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']
Item: (Act_AllergieIntolleranze_Prf)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.265')">(Act_AllergieIntolleranze_Prf): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.265'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.265
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (Act_AllergieIntolleranze_Prf)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]/hl7:code[(@code = '48765-2' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="string(@code) = ('48765-2')">(Act_AllergieIntolleranze_Prf): The value for code SHALL be '48765-2'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(Act_AllergieIntolleranze_Prf): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(Act_AllergieIntolleranze_Prf): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(Act_AllergieIntolleranze_Prf): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.265-2022-11-15T185626.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(Act_AllergieIntolleranze_Prf): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.265
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]/hl7:text[not(@nullFlavor)]
Item: (Act_AllergieIntolleranze_Prf)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.2.9.10.1.2.2
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]
Item: (CDAClinicalDocument)
-->

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.270
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]
Item: (StatoDelPaziente_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]) &gt;= 1">(StatoDelPaziente_Pr): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]) &lt;= 1">(StatoDelPaziente_Pr): element hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']] appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.270
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]
Item: (StatoDelPaziente_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']) &gt;= 1">(StatoDelPaziente_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270'] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']) &lt;= 1">(StatoDelPaziente_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270'] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1">(StatoDelPaziente_Pr): element hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1">(StatoDelPaziente_Pr): element hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:text) &gt;= 1">(StatoDelPaziente_Pr): element hl7:text is required [min 1x].</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="count(hl7:text) &lt;= 1">(StatoDelPaziente_Pr): element hl7:text appears too often [max 1x].</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.270
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']
Item: (StatoDelPaziente_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.270')">(StatoDelPaziente_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.270'. Found: "<value-of select="@root"/>"</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.270
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]/hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')]
Item: (StatoDelPaziente_Pr)
-->
   <rule fpi="RULC-1"
         context="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]/hl7:code[(@code = '47420-5' and @codeSystem = '2.16.840.1.113883.6.1')]">
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="string(@code) = ('47420-5')">(StatoDelPaziente_Pr): The value for code SHALL be '47420-5'. Found: "<value-of select="@code"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="string(@codeSystem) = ('2.16.840.1.113883.6.1')">(StatoDelPaziente_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<value-of select="@codeSystem"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)">(StatoDelPaziente_Pr): The value for codeSystemName SHALL be 'LOINC'. Found: "<value-of select="@codeSystemName"/>"</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0">(StatoDelPaziente_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<value-of select="@codeSystemName"/>'</assert>
      <assert role="error"
              see="https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.270-2022-11-16T130016.html"
              test="not(@displayName) or string-length(@displayName)&gt;0">(StatoDelPaziente_Pr): Attribute @displayName SHALL be of data type 'st'  - '<value-of select="@displayName"/>'</assert>
   </rule>

   <!--
Template derived rules for ID: 2.16.840.1.113883.3.1937.777.63.10.270
Context: //hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]/hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]/hl7:text
Item: (StatoDelPaziente_Pr)
--></pattern>
