<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:xsd="http://www.w3.org/2001/XMLSchema"
                xmlns:saxon="http://saxon.sf.net/"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:schold="http://www.ascc.net/xml/schematron"
                xmlns:iso="http://purl.oclc.org/dsdl/schematron"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns:hl7="urn:hl7-org:v3"
                xmlns:cda="urn:hl7-org:v3"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:sdtc="urn:hl7-org:sdtc"
                xmlns:pharm="urn:ihe:pharm:medication"
                version="2.0"><!--Implementers: please note that overriding process-prolog or process-root is 
    the preferred method for meta-stylesheets to use where possible. -->
   <xsl:param name="archiveDirParameter"/>
   <xsl:param name="archiveNameParameter"/>
   <xsl:param name="fileNameParameter"/>
   <xsl:param name="fileDirParameter"/>
   <xsl:variable name="document-uri">
      <xsl:value-of select="document-uri(/)"/>
   </xsl:variable>

   <!--PHASES-->


   <!--PROLOG-->
   <xsl:output method="text"/>

   <!--XSD TYPES FOR XSLT2-->


   <!--KEYS AND FUNCTIONS-->


   <!--DEFAULT RULES-->


   <!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-select-full-path">
      <xsl:apply-templates select="." mode="schematron-get-full-path"/>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-->
   <!--This mode can be used to generate an ugly though full XPath for locators-->
   <xsl:template match="*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">
            <xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>*:</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>[namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="preceding"
                    select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/>
      <xsl:text>[</xsl:text>
      <xsl:value-of select="1+ $preceding"/>
      <xsl:text>]</xsl:text>
   </xsl:template>
   <xsl:template match="@*" mode="schematron-get-full-path">
      <xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <xsl:text>/</xsl:text>
      <xsl:choose>
         <xsl:when test="namespace-uri()=''">@<xsl:value-of select="name()"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>@*[local-name()='</xsl:text>
            <xsl:value-of select="local-name()"/>
            <xsl:text>' and namespace-uri()='</xsl:text>
            <xsl:value-of select="namespace-uri()"/>
            <xsl:text>']</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <!--MODE: SCHEMATRON-FULL-PATH-2-->
   <!--This mode can be used to generate prefixed XPath for humans-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-2">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>
   <!--MODE: SCHEMATRON-FULL-PATH-3-->
   <!--This mode can be used to generate prefixed XPath for humans 
	(Top-level element has index)-->
   <xsl:template match="node() | @*" mode="schematron-get-full-path-3">
      <xsl:for-each select="ancestor-or-self::*">
         <xsl:text>/</xsl:text>
         <xsl:value-of select="name(.)"/>
         <xsl:if test="parent::*">
            <xsl:text>[</xsl:text>
            <xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <xsl:text>]</xsl:text>
         </xsl:if>
      </xsl:for-each>
      <xsl:if test="not(self::*)">
         <xsl:text/>/@<xsl:value-of select="name(.)"/>
      </xsl:if>
   </xsl:template>

   <!--MODE: GENERATE-ID-FROM-PATH -->
   <xsl:template match="/" mode="generate-id-from-path"/>
   <xsl:template match="text()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/>
   </xsl:template>
   <xsl:template match="comment()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/>
   </xsl:template>
   <xsl:template match="processing-instruction()" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-from-path">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:value-of select="concat('.@', name())"/>
   </xsl:template>
   <xsl:template match="*" mode="generate-id-from-path" priority="-0.5">
      <xsl:apply-templates select="parent::*" mode="generate-id-from-path"/>
      <xsl:text>.</xsl:text>
      <xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/>
   </xsl:template>

   <!--MODE: GENERATE-ID-2 -->
   <xsl:template match="/" mode="generate-id-2">U</xsl:template>
   <xsl:template match="*" mode="generate-id-2" priority="2">
      <xsl:text>U</xsl:text>
      <xsl:number level="multiple" count="*"/>
   </xsl:template>
   <xsl:template match="node()" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>n</xsl:text>
      <xsl:number count="node()"/>
   </xsl:template>
   <xsl:template match="@*" mode="generate-id-2">
      <xsl:text>U.</xsl:text>
      <xsl:number level="multiple" count="*"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="string-length(local-name(.))"/>
      <xsl:text>_</xsl:text>
      <xsl:value-of select="translate(name(),':','.')"/>
   </xsl:template>
   <!--Strip characters-->
   <xsl:template match="text()" priority="-1"/>

   <!--SCHEMA SETUP-->
   <xsl:template match="/">
      <xsl:apply-templates select="/" mode="M8"/>
      <xsl:apply-templates select="/" mode="M9"/>
      <xsl:apply-templates select="/" mode="M10"/>
      <xsl:apply-templates select="/" mode="M11"/>
   </xsl:template>

   <!--SCHEMATRON PATTERNS-->


   <!--PATTERN -->
   <xsl:template match="text()" priority="-1" mode="M8"/>
   <xsl:template match="@*|node()" priority="-2" mode="M8">
      <xsl:apply-templates select="*" mode="M8"/>
   </xsl:template>

   <!--PATTERN CDAClinicalDocument-->


	  <!--RULE -->
   <xsl:template match="/" priority="1000" mode="M9">

		<!--ASSERT warning-->
      <xsl:choose>
         <xsl:when test="descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Instance is expected to have the following element: descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']] (descendant-or-self::hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']] / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>
   <xsl:template match="text()" priority="-1" mode="M9"/>
   <xsl:template match="@*|node()" priority="-2" mode="M9">
      <xsl:apply-templates select="*" mode="M9"/>
   </xsl:template>

   <!--PATTERN template-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732Prescrizione Specialistica (PrS)-->


	  <!--RULE d42e15-false-d480e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]"
                 priority="1349"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] is required [min 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02'] appears too often [max 1x]. (count(hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] is required [min 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V'] appears too often [max 1x]. (count(hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:languageCode is required [min 1x]. (count(hl7:languageCode) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:languageCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:languageCode appears too often [max 1x]. (count(hl7:languageCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:setId is required [min 1x]. (count(hl7:setId) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:versionNumber is required [min 1x]. (count(hl7:versionNumber) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] is required [min 1x]. (count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']] appears too often [max 1x]. (count(hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor] is required [min 1x]. (count(hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity] appears too often [max 1x]. (count(hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] is required [min 1x]. (count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']] appears too often [max 1x]. (count(hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']] appears too often [max 1x]. (count(hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:relatedDocument[@typeCode][hl7:parentDocument] appears too often [max 2x]. (count(hl7:relatedDocument[@typeCode][hl7:parentDocument]) &lt;= 2 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]] is required [min 1x]. (count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]] appears too often [max 1x]. (count(hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:structuredBody] is required [min 1x]. (count(hl7:component[hl7:structuredBody]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:structuredBody]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:structuredBody] appears too often [max 1x]. (count(hl7:component[hl7:structuredBody]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e18-false-d1115e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:realmCode"
                 priority="1348"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e37-false-d1131e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:typeId[@root = '2.16.840.1.113883.1.3'][@extension = 'POCD_MT000040UV02']"
                 priority="1347"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.1.3'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('POCD_MT000040UV02')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for extension SHALL be 'POCD_MT000040UV02'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('POCD_MT000040UV02') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e72-false-d1150e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']"
                 priority="1346"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.10.1.2.2')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.2.9.10.1.2.2'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.10.1.2.2') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@extension) = ('2.3')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for extension SHALL be '2.3'. Found: "<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>" (string(@extension) = ('2.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e91-false-d1169e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']"
                 priority="1345"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.9') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e115-false-d1190e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1344"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('57832-8')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for code SHALL be '57832-8'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('57832-8') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@displayName) = ('Prescrizione specialistica') or not(@displayName)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for displayName SHALL be 'Prescrizione specialistica'. Found: "<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>" (string(@displayName) = ('Prescrizione specialistica') or not(@displayName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e140-false-d1221e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation"
                 priority="1343"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:qualifier[hl7:name[@code = 'TP']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:qualifier[hl7:name[@code = 'TP']] is mandatory [min 1x]. (count(hl7:qualifier[hl7:name[@code = 'TP']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:qualifier[hl7:name[@code = 'TP']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:qualifier[hl7:name[@code = 'TP']] appears too often [max 1x]. (count(hl7:qualifier[hl7:name[@code = 'TP']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e175-false-d1253e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]"
                 priority="1342"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name[@code = 'TP']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:name[@code = 'TP'] is mandatory [min 1x]. (count(hl7:name[@code = 'TP']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name[@code = 'TP']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:name[@code = 'TP'] appears too often [max 1x]. (count(hl7:name[@code = 'TP']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:value appears too often [max 1x]. (count(hl7:value) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e181-false-d1277e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:name[@code = 'TP']"
                 priority="1341"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('TP')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for code SHALL be 'TP'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('TP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.5.2.1') or not(@codeSystem)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.5.2.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.5.2.1') or not(@codeSystem) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('Classificazione Prescrizione') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystemName SHALL be 'Classificazione Prescrizione'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('Classificazione Prescrizione') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e186-false-d1302e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:code[(@code = '57832-8' and @codeSystem = '2.16.840.1.113883.6.1')]/hl7:translation/hl7:qualifier[hl7:name[@code = 'TP']]/hl7:value"
                 priority="1340"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e215-false-d1330e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:effectiveTime"
                 priority="1339"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e231-false-d1344e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:confidentialityCode[@codeSystem = '2.16.840.1.113883.5.25' or @code = 'N' or @code = 'V']"
                 priority="1338"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or (@code='N') or (@code='V')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The element value SHALL be one of 'code 'N' or code 'V''. (@nullFlavor or (@code='N') or (@code='V') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.25')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystem SHALL be '2.16.840.1.113883.5.25'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.25') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for codeSystemName SHALL be 'HL7 Confidentiality'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 Confidentiality') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e263-false-d1377e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:languageCode"
                 priority="1337"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e282-false-d1390e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:setId"
                 priority="1336"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e308-false-d1411e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:versionNumber"
                 priority="1335"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): Attribute @value is not a valid int number <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       (not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e19-false-d1505e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]"
                 priority="1334"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('RCT')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for typeCode SHALL be 'RCT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('RCT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] is required [min 1x]. (count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']] appears too often [max 1x]. (count(hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e26-false-d1689e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]"
                 priority="1333"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PAT')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'PAT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PAT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] is required [min 1x]. (count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]] appears too often [max 1x]. (count(hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e31-false-d1813e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:id"
                 priority="1332"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:addr"
                 priority="1331"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e113-false-d1985e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:telecom"
                 priority="1329"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e132-false-d2055e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]"
                 priority="1328"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:name is required [min 1x]. (count(hl7:name) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] is required [min 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:birthTime is required [min 1x]. (count(hl7:birthTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:birthTime appears too often [max 1x]. (count(hl7:birthTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardian[@classCode = 'GUARD']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:guardian[@classCode = 'GUARD'] is required [min 1x]. (count(hl7:guardian[@classCode = 'GUARD']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']] appears too often [max 1x]. (count(hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e139-false-d2151e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:name"
                 priority="1327"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e163-false-d2194e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1326"
                 mode="M10">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The element value SHALL be one of '2.16.840.1.113883.1.11.1 AdministrativeGender (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.1')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for codeSystem SHALL be '2.16.840.1.113883.5.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for codeSystemName SHALL be 'HL7 AdministrativeGender'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('HL7 AdministrativeGender') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e184-false-d2229e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthTime"
                 priority="1325"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e193-false-d2283e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']"
                 priority="1324"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('GUARD')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'GUARD'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('GUARD') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e199-false-d2365e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:id"
                 priority="1323"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e207-false-d2386e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:code"
                 priority="1322"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:addr"
                 priority="1321"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e232-false-d2561e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:telecom"
                 priority="1319"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
                 priority="1318"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1317"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1316"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1315"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1314"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1312"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1310"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1309"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1308"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1306"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1305"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1304"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1302"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1300"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1299"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:guardian[@classCode = 'GUARD']/hl7:guardianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1298"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e254-false-d3665e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]"
                 priority="1297"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('BIRTHPL')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'BIRTHPL'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('BIRTHPL') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] is required [min 1x]. (count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e260-false-d3685e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']"
                 priority="1296"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PLC')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for classCode SHALL be 'PLC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PLC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:addr is required [min 1x]. (count(hl7:addr) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d1418e283-false-d3709e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:patient[hl7:administrativeGenderCode[@codeSystem = '2.16.840.1.113883.5.1' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.1-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]]/hl7:birthplace[@classCode = 'BIRTHPL'][hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']]/hl7:place[@classCode = 'PLC'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1295"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArecordTarget): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.18-2023-04-18T104742.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1294"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1293"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1292"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1291"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1289"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1287"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1286"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1285"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1283"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1282"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1281"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1279"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1277"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1276"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:recordTarget[@contextControlCode = 'OP'][@typeCode = 'RCT'][hl7:patientRole[@classCode = 'PAT']]/hl7:patientRole[@classCode = 'PAT'][hl7:patient[@classCode = 'PSN'][@determinerCode = 'INSTANCE']]/hl7:providerOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1275"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e395-false-d4844e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]"
                 priority="1274"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUT')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): The value for typeCode SHALL be 'AUT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:assignedAuthor[hl7:assignedPerson] is required [min 1x]. (count(hl7:assignedAuthor[hl7:assignedPerson]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:assignedAuthor[hl7:assignedPerson] appears too often [max 1x]. (count(hl7:assignedAuthor[hl7:assignedPerson]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e408-false-d4923e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:time"
                 priority="1273"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e430-false-d4983e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]"
                 priority="1272"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:assignedPerson is required [min 1x]. (count(hl7:assignedPerson) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e437-false-d5072e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:id"
                 priority="1271"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e474-false-d5093e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:code"
                 priority="1270"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:addr"
                 priority="1269"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d3792e514-false-d5278e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:telecom"
                 priority="1267"
                 mode="M10">
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthor): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.39-2023-04-18T141637.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson"
                 priority="1266"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDApersonDocGen): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:assignedPerson/hl7:name"
                 priority="1265"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1264"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1263"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1262"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1261"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1259"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1257"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1256"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1255"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1253"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1252"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1251"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1249"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1247"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1246"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:author[@contextControlCode = 'OP'][@typeCode = 'AUT'][hl7:assignedAuthor]/hl7:assignedAuthor[hl7:assignedPerson]/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1245"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d5474e362-false-d6527e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]"
                 priority="1244"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('ENT')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): The value for typeCode SHALL be 'ENT'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('ENT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d5474e374-false-d6605e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:time"
                 priority="1243"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAdataEnterer): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.64-2022-07-05T105555.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity"
                 priority="1242"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:id"
                 priority="1241"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:code"
                 priority="1240"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:addr"
                 priority="1239"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:telecom"
                 priority="1237"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1236"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDApersonDocGen): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1235"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1234"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1233"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1232"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1231"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1229"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1227"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1226"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1225"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1223"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1222"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1221"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1219"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1217"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1216"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:dataEnterer[@contextControlCode = 'OP'][@typeCode = 'ENT'][hl7:assignedEntity]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1215"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d6671e520-false-d8223e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]"
                 priority="1214"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('CST')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for typeCode SHALL be 'CST'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('CST') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] is required [min 1x]. (count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] appears too often [max 1x]. (count(hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d6671e530-false-d8261e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]"
                 priority="1213"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] is required [min 1x]. (count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d6671e540-false-d8299e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1212"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:addr) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): element hl7:addr appears too often [max 1x]. (count(hl7:addr) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d6671e546-false-d8344e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1211"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d6671e580-false-d8373e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1210"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:custodian[@typeCode = 'CST'][hl7:assignedCustodian[@classCode = 'ASSIGNED']]/hl7:assignedCustodian[@classCode = 'ASSIGNED'][hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:representedCustodianOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1209"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAcustodian): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.41-2022-07-04T140514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8415e77-false-d8602e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1207"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LA') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): The value for typeCode SHALL be 'LA'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LA') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8415e89-false-d8691e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1206"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8415e105-false-d8705e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1205"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDAlegalAuthenticator): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.42-2022-07-04T141454.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1204"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1203"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1202"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1201"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1199"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1198"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDApersonDocGen): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1197"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1196"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1195"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1194"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1193"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1191"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1189"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1188"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1187"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1185"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1184"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1183"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1181"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1179"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1178"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:legalAuthenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1177"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8769e520-false-d10361e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]"
                 priority="1176"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTHEN') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): The value for typeCode SHALL be 'AUTHEN'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUTHEN') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:time is required [min 1x]. (count(hl7:time) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:signatureCode[@code = 'S'] is required [min 1x]. (count(hl7:signatureCode[@code = 'S']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:signatureCode[@code = 'S']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:signatureCode[@code = 'S'] appears too often [max 1x]. (count(hl7:signatureCode[@code = 'S']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:assignedEntity is required [min 1x]. (count(hl7:assignedEntity) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedEntity) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): element hl7:assignedEntity appears too often [max 1x]. (count(hl7:assignedEntity) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8769e541-false-d10446e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:time"
                 priority="1175"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d8769e551-false-d10460e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:signatureCode[@code = 'S']"
                 priority="1174"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('S')"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): The value for code SHALL be 'S'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('S') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or string-length(@code)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAauthenticator): Attribute @code SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or string-length(@code)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.62-2022-07-05T102138.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity"
                 priority="1173"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ASSIGNED') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for classCode SHALL be 'ASSIGNED'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ASSIGNED') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:assignedPerson) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:assignedPerson appears too often [max 1x]. (count(hl7:assignedPerson) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): element hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:id"
                 priority="1172"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:code"
                 priority="1171"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:addr"
                 priority="1170"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:telecom"
                 priority="1168"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAAssignedEntity): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.36-2022-07-04T105059.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson"
                 priority="1167"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDApersonDocGen): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:assignedPerson/hl7:name"
                 priority="1166"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1165"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1164"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1163"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1162"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1160"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1158"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1157"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1156"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1154"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1153"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1152"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1150"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1148"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1147"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:authenticator[hl7:signatureCode[@code = 'S']]/hl7:assignedEntity/hl7:representedOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1146"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e512-false-d12117e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]"
                 priority="1145"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @typeCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>' (not(@typeCode) or (string-length(@typeCode) &gt; 0 and not(matches(@typeCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextControlCode) = ('OP') or not(@contextControlCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for contextControlCode SHALL be 'OP'. Found: "<xsl:text/>
               <xsl:value-of select="@contextControlCode"/>
               <xsl:text/>" (string(@contextControlCode) = ('OP') or not(@contextControlCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:time) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:time appears too often [max 1x]. (count(hl7:time) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:associatedEntity[@classCode] is required [min 1x]. (count(hl7:associatedEntity[@classCode]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedEntity[@classCode]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:associatedEntity[@classCode] appears too often [max 1x]. (count(hl7:associatedEntity[@classCode]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e531-false-d12207e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:functionCode[concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1144"
                 mode="M10">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The element value SHALL be one of '2.16.840.1.113883.1.11.10267 ParticipationFunction (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.1.11.10267-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e561-false-d12240e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time"
                 priority="1143"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:high) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:high appears too often [max 1x]. (count(hl7:high) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e568-false-d12257e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:time/hl7:high"
                 priority="1142"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^[0-9]{4,14}')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @value SHALL be of data type 'ts'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or matches(string(@value), '^[0-9]{4,14}') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e575-false-d12317e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]"
                 priority="1141"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@classCode"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @classCode SHALL be present. (@classCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @classCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>' (not(@classCode) or (string-length(@classCode) &gt; 0 and not(matches(@classCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): element hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e610-false-d12409e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:id"
                 priority="1140"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e629-false-d12430e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:code"
                 priority="1139"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for code SHALL be selected from value set '2.16.840.1.113883.3.1937.777.63.11.12' RoleCodeIT (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.3.1937.777.63.11.12-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:addr"
                 priority="1138"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d10527e682-false-d12615e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:telecom"
                 priority="1136"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']"
                 priority="1135"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDApersonDocGen): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.54-2022-07-04T150236.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PSN')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for classCode SHALL be 'PSN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PSN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAparticipant): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.63-2022-07-05T103055.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:associatedPerson[@classCode = 'PSN'][@determinerCode = 'INSTANCE']/hl7:name"
                 priority="1133"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given is required [min 1x]. (count(hl7:given) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:given) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:given appears too often [max 1x]. (count(hl7:given) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family is required [min 1x]. (count(hl7:family) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:family) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:family appears too often [max 1x]. (count(hl7:family) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:prefix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:prefix appears too often [max 1x]. (count(hl7:prefix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:suffix) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAnameDocGen): element hl7:suffix appears too often [max 1x]. (count(hl7:suffix) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.60-2022-07-04T151659.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1132"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1131"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1130"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1129"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1127"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1125"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1124"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1123"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1121"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1120"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1119"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1117"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1115"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1114"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:participant[@typeCode][hl7:associatedEntity[@classCode]]/hl7:associatedEntity[@classCode]/hl7:scopingOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1113"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d12811e362-false-d13816e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]"
                 priority="1112"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@typeCode"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): attribute @typeCode SHALL be present. (@typeCode / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@typeCode),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): The value for typeCode SHALL be selected from value set '2.16.840.1.113883.1.11.11610' x_ActRelationshipDocument (DYNAMIC). (not(@typeCode) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.11610-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:parentDocument is required [min 1x]. (count(hl7:parentDocument) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:parentDocument) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:parentDocument appears too often [max 1x]. (count(hl7:parentDocument) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d12811e399-false-d13847e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument"
                 priority="1111"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCCLIN') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): The value for classCode SHALL be 'DOCCLIN'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCCLIN') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:setId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:setId appears too often [max 1x]. (count(hl7:setId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:versionNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): element hl7:versionNumber appears too often [max 1x]. (count(hl7:versionNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d12811e427-false-d13893e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:id"
                 priority="1110"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d12811e443-false-d13914e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:relatedDocument[@typeCode][hl7:parentDocument]/hl7:parentDocument/hl7:code"
                 priority="1109"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDArelatedDocument): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.66-2022-07-05T123541.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d13956e15-false-d13994e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]"
                 priority="1108"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']] is required [min 1x]. (count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']] appears too often [max 1x]. (count(hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d13956e22-false-d14076e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]"
                 priority="1107"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ENC') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for classCode SHALL be 'ENC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ENC') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4'] is required [min 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4'] appears too often [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:effectiveTime is required [min 1x]. (count(hl7:effectiveTime) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']] is required [min 1x]. (count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']] appears too often [max 1x]. (count(hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d13956e48-false-d14148e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4']"
                 priority="1106"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.4')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d13956e83-false-d14209e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]"
                 priority="1105"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LOC')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for typeCode SHALL be 'LOC'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LOC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] is required [min 1x]. (count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']] appears too often [max 1x]. (count(hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d13956e85-false-d14289e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]"
                 priority="1104"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('SDLOC')"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): The value for classCode SHALL be 'SDLOC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('SDLOC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:id is required [min 1x]. (count(hl7:id) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:id appears too often [max 1x]. (count(hl7:id) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] is required [min 1x]. (count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAcomponentOf): element hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.95-2022-07-13T124319.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1103"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1102"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1101"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1100"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1098"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1096"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1095"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1094"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ORG')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'ORG'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ORG') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@determinerCode) = ('INSTANCE')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for determinerCode SHALL be 'INSTANCE'. Found: "<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>" (string(@determinerCode) = ('INSTANCE') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:name) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:name appears too often [max 1x]. (count(hl7:name) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): element hl7:asOrganizationPartOf[@classCode = 'PART'] appears too often [max 1x]. (count(hl7:asOrganizationPartOf[@classCode = 'PART']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:id"
                 priority="1092"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:telecom"
                 priority="1091"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:addr"
                 priority="1090"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country is required [min 1x]. (count(hl7:country) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:country) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:country appears too often [max 1x]. (count(hl7:country) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:state) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:state appears too often [max 1x]. (count(hl7:state) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:county) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:county appears too often [max 1x]. (count(hl7:county) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city is required [min 1x]. (count(hl7:city) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:city) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:city appears too often [max 1x]. (count(hl7:city) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:postalCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:postalCode appears too often [max 1x]. (count(hl7:postalCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine is required [min 1x]. (count(hl7:streetAddressLine) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:streetAddressLine) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:streetAddressLine appears too often [max 1x]. (count(hl7:streetAddressLine) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:censusTract) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAaddrDocGen): element hl7:censusTract appears too often [max 1x]. (count(hl7:censusTract) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.34-2022-07-04T103903.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@use"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): attribute @use SHALL be present. (@use / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@use),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for use SHALL be selected from value set '2.16.840.1.113883.5.1119' AddressUse (DYNAMIC). (not(@use) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.5.1119-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']"
                 priority="1088"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:statusCode) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:statusCode appears too often [max 1x]. (count(hl7:statusCode) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:effectiveTime) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:effectiveTime appears too often [max 1x]. (count(hl7:effectiveTime) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): element hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE'] appears too often [max 1x]. (count(hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CDAOrganization): Attribute @determinerCode SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@determinerCode"/>
               <xsl:text/>' (not(@determinerCode) or (string-length(@determinerCode) &gt; 0 and not(matches(@determinerCode,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.58-2022-07-04T151259.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:id"
                 priority="1086"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@root"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @root SHALL be present. (@root / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @root SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>' (not(@root) or matches(@root,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@root,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@root,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@assigningAuthorityName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @assigningAuthorityName SHALL be present. (@assigningAuthorityName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:code"
                 priority="1085"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystemName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @codeSystemName SHALL be present. (@codeSystemName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@displayName"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): attribute @displayName SHALL be present. (@displayName / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:componentOf[hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]]/hl7:encompassingEncounter[hl7:code[@codeSystem = '2.16.840.1.113883.5.4']]/hl7:location[@typeCode = 'LOC'][hl7:healthCareFacility[@classCode = 'SDLOC']]/hl7:healthCareFacility[@classCode = 'SDLOC'][hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']]/hl7:serviceProviderOrganization[@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']/hl7:asOrganizationPartOf[@classCode = 'PART']/hl7:wholeOrganization[@classCode = 'PART'][@classCode = 'ORG'][@determinerCode = 'INSTANCE']"
                 priority="1084"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('PART')"/>
         <xsl:otherwise>
            <xsl:message>(CDAorganizationPartOfDocGen): The value for classCode SHALL be 'PART'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('PART') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.59-2022-07-04T151404.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e336-false-d15438e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]"
                 priority="1083"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@contextConductionInd) = ('true') or not(@contextConductionInd)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for contextConductionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@contextConductionInd"/>
               <xsl:text/>" (string(@contextConductionInd) = ('true') or not(@contextConductionInd) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:structuredBody is required [min 1x]. (count(hl7:structuredBody) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:structuredBody) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:structuredBody appears too often [max 1x]. (count(hl7:structuredBody) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE d42e339-false-d15554e0-->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody"
                 priority="1082"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('DOCBODY') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for classCode SHALL be 'DOCBODY'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('DOCBODY') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN') or not(@moodCode)"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') or not(@moodCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] is required [min 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:code[(@code = '51851-4' and @codeSystem = '2.16.840.1.113883.6.1')]]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.263']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.265']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CDAClinicalDocument): element hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]] appears too often [max 1x]. (count(hl7:component[hl7:section[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.270']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.2.9.10.1.2.2-2022-07-13T115732.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
                 priority="1081"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] is required [min 1x]. (count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x]. (count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]"
                 priority="1080"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] is required [min 1x]. (count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x]. (count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']"
                 priority="1079"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.9') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1078"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('57827-8')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): The value for code SHALL be '57827-8'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('57827-8') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioniv2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.108-2022-07-19T111237.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]"
                 priority="1077"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] is required [min 1x]. (count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:act[@classCode = 'ACT'][@moodCode = 'EVN'] appears too often [max 1x]. (count(hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']"
                 priority="1076"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code"
                 priority="1075"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:originalText) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:originalText appears too often [max 1x]. (count(hl7:originalText) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText"
                 priority="1074"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:reference is required [min 1x]. (count(hl7:reference) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): element hl7:reference appears too often [max 1x]. (count(hl7:reference) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57827-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]/hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']/hl7:code/hl7:originalText/hl7:reference"
                 priority="1073"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Esenzioni_PrF_entry_2): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.89-2022-07-13T072020.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
                 priority="1072"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] is required [min 1x]. (count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x]. (count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]"
                 priority="1071"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']] is required [min 1x]. (count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): element hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']] appears too often [max 1x]. (count(hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']"
                 priority="1070"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.9') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1069"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('57828-6')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): The value for code SHALL be '57828-6'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('57828-6') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizioniv2_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.109-2022-07-19T112543.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]"
                 priority="1068"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']] is required [min 1x]. (count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']] appears too often [max 1x]. (count(hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]"
                 priority="1067"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('OBS')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for classCode SHALL be 'OBS'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('OBS') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('RQO')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for moodCode SHALL be 'RQO'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('RQO') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7'] appears too often [max 1x]. (count(hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:repeatNumber) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:repeatNumber appears too often [max 1x]. (count(hl7:repeatNumber) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participant) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:participant appears too often [max 1x]. (count(hl7:participant) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]] appears too often [max 1x]. (count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]] is required [min 1x]. (count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]] appears too often [max 1x]. (count(hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]] appears too often [max 1x]. (count(hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation] appears too often [max 1x]. (count(hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code"
                 priority="1066"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:code/hl7:translation"
                 priority="1065"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']"
                 priority="1064"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for code SHALL be selected from value set '2.16.840.1.113883.1.11.16866' ActPriority (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.1.11.16866-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.7')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.5.7'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.7') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('ActPriority') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for codeSystemName SHALL be 'ActPriority'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('ActPriority') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:priorityCode[@codeSystem = '2.16.840.1.113883.5.7']/hl7:translation"
                 priority="1063"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystem SHALL be of data type 'oid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:repeatNumber"
                 priority="1062"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @value is not a valid int number <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       (not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant"
                 priority="1061"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('LOC') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'LOC'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('LOC') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]] appears too often [max 1x]. (count(hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]"
                 priority="1060"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ROL') or not(@classCode)"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for classCode SHALL be 'ROL'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ROL') or not(@classCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']] is mandatory [min 1x]. (count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']] appears too often [max 1x]. (count(hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]"
                 priority="1059"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1'] is required [min 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1'] appears too often [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:participant/hl7:participantRole[hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]]/hl7:scopingEntity[hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.1']"
                 priority="1058"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="theAttValue"
                    select="distinct-values(tokenize(normalize-space(@code),'\s'))"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.9.6.3.1.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))])"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for code SHALL be selected from value set '2.16.840.1.113883.2.9.6.3.1.1' Tipo Ambulatoriale SP (DYNAMIC). (not(@code) or empty($theAttValue[not(. = (doc('include/voc-2.16.840.1.113883.2.9.6.3.1.1-DYNAMIC.xml')/*/valueSet/conceptList/concept/@code))]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.1')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.3.1.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]"
                 priority="1057"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']] is mandatory [min 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']] appears too often [max 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('SUBJ')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'SUBJ'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('SUBJ') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@typeCode) or string-length(@typeCode)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @typeCode SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>' (not(@typeCode) or string-length(@typeCode)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@inversionInd) = ('true')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for inversionInd SHALL be 'true'. Found: "<xsl:text/>
               <xsl:value-of select="@inversionInd"/>
               <xsl:text/>" (string(@inversionInd) = ('true') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@inversionInd) or string-length(@inversionInd)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): Attribute @inversionInd SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@inversionInd"/>
               <xsl:text/>' (not(@inversionInd) or string-length(@inversionInd)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]"
                 priority="1055"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']"
                 priority="1054"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.274')"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.274'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.274') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1053"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('48767-8')"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for code SHALL be '48767-8'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('48767-8') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text"
                 priority="1052"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:reference is required [min 1x]. (count(hl7:reference) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:reference) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): element hl7:reference appears too often [max 1x]. (count(hl7:reference) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.274']]/hl7:text/hl7:reference"
                 priority="1051"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or string-length(@value)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NotaEsplicativa_Pr): Attribute @value SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>' (not(@value) or string-length(@value)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.274-2023-01-04T121800.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]"
                 priority="1050"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']] is required [min 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']] appears too often [max 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('REFR') or not(@typeCode)"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('REFR') or not(@typeCode) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]"
                 priority="1048"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3'] is required [min 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): element hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3'] appears too often [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']"
                 priority="1047"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.275')"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.275'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.275') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.275']]/hl7:code[@codeSystem = '2.16.840.1.113883.2.9.6.3.1.3']"
                 priority="1046"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.3')"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.3.1.3'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.6.3.1.3') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(CodicePatologia_Pr): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.275-2023-01-04T123203.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]"
                 priority="1045"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']] is required [min 1x]. (count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']] appears too often [max 1x]. (count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('REFR')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('REFR') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]"
                 priority="1043"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ENC')"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): The value for classCode SHALL be 'ENC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ENC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('INT')"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): The value for moodCode SHALL be 'INT'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('INT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:code is required [min 1x]. (count(hl7:code) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): element hl7:code appears too often [max 1x]. (count(hl7:code) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']"
                 priority="1042"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.276')"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.276'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.276') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.276']]/hl7:code"
                 priority="1041"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(TipologiaAccesso_Pr): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.276-2023-01-04T124950.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]"
                 priority="1040"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']] is required [min 1x]. (count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): element hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']] appears too often [max 1x]. (count(hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('REFR')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'REFR'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('REFR') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]"
                 priority="1038"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ENC')"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): The value for classCode SHALL be 'ENC'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ENC') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('INT')"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): The value for moodCode SHALL be 'INT'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('INT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281'] is required [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--REPORT warning-->
      <xsl:if test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1">
         <xsl:message>(TipoVisita): element hl7:code is coded with binding strength 'extensible' and contains a code other than the specified set. (count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt; 1 / warning / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
      </xsl:if>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): element hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)] appears too often [max 1x]. (count(hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']"
                 priority="1037"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.281')"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.281'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.281') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]]/hl7:encounter[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.281']]/hl7:code[@codeSystem = '2.16.840.1.113883.5.4' or concat(@code, @codeSystem) = doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1]/conceptList/concept/concat(@code, @codeSystem)]"
                 priority="1036"
                 mode="M10">
      <xsl:variable name="theCode" select="@code"/>
      <xsl:variable name="theCodeSystem" select="@codeSystem"/>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]])"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): The element value SHALL be one of '2.16.840.1.113883.5.4 TipoVisita (DYNAMIC)'. (@nullFlavor or exists(doc('include/voc-2.16.840.1.113883.5.4-DYNAMIC.xml')//valueSet[1][conceptList/concept[@code = $theCode][@codeSystem = $theCodeSystem]]) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.5.4')"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): The value for codeSystem SHALL be '2.16.840.1.113883.5.4'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.5.4') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(TipoVisita): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.281-2023-01-23T102302.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]"
                 priority="1035"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']] is mandatory [min 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']] appears too often [max 1x]. (count(hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('AUTH')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'AUTH'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('AUTH') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]"
                 priority="1033"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@classCode) = ('ACT')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): The value for classCode SHALL be 'ACT'. Found: "<xsl:text/>
               <xsl:value-of select="@classCode"/>
               <xsl:text/>" (string(@classCode) = ('ACT') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@moodCode) = ('EVN')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): The value for moodCode SHALL be 'EVN'. Found: "<xsl:text/>
               <xsl:value-of select="@moodCode"/>
               <xsl:text/>" (string(@moodCode) = ('EVN') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278'] is mandatory [min 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278'] appears too often [max 1x]. (count(hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[not(@nullFlavor)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:code[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:code[not(@nullFlavor)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[not(@nullFlavor)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:code[not(@nullFlavor)] appears too often [max 1x]. (count(hl7:code[not(@nullFlavor)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']"
                 priority="1032"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.278')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.278'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.278') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]"
                 priority="1031"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@codeSystem"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): attribute @codeSystem SHALL be present. (@codeSystem / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @codeSystem SHALL be of data type 'uid'  - '<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>' (not(@codeSystem) or matches(@codeSystem,'^[0-2](\.(0|[1-9]\d*))*$') or matches(@codeSystem,'^[A-Fa-f\d]{8}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{4}-[A-Fa-f\d]{12}$') or matches(@codeSystem,'^[A-Za-z][A-Za-z\d\-]*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:translation) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:translation appears too often [max 1x]. (count(hl7:translation) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation"
                 priority="1030"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']] appears too often [max 1x]. (count(hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]"
                 priority="1029"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55'] is required [min 1x]. (count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): element hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55'] appears too often [max 1x]. (count(hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]]/hl7:act[hl7:templateId[@root = '2.16.840.1.113883.3.1937.777.63.10.278']]/hl7:code[not(@nullFlavor)]/hl7:translation/hl7:qualifier[hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']]/hl7:value[@codeSystem = '2.16.840.1.113883.2.9.6.1.55']"
                 priority="1028"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@code"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): attribute @code SHALL be present. (@code / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s')))"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @code SHALL be of data type 'cs'  - '<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>' (not(@code) or (string-length(@code) &gt; 0 and not(matches(@code,'\s'))) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.55')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): The value for codeSystem SHALL be '2.16.840.1.113883.2.9.6.1.55'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.2.9.6.1.55') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@codeSystemName) or string-length(@codeSystemName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @codeSystemName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>' (not(@codeSystemName) or string-length(@codeSystemName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@displayName) or string-length(@displayName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(NumeroProgressivo_Pr): Attribute @displayName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@displayName"/>
               <xsl:text/>' (not(@displayName) or string-length(@displayName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.278-2023-01-04T142525.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]"
                 priority="1027"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:observation is required [min 1x]. (count(hl7:observation) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:observation) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:observation appears too often [max 1x]. (count(hl7:observation) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@typeCode) = ('COMP')"/>
         <xsl:otherwise>
            <xsl:message>(Prescrizione_Specialistica_PrS): The value for typeCode SHALL be 'COMP'. Found: "<xsl:text/>
               <xsl:value-of select="@typeCode"/>
               <xsl:text/>" (string(@typeCode) = ('COMP') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.93-2022-07-13T082303.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation"
                 priority="1025"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:templateId is required [min 1x]. (count(hl7:templateId) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:templateId) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:templateId appears too often [max 1x]. (count(hl7:templateId) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:repeatNumber[not(@nullFlavor)]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:repeatNumber[not(@nullFlavor)] is mandatory [min 1x]. (count(hl7:repeatNumber[not(@nullFlavor)]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:repeatNumber[not(@nullFlavor)]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): element hl7:repeatNumber[not(@nullFlavor)] appears too often [max 1x]. (count(hl7:repeatNumber[not(@nullFlavor)]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:templateId"
                 priority="1024"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.277') or not(@root)"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): The value for root SHALL be '2.16.840.1.113883.3.1937.777.63.10.277'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.3.1937.777.63.10.277') or not(@root) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '57828-6' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:entry[hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO']]/hl7:observation[@classCode = 'OBS'][@moodCode = 'RQO'][hl7:entryRelationship[@typeCode = 'REFR']]/hl7:entryRelationship[@typeCode = 'COMP'][hl7:observation]/hl7:observation/hl7:repeatNumber[not(@nullFlavor)]"
                 priority="1023"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@value"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): attribute @value SHALL be present. (@value / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$')"/>
         <xsl:otherwise>
            <xsl:message>(NumeroRipetizionisedute_Pr): Attribute @value is not a valid int number <xsl:text/>
               <xsl:value-of select="@value"/>
               <xsl:text/>
       (not(@value) or matches(string(@value), '^-?[1-9]\d*$|^+?\d*$') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.277-2023-01-04T130613.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]"
                 priority="1022"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']] appears too often [max 1x]. (count(hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]"
                 priority="1021"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] is required [min 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9'] appears too often [max 1x]. (count(hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] is required [min 1x]. (count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')] appears too often [max 1x]. (count(hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:title) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:title appears too often [max 1x]. (count(hl7:title) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:text is required [min 1x]. (count(hl7:text) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:text) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:text appears too often [max 1x]. (count(hl7:text) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] is required [min 1x]. (count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &gt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): element hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']] appears too often [max 1x]. (count(hl7:entry[hl7:act[@classCode = 'ACT'][@moodCode = 'EVN']]) &lt;= 1 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']"
                 priority="1020"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@root) = ('2.16.840.1.113883.2.9.4.3.9')"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): The value for root SHALL be '2.16.840.1.113883.2.9.4.3.9'. Found: "<xsl:text/>
               <xsl:value-of select="@root"/>
               <xsl:text/>" (string(@root) = ('2.16.840.1.113883.2.9.4.3.9') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="@extension"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): attribute @extension SHALL be present. (@extension / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@extension) or string-length(@extension)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): Attribute @extension SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@extension"/>
               <xsl:text/>' (not(@extension) or string-length(@extension)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): Attribute @assigningAuthorityName SHALL be of data type 'st'  - '<xsl:text/>
               <xsl:value-of select="@assigningAuthorityName"/>
               <xsl:text/>' (not(@assigningAuthorityName) or string-length(@assigningAuthorityName)&gt;0 / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="*" mode="M10"/>
   </xsl:template>

	  <!--RULE -->
   <xsl:template match="//hl7:ClinicalDocument[hl7:templateId[@root = '2.16.840.1.113883.2.9.10.1.2.2'][@extension = '2.3']]/hl7:component[hl7:structuredBody]/hl7:structuredBody/hl7:component[hl7:section[hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]]]/hl7:section[hl7:id[@root = '2.16.840.1.113883.2.9.4.3.9']]/hl7:code[(@code = '48767-8' and @codeSystem = '2.16.840.1.113883.6.1')]"
                 priority="1019"
                 mode="M10">

		<!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@code) = ('48767-8')"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): The value for code SHALL be '48767-8'. Found: "<xsl:text/>
               <xsl:value-of select="@code"/>
               <xsl:text/>" (string(@code) = ('48767-8') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystem) = ('2.16.840.1.113883.6.1')"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): The value for codeSystem SHALL be '2.16.840.1.113883.6.1'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystem"/>
               <xsl:text/>" (string(@codeSystem) = ('2.16.840.1.113883.6.1') / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.10.110-2022-07-19T113514.html)</xsl:message>
         </xsl:otherwise>
      </xsl:choose>

		    <!--ASSERT error-->
      <xsl:choose>
         <xsl:when test="string(@codeSystemName) = ('LOINC') or not(@codeSystemName)"/>
         <xsl:otherwise>
            <xsl:message>(Annotazioniv2_PrS): The value for codeSystemName SHALL be 'LOINC'. Found: "<xsl:text/>
               <xsl:value-of select="@codeSystemName"/>
               <xsl:text/>" (string(@codeSystemName) = ('LOINC') or not(@codeSystemName) / error / <xsl:apply-templates select="." mode="schematron-select-full-path"/> / https://hl7itig.art-decor.pub/hl7itig-html-20230524T111430/tmp-2.16.840.1.113883.3.1937.777.63.